/***********************************************************************************************
   					wmsetimon
VERSION	: 0.5
DATE	: 08/11/02
AUTEUR	: redreb <redseb@goupilfr.org>
KESZITO : SilaS <silas@fornax.hu>
************************************************************************************************
   				   Ce programme est sous GPL.
***********************************************************************************************/



#include 	<sys/param.h>
#include 	<sys/types.h>
#include	<string.h>
#include	"standards.h"
#include 	<X11/Xlib.h>
#include 	<X11/xpm.h>
#include 	<X11/extensions/shape.h>
#include 	"../wmgeneral/wmgeneral.h"
#include 	"wmsetimon_master.xpm"
#include 	"wmsetimon_mask.xbm"

#define		VERSION		"0.5"
#define		RC_FILE		".wmsetimonrc"
#define		USER_INFO	"user_info.sah"
#define		STATE		"state.sah"
#define		PID		"pid.sah"
#define		EXE		"./setiathome"
#define		OPTIONS		"-nice"
#define		KW_POURCENT	"prog="
#define		KW_T_PASSE	"cpu="
#define		KW_NB_P		"nresults="
#define		KW_DIR		"dir="
#define		KW_NICE		"nice="
#define		KW_LOCAL	"local"
#define		KW_LOG		"log="
#define		X_PREC		33
#define		Y_PREC		48
#define		X_SUIV		46
#define		Y_SUIV		48
#define		X_DB		13
#define		Y_DB		11
#define		X_POWA		5
#define		Y_POWA		48
#define		X_DP		28
#define		Y_DP		11


#define		MAX_ITER	255

void	usage(void) ;
void 	stats(int) ;
int	est_actif(int) ;
void	lance_stop(int) ;
void 	affiche_num(char, char, char) ;
int	get_cfg(void) ;

typedef struct {
   				char mach[255] ;
   				char path[255] ;
   				int nice ;
                int	running ;
                pid_t	pid ;
                } process_t ;

process_t*	p[10] ;
int		nb_seti ;
int		nice_value = 0 ;
int		log_value = 0;

int	taille_KW_POURCENT ;
int	taille_KW_T_PASSE ;
int	taille_KW_NB_P ;

int main(int argc, char **argv)
{
   XEvent	Event ;
   int		cur = 0 ;
   int		cycle = 0 ;
   int		delay = 50000 ; 
   int		i  = 0,
      		i1 = 10,
      		i2 = 0,
                i3 = 10,
                i4 = 0,
                k  = 0 ;
      
   while(argc > i)
   {
      if(!strcmp(argv[i], "-c"))
      cycle = 1 ;
      if(!strcmp(argv[i], "-s"))
         if(i + 1 < argc)
            cur = atoi(argv[i + 1]) - 1 ;         
      if(!strcmp(argv[i], "-h"))
         usage() ;
      i ++ ;
   }

   taille_KW_POURCENT = strlen(KW_POURCENT) ;
   taille_KW_T_PASSE  = strlen(KW_T_PASSE) ;
   taille_KW_NB_P     = strlen(KW_NB_P) ;

   if(!(nb_seti = get_cfg()))
   {
      puts("Config file not found. You MUST have ~/"RC_FILE".") ;
      exit(0) ;
   }
   if(!(cur < nb_seti))
      cur = nb_seti - 1 ;

   openXwindow(argc,argv,wmsetimon_master_xpm,wmsetimon_mask_bits,wmsetimon_mask_width,wmsetimon_mask_height) ;

   while(1)	
   {
/*** EFFECTUE A CHAQUE FOIS */
      if(XCheckMaskEvent(display, ButtonPressMask, &Event))
      {
         if(Event.type == ButtonPress)
         {
            if(X_PREC <= Event.xbutton.x && Event.xbutton.x <= X_PREC + X_DB
            && Y_PREC <= Event.xbutton.y && Event.xbutton.y <= Y_PREC + Y_DB)
            {
               copyXPMArea(26,113,13,11,X_PREC,Y_PREC) ;
               RedrawWindow() ;
               cur -- ;
               if(cur < 0)
                  cur = nb_seti - 1 ;
               i3 = 10 ;
               i4 = 0 ;
            }
            if(X_SUIV <= Event.xbutton.x && Event.xbutton.x <= X_SUIV + X_DB
            && Y_SUIV <= Event.xbutton.y && Event.xbutton.y <= Y_SUIV + Y_DB)
            {
   	       copyXPMArea(39,113,13,11,X_SUIV,Y_SUIV) ;
               RedrawWindow() ;
               cur ++ ;
               if(cur == nb_seti)
                  cur = 0 ;
               i3 = 10 ;
               i4 = 0 ;
            }
            if(X_POWA <= Event.xbutton.x && Event.xbutton.x <= X_POWA + X_DP
            && Y_POWA <= Event.xbutton.y && Event.xbutton.y <= Y_POWA + Y_DP)
            {
               copyXPMArea(26,90,28,11,X_POWA,Y_POWA) ;
               RedrawWindow() ;
               lance_stop(cur) ;
               i3 = 10 ;
            }
         }
      }
/*** EFFECTUE TOUS LES 10 PASSAGES */
      if(i1 == 10)
      {
         if(p[cur]->running)
            copyXPMArea(0,78+k*22,22,22,6,6) ;
         copyXPMArea(5*(cur+1),64,5,9,23,19) ;
         if(i2)
         {
            copyXPMArea(44,72,1,4,18,36) ;
            copyXPMArea(44,72,1,4,47,36) ;      
         }
         else
         {
            copyXPMArea(45,72,1,4,18,36) ;
            copyXPMArea(45,72,1,4,47,36) ;
         }
/*** EFFECTUE TOUS LES 100 PASSAGES */
         if(i3 == 10)
         {
            if(i4 && cycle)
            {
               cur ++ ;
               if(cur >= nb_seti)
                  cur = 0 ;
            }
            stats(cur) ;
            i3 = 1 ;
            i4 = 1 - i4 ;
         }
         RedrawWindow() ;
         i2 = 1 - i2 ;
         i3 ++ ;
         if(k++ > 4)
            k = 0 ;
      }
      usleep(delay);
      if(i1++ > 10)
         i1 = 1 ;
   }
}  

int get_cfg(void)
{
   FILE*	fd ;
   char		path[255] ;
   char		temp[255] ;
   char		start[10] ;
   int		i = 0 ;

   sprintf(path, "%s/%s", getenv("HOME"), RC_FILE) ;
   if((fd = fopen(path, "r")))
   {
      while(fgets(temp, 255, fd) && i < 10)
      {
         if(temp[0] != '#' && temp[0] == 'd')
         {
            strcpy(start, "") ;
            p[i] = (process_t*)malloc(sizeof(process_t)) ;
            sscanf(temp, KW_DIR"%s %s %d %s", p[i]->mach, p[i]->path, &p[i]->nice, start) ;
            if(!strcmp(start, "start") && !est_actif(i))
               lance_stop(i) ;         
printf("%d: mach=%s path=%s nice=%d\n", i, p[i]->mach, p[i]->path, p[i]->nice);
            i ++ ;
         }
//         if(temp[0] != '#' && temp[0] == 'n')
//            sscanf(temp, KW_NICE"%d ", &nice_value) ; 
         if(temp[0] != '#' && temp[0] == 'l')
            sscanf(temp, KW_LOG"%d ", &log_value) ; 
      }
      fclose(fd) ;
   }
   return(i) ;
}



void lance_stop(int cur)
{
   char		exe[255] ;

   if(est_actif(cur))
   {
      kill(p[cur]->pid, 9) ;
      p[cur]->running = 0 ;
   }
   else
   {
      if (strncmp(p[cur]->mach, KW_LOCAL, strlen(KW_LOCAL)) == 0) {
	      chdir(p[cur]->path) ;
    	  sprintf(exe, "%s %s %d &", EXE, OPTIONS, nice_value) ;
	      system(exe) ;
      } else {
          sprintf(exe, "ssh %s \"%s %s %d &\"", p[cur]->mach, EXE, OPTIONS, p[cur]->nice) ;
          system(exe) ;
      }
      p[cur]->running = 1 ;
   }
}
      
int est_actif(int cur)
{
   FILE*	fd ;
   char		path[255] ;
   char		temp[255] ;
   pid_t	pid1 = 0 ;
   pid_t	pid2 = 0 ;
   
/*** LECTURE DU PID DU PROCESS */
   if (strncmp(p[cur]->mach, KW_LOCAL, strlen(KW_LOCAL)) == 0) {
      sprintf(path, "%s/%s", p[cur]->path, PID) ;
      fd = fopen(path, "r") ;
   } else {
      sprintf(path, "ssh %s \"cat %s/%s\"", p[cur]->mach, p[cur]->path, PID) ;
   if (log_value > 0) printf("pid: %s\n", path);
      fd = popen(path, "r") ;
   }
   fscanf(fd, "%d", &pid1) ;
   p[cur]->pid = pid1 ;
   fclose(fd) ;
/*** CHERCHE UN PROCESS AVEC CE PID */
   if (strncmp(p[cur]->mach, KW_LOCAL, strlen(KW_LOCAL)) == 0) {
      fd = popen("ps ax |grep setiathome |grep -v grep", "r") ;
   } else {
      sprintf(path, "ssh %s \"ps ax |grep setiathome |grep -v grep\"", p[cur]->mach) ;
   if (log_value > 0) printf("ps: %s\n", path);
      fd = popen(path, "r") ;
   }
   while(fgets(temp, 255, fd))
   {
      sscanf(temp, "%d", &pid2) ;
      if(pid1 == pid2)
      {
         pclose(fd) ;
         return(1) ;
      }
   }
   pclose(fd) ;
   return(0) ;
}

void stats(int cur)
{
   FILE*	fd ;
   char		path[255] ;
   char		temp[255] ;
   float	t_passe ;
   float	t_total ;
   float	pourcent ;
   int		nb ;
   int		i ;
   char      	milliers,
      		centaines,
                dizaines,
      		unites,
                heures,
                minutes ;

/*** TESTE SI PROCESS ACTIF */
   p[cur]->running = est_actif(cur) ;
/*** REMISE A ZERO DES BOUTONS ET DE L'ANIM */
   if(!p[cur]->running)
      copyXPMArea(26,125,22,22,6,6) ;
   copyXPMArea(5*(cur+1),64,5,9,23,19) ;
   copyXPMArea(26,102,13,11,X_PREC,Y_PREC) ;
   copyXPMArea(39,102,13,11,X_SUIV,Y_SUIV) ;
   copyXPMArea(26,79,28,11,X_POWA,Y_POWA) ;
/*** LECTURE DU TEMPS PASSE ET DU POURCENTAGE */
   if (strncmp(p[cur]->mach, KW_LOCAL, strlen(KW_LOCAL)) == 0) {
       sprintf(path, "%s/%s", p[cur]->path, STATE) ;
       if(!(fd = fopen(path, "r")))
          return ;
       i = MAX_ITER ;
   } else {
       sprintf(path, "ssh %s \"cat %s/%s\"", p[cur]->mach, p[cur]->path, STATE) ;
   if (log_value > 0) printf("stat: %s\n", path);
       if(!(fd = popen(path, "r")))
          return ;
       i = MAX_ITER ;
   }
   if (log_value > 0) printf("TICK\n");
   do
   {
      fgets(temp, 255, fd) ;
      i -- ;
   }
   while(strncmp(temp, KW_T_PASSE, taille_KW_T_PASSE) && i) ;
   if(i)
      sscanf(temp, KW_T_PASSE"%f", &t_passe) ;
   else
      t_passe = 0.0 ;
   i = MAX_ITER ;
   do
   {
      fgets(temp, 255, fd) ;
      i -- ;
   }
   while(strncmp(temp, KW_POURCENT, taille_KW_POURCENT) && i) ;
   fclose(fd) ;
   if(i)
      sscanf(temp, KW_POURCENT"%f", &pourcent) ;
   else
   {
      pourcent = 100.0 ;
      sprintf(temp, "%s0", KW_POURCENT) ;
   }
   if(temp[taille_KW_POURCENT] == '1')
   {
      copyXPMArea(5,64,5,9,35,19) ;      
      copyXPMArea(0,64,5,9,41,19) ;
      copyXPMArea(0,64,5,9,47,19) ;
   }
   else
   {
      copyXPMArea(50,64,5,9,35,19) ;      
      dizaines	= (temp[taille_KW_POURCENT+2] - '0') ;
      unites	= (temp[taille_KW_POURCENT+3] - '0') ;
      if(dizaines)
         copyXPMArea(5*dizaines,64,5,9,41,19) ;
      else
         copyXPMArea(50,64,5,9,41,19) ;
      copyXPMArea(5*unites,64,5,9,47,19) ;
   }
/*** CALCUL DU TEMPS PASSE/TEMPS TOTAL */   
   heures  = t_passe / 3600 ;
   minutes = (t_passe - (heures * 3600)) / 60 ;
   t_total = t_passe / pourcent ;
   affiche_num(heures, minutes, 6) ;
   heures  = t_total / 3600 ;
   minutes = (t_total - (heures * 3600)) / 60 ;
   affiche_num(heures, minutes, 35) ;
/*** LECTURE DU NOMBRE DE PACKETS RENVOYES */
   if (strncmp(p[cur]->mach, KW_LOCAL, strlen(KW_LOCAL)) == 0) {
      sprintf(path, "%s/%s", p[cur]->path, USER_INFO) ;
      fd = fopen(path, "r") ;
      i = MAX_ITER ;
   } else {
       sprintf(path, "ssh %s \"cat %s/%s\"", p[cur]->mach, p[cur]->path, USER_INFO) ;
   if (log_value > 0) printf("stat: %s\n", path);
       if(!(fd = popen(path, "r")))
          return ;
       i = MAX_ITER ;
   }
   do
   {
      fgets(temp, 255, fd) ;
      //i -- ;
   }
   while(strncmp(temp, KW_NB_P, taille_KW_NB_P) && i) ;
   if(i)
      sscanf(temp, KW_NB_P"%d", &nb) ;
   else
      nb = 0 ;
   sprintf(temp, "%04d", nb) ;
   milliers	= (temp[0] - '0') ;
   centaines	= (temp[1] - '0') ;
   dizaines	= (temp[2] - '0') ;
   unites	= (temp[3] - '0') ;
   if(milliers)
      copyXPMArea(5*milliers,64,5,9,35,5) ;
   else
      copyXPMArea(50,64,5,9,35,5) ;
   if(centaines || milliers)
      copyXPMArea(5*centaines,64,5,9,41,5) ;
   else
      copyXPMArea(50,64,5,9,41,5) ;
   if(dizaines || centaines || milliers)
      copyXPMArea(5*dizaines,64,5,9,47,5) ;
   else
      copyXPMArea(50,64,5,9,47,5) ;
   copyXPMArea(5*unites,64,5,9,53,5) ;
   
   fclose(fd) ;
}
   
void affiche_num(char h, char m, char offset)
{
   char	        texte[3],
      		dizaines,
      		unites ;
/*** AFFICHAGE DES HEURES */
   sprintf(texte, "%02d", h) ;
   dizaines	= (texte[0] - '0') ;
   unites	= (texte[1] - '0') ;
   copyXPMArea(5*dizaines,64,5,9,offset,33) ;
   copyXPMArea(5*unites,64,5,9,6+offset,33) ;
/*** AFFICHAGE DES MINUTES */
   sprintf(texte, "%02d", m) ;
   dizaines	= (texte[0] - '0') ;
   unites	= (texte[1] - '0') ;
   copyXPMArea(4*dizaines,72,4,6,14+offset,35) ;
   copyXPMArea(4*unites,72,4,6,19+offset,35) ;
}


void usage(void)
{
   puts("\nwmsetimon "VERSION" - monitoring applet for (multi) seti@home process.\n"
        "Options : -h    this help screen.\n"
        "          -c    cycle processes (display each process few seconds).\n"
        "          -s X  start with the process X displayed.\n"
        "<redseb@goupilfr.org> http://www.goupilfr.org\n"
        ) ;
   exit(OK) ;
}  

