/*
Copyright (C) 1998, 1999, 2000 Wabasoft

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later version. 

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details. 

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA. 
*/

/*
Copyright (C) 2000, 2001 SMARTDATA, http://www.smartdata.ch/

More help for porting is include in the file nmport_b.c. Please read it before
porting or modify this port.

Linux port.
===========

*/

#include <sys/time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "../waba.h"

WObject globalMainWin = 0;

/* the size/properties of the MainWindow */
int32 hwr_bpp    =  32;
int32 hwr_width  = 160;
int32 hwr_height = 160;

static int32 globalTimerInterval = 0;
static int32 globalTimerStart = 0;
static int classDbCount = 0;
static ULong appCreatorId;
static Word globalSocketLibRefNum;
static int globalNetState = NET_NOT_READY_FOR_OPEN;

/*************************************/

#ifdef QUICKBIND
static int32 postEventMethodMapNum = -1;
static int32 onTimerTickMethodMapNum = -1;
#endif

int isApplication = FALSE;

HELPER void * ui_init() {

  void *forReturn;

  if( ! is_ui_inited ) {
    forReturn = hwr_init();
    input_init(NULL);
    is_ui_inited = 1;
    return forReturn;

  } else {

    return NULL;

  }
}

HELPER void ui_exit(int code)
{
  if (is_ui_inited) {
    input_release();
    hwr_release();
  }
  is_ui_inited = 0;
  exit(code);
}

#ifdef WITH_THREAD

//*** Isao's Multithread implementation START ***
// Thread variables - Isao F. Yamashita 07/25/2000
//*** This "_onThreadStart()" method is called from "start()" method.
Var ThreadStart(Var stack[]) {
}

//*** This "_onThreadStop()" method is called from "stop()" method.
Var ThreadStop(Var stack[]) {
}

//*** This "_onThreadSleep()" method is called from "sleep()" method.
Var ThreadSleep(Var stack[]) {
}



//*** This "_onThreadWait()" method is called from "wait()" method.
Var ThreadWaitForSignal(Var stack[]) {
}

Var ThreadSignalAll(Var stack[]) {
}

//*** Isao's Multithread implementation END ***

#endif

HELPER int32 getTimeStamp()
{ // SD
  struct timeval now;
  static uint32 maxStamp = 1 << 30;

  (void)gettimeofday(&now, (struct timezone *)0);
  return ( (now.tv_sec * 1000) + (now.tv_usec / 1000) ) % maxStamp;
}



void drawErrorWin()
{ // SD
  char buf[256];
  int len;
  char *msg;

  extern char *errorMessages[];

  printf("An error was found in the program being\n"
	 "run by the WabaVM.\n\n"
	 "Error: ");

  msg = errorMessages[vmStatus.errNum - 1];
  if (msg)
    printf("%s ", msg);

  msg = vmStatus.arg1;
  if (msg[0])
    printf("%s ", msg);

  msg = vmStatus.arg2;
  if (msg[0])
    printf("%s ", msg);

  if (vmStatus.className[0] || vmStatus.methodName[0])
    printf("in\n");

  msg = vmStatus.className;
  if (msg[0])
    printf("%s", msg);

  msg = vmStatus.methodName;
  if (msg[0])
    printf(".%s\n", msg);

  if (vmStatus.errNum != ERR_CantAccessCoreClasses) {
    printf("Please notify the program's author.\n");
    if (isApplication)
      printf("(Or maybe it is a MainWindow application ? "
	     "try without the -a option)\n");
    else
      printf("(Or maybe it is a console application ? "
	     "try with the -a option)\n");
  }
  else
    printf("The WabaVM is not fully installed.\n");

  //PostQuitMessage(0);
  printf("*** EXITTING ***\n");
  ui_exit(1);
}


void drawMainWin()
{ // SD
  WObject mainWinObj;
  WClass *vclass;
  WClassMethod *method;
  Var params[7];

  mainWinObj = globalMainWin;
  if (!mainWinObj)
    return;
  //WinEraseWindow();
  vclass = WOBJ_class(mainWinObj); // get runtime class
  method = getMethod(vclass, createUtfString("_doPaint"),
		     createUtfString("(IIII)V"), &vclass);
  if (method == NULL)
    return;
  params[0].obj = mainWinObj;
  params[1].intValue = 0; // x
  params[2].intValue = 0; // y
  params[3].intValue = hwr_width; // width
  params[4].intValue = hwr_height; // height

  executeMethod(vclass, method, params, 5);
}


HELPER void timerCheck()
{ // SD
  WObject mainWinObj;
  int32 now, diff;
  WClass *vclass;
  WClassMethod *method;
  Var params[1];
  printf( "...\n" );
  mainWinObj = globalMainWin;
  if (!mainWinObj)
    return;
  now = getTimeStamp();
  diff = now - globalTimerStart;
  if (diff < 0)
    diff += (1L << 30); // max stamp is (1 << 30)
  if (diff < globalTimerInterval)
    return;
  vclass = WOBJ_class(mainWinObj); // get runtime class
#ifdef QUICKBIND
  method = getMethodByMapNum(vclass, &vclass,
			     (uint16)onTimerTickMethodMapNum);
#else
  method = getMethod(vclass, createUtfString("_onTimerTick"),
		     createUtfString("()V"), &vclass);
#endif
  if (method != NULL)
    {
      params[0].obj = mainWinObj;
      executeMethod(vclass, method, params, 1);
    }
  globalTimerStart = now;
}


int handleMainWinEvent(struct ui_Event *event)
{
  WObject mainWinObj;
  WClass *vclass;
  WClassMethod *method;
  Var params[7];
  int quit = 0;
  int32 type, x, y;

  mainWinObj = globalMainWin;
  if (!mainWinObj)
    return;

  switch (event->type) {
  case quitEvent:
    DPUTS("EVT: Quit");
    quit = 1;
    break;

  case penUpEvent:
  case penDownEvent:
  case penMoveEvent: {

    x = event->x;
    y = event->y;

    if (event->type == penDownEvent) {

      type = WABA_EVENT_PEN_DOWN;

    } else if (event->type == penUpEvent)
      type = WABA_EVENT_PEN_UP;
    else
      type = WABA_EVENT_PEN_MOVE;

    vclass = WOBJ_class(mainWinObj); // get runtime class
#ifdef QUICKBIND
    method = getMethodByMapNum(vclass, &vclass,
			       (uint16)postEventMethodMapNum);
#else
    method = getMethod(vclass, createUtfString("_postEvent"),
		       createUtfString("(IIIIII)V"), &vclass);
#endif
    if (method != NULL) {
      params[0].obj = mainWinObj;
      params[1].intValue = type; // type
      params[2].intValue = 0; // key
      params[3].intValue = x; // x
      params[4].intValue = y; // y
      params[5].intValue = 0; // modifiers
      params[6].intValue = 0; // timeStamp
      executeMethod(vclass, method, params, 7);
    }
    break;
  }
  case keyDownEvent:
  case keyUpEvent:
    if( event->type == keyUpEvent ) {

      DPUTS("EVT: KEY_RELEASE -> NOT USED");

    } else  {

    int32 type, key, x, y;
    Word chr;

    x = event->x;
    y = event->y;

    type = WABA_EVENT_KEY_PRESS;

    key = ui_TranslateKey( event->code );

    vclass = WOBJ_class(mainWinObj); // get runtime class
#ifdef QUICKBIND
    method = getMethodByMapNum(vclass, &vclass,
			       (uint16)postEventMethodMapNum);
#else
    method = getMethod(vclass, createUtfString("_postEvent"),
		       createUtfString("(IIIIII)V"), &vclass);
#endif
    if (method != NULL) {
      params[0].obj = mainWinObj;
      params[1].intValue = type; // type
      params[2].intValue = key; // key
      params[3].intValue = 0; // x
      params[4].intValue = 0; // y
      params[5].intValue = 0; // modifiers
      params[6].intValue = 0; // timeStamp
      executeMethod(vclass, method, params, 7);
    }
    break;
  }

  case timerEvent: {
    int32 type, key, x, y;
    Word chr;

    x = event->x;
    y = event->y;

    type = 111; // KeyEvent.KEY_PRESS  AAAAAAAAAA UPDATER AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
    chr = event->code;
    key = 0;

    // NOTE: This routine will only get called for main windows since
    // only those call SetTimer()

    vclass = WOBJ_class(mainWinObj); // get runtime class
#ifdef QUICKBIND
    method = getMethodByMapNum( vclass, &vclass,
				(uint16)onTimerTickMethodMapNum );
#else
    method = getMethod(vclass, createUtfString("_onTimerTick"),
		       createUtfString("()V"), &vclass);
#endif
    if (method != NULL) {
      params[0].obj = mainWinObj;
      params[1].intValue = type; // type
      params[2].intValue = key; // key
      params[3].intValue = 0; // x
      params[4].intValue = 0; // y
      params[5].intValue = 0; // modifiers
      params[6].intValue = 0; // timeStamp
      executeMethod(vclass, method, params, 7);
    }
    break;
  }

  default:
    DPRINTF( "??? EVENT NOT TREATED (%d) !!!\n", event->type );
    break;
  }

  return quit;
}


void usage(void)
{
  printf("usage: waba [options] [classfile [args]]\n\n");
  printf("Options are:\n");
  printf("  -h, --help                    Display help and exit\n");
  printf("  -a, --as-application          Run void main(String[] args)\n");
  printf("                                  "
	 "instead of void MainWindow.onStart()\n");
  printf("  -x, --width                   Set horizontal size of the Main Window\n");
  printf("                                  "
	 "default to %d\n", hwr_width);
  printf("  -y, --height                  Set vertical size of the Main Window\n");
  printf("                                  "
	 "default to %d\n", hwr_height);
  printf("  -l, --class-heap-size <num>   Set class heap size\n");
  printf("  -m, --object-heap-size <num>  Set object heap size\n");
  printf("  -s, --vm-stack-size <num>     Set vm stack size\n");
  printf("  -t, --nm-stack-size <num>     Set native methods stack size\n");
}

WObject startApp(int argc, char** argv)
{
  char *className;
  ULong vmStackSize, nmStackSize, classHeapSize, objectHeapSize;
  int i, j, n;
  int appArgc = 0;
  char** appArgv;
  char *cp;
  char *p;

  // defaults
  isApplication = false;
  vmStackSize = 1500;
  nmStackSize = 300;
  classHeapSize = 14000;
  objectHeapSize = 8000;

  // NOTE: We need VoidHand to fall on a byte boundry for our xmalloc()
  // routine to work correctly (see xmalloc())
  if (sizeof(VoidHand) % 4 != 0) {
    VmQuickError(ERR_SanityCheckFailed);
    return 0;
  }

  // parse options
  i = 1;
  while (i<argc && argv[i][0]=='-') {
    int hasArg = i+1<argc;
    int hasNArg = hasArg && (argv[i+1][0]>='0' && argv[i+1][0]<='9');
    ULong val = hasNArg ? atoi(argv[i+1]) : 0;
    int argl = xstrlen(argv[i]);

    if ((!xstrncmp(argv[i],"-l",argl) ||
	 !xstrncmp(argv[i],"--class-heap-size",argl))
	&& hasNArg) {
      classHeapSize = val;
      ++i;
    }
    else if ((!xstrncmp(argv[i],"-m",argl) ||
	      !xstrncmp(argv[i],"--object-heap-size",argl))
	     && hasNArg) {
      objectHeapSize = val;
      ++i;
    }
    else if ((!xstrncmp(argv[i],"-s",argl) ||
	      !xstrncmp(argv[i],"--vm-stack-size",argl))
	     && hasNArg) {
      vmStackSize = val;
      ++i;
    }
    else if ((!xstrncmp(argv[i],"-t",argl) ||
	      !xstrncmp(argv[i],"--nm-stack-size",argl))
	     && hasNArg) {
      nmStackSize = val;
      ++i;
    }
    else if (!xstrncmp(argv[i],"-a",argl) ||
	     !xstrncmp(argv[i],"--as-application",argl)) {
      isApplication = true;
    }
    else if ((!xstrncmp(argv[i],"-x",argl) ||
	      !xstrncmp(argv[i],"--width",argl))
	     && hasNArg) {
      hwr_width = val;
      ++i;
    }
    else if ((!xstrncmp(argv[i],"-y",argl) ||
	      !xstrncmp(argv[i],"--height",argl))
	     && hasNArg) {
      hwr_height = val;
      ++i;
    }
    else if (!xstrncmp(argv[i],"-h",argl) ||
	     !xstrncmp(argv[i],"--help",argl)) {
      usage();
      exit(0);
    }
    else {
      printf("waba: bad option '%s'\n\n", argv[i]); 
      usage();
      exit(1);
    }
    ++i;
  }
  
  if (i<argc) {
    className = argv[i];
    appArgc = argc-i-1;
    appArgv = &argv[i+1];
  }
  else {
#if 0
    if(isApplication) {
      printf("waba: isApplication option requires a classfile name\n\n"); 
      usage();
      exit(1);
    }
#endif
    className = "waba/ui/Welcome";
  }

  cp = (char*)getenv("CLASSPATH");

  // This one also gets freed by the system:
  classpath = xmalloc((cp?strlen(cp):0) + strlen(className) + 100);
  if (classpath==0) {
    printf("*** Memory error ***\n");
    exit(1);
  }
  *classpath = '\0';

  // Put dir of invoked class in path
  strcat(classpath, className);
  p = (char*)strrchr(classpath, '/');
  if (p)
    *p = 0;
  strcat(classpath, ":");

  // add CLASSPATH
  if (cp && strlen(cp)) {
    strcat(classpath, cp);
    strcat(classpath, ":");
  }
  else {
    // CLASSPATH unset, try a relative location
    strcat(classpath, "classes;");
  }

  DPRINTF("class:     [%s]\n", className);
  DPRINTF("classpath: [%s]\n", classpath);
  DPRINTF("vmStackSize    = %d\n", vmStackSize);
  DPRINTF("nmStackSize    = %d\n", nmStackSize);
  DPRINTF("classHeapSize  = %d\n", classHeapSize);
  DPRINTF("objectHeapSize = %d\n", objectHeapSize);
  DPRINTF("isApplication  = %d\n", isApplication);
  DPRINTF("arguments      = %d\n", appArgc);

#ifdef DEBUG
    if (appArgc) {
      int j;
      for (j=0; j<appArgc; ++j) {
	DPRINTF("  v[%d] = \"%s\"\n", j, appArgv[j]);
      }
    }
#endif

  DPRINTF("\n");

  DPRINTF("startApp(): calling VMInit\n");
  VmInit(vmStackSize, nmStackSize, classHeapSize, objectHeapSize);

  if (isApplication) {
    DPRINTF("startApp(): calling VmStartApplication\n");
    VmStartApplication(className, appArgc, appArgv);
    return 0;
  }
  else {
    DPRINTF("startApp(): calling VmStartApp\n");
    return  VmStartApp(className);
  }
}

void stopApp(WObject mainWinObj)
{
  uint32 i;

  VmStopApp(mainWinObj);
  VmFree();

  // free memory mapped files
  /****
  for (i = 0; i < numMemFiles; i++)
    freeMemMapFile(&memFiles[i]);
  ***/
}




uchar *loadFromMem(char *path, uint32 pathLen, uint32 *size)
{
  /***********************************
  uchar *baseP, *offP, *p;
  uint32 i, off, nextOff, top, bot, mid;
  uint32 nameLen, minLen, numRecs;
  int cmp;

  // look in memory mapped files
  for (i = 0; i < numMemFiles; i++) {
    baseP = memFiles[i].ptr;
    numRecs = getUInt32(baseP + 4);
    if (numRecs == 0)
      continue;
    // NOTE: We do a binary search to find the class. So, a search
    // for N classes occurs in O(nlogn) time.
    top = 0;
    bot = numRecs;
    while (1) {
      mid = (bot + top) / 2;
      offP = baseP + 8 + (mid * 4);
      off = getUInt32(offP);
      p = baseP + off;
      nameLen = getUInt16(p);
      p += 2;
      if (pathLen > nameLen)
	minLen = nameLen;
      else
	minLen = pathLen;
      cmp = xstrncmp(path, p, minLen);
      if (!cmp) {
	if (pathLen == nameLen) {
	  if (size != NULL) {
	    nextOff = getUInt32(offP + 4);
	    *size = nextOff - off - nameLen - 2;
	  }
	  return p + nameLen;
	}
	if (pathLen > nameLen)
	  cmp = 1;
	else
	  cmp = -1;
      }
      if (mid == top)
	break; // not found
      if (cmp < 0)
	bot = mid;
      else
	top = mid;
    }
  }
  ******************************/
  return NULL;
}

uchar *readFileIntoMemory(char *path, int nullTerminate, uint32 *size)
{
  int fileDesc;
  ssize_t lenRead, len;
  struct stat st;
  uchar *p;

  //DPUTS("readFileIntoMemory()");
  //DPRINTF("path: [%s]\n", path);

  if (nullTerminate != 0)
    nullTerminate = 1;

  if (stat(path, &st) != 0) {
    return NULL;
  }

  fileDesc = open(path, O_RDONLY);
  if (fileDesc == -1)
    return NULL;

  len = st.st_size;

  if (size)
    *size = len + nullTerminate;

  p = (uchar *)xmalloc(len + nullTerminate);

  if (p != NULL) {
    lenRead = read(fileDesc, p, len);
    if (len != lenRead) {
      xfree(p);
      p = NULL;
    }
  }
  else
    VmQuickError(ERR_CantAllocateMemory);

  if (p && nullTerminate)
    p[len] = 0;

  close(fileDesc);

  //DPRINTF("readFileIntoMemory(): returning %p\n", p);
  return p;
}


uchar *nativeLoadClass(UtfString className, uint32 *size)
{
  uchar *p;
  uint16 len, i;
  char path[128];

  // try loading from memory mapped files first
  // make full path by appending .class
  len = className.len + 6;
  if (len > 128)
    return NULL;
  xstrncpy(path, className.str, className.len);
  xstrncpy(&path[className.len], ".class", 6);

  p = loadFromMem(path, len, size);
  if (p != NULL)
    return p;

  // not found in memory mapped files, try loading it from the CLASSPATH
  if (numClassPaths == -1) {
    char *s, *sp;
    
    classPaths[0] = ".";
    numClassPaths = 1;
    s = classpath; //(char*)getenv("CLASSPATH");
    if (s != NULL) {
      // NOTE: we duplicate the CLASSPATH here since strtok() modifies
      // it but we never explicitly free it, we let the OS free it when
      // the program exits. Also note we don't need to deal with UNICODE
      // since this section does not applicable to WinCE
      i = xstrlen(s);
      sp = (char*)xmalloc(i + 1);
      xstrncpy(sp, s, i);
      sp[i] = 0;
      s = sp;
      
      // parse through the elements of CLASSPATH
      sp = (char*)strtok(s, ":");
      while (sp != NULL) {
	classPaths[numClassPaths++] = sp;
	if (numClassPaths == MAX_CLASSPATHS)
	  break;
	sp = (char*)strtok(NULL, ":");
      }
    }
  }

  // NOTE: we never free the memory pointers we allocate here. We let the
  // OS clean up memory when the process exits. This works well but if we
  // ever do free these pointers, we need to make sure we differentiate
  // them from the memory mapped file pointers (nativeLoadClassFromMem())
  for (i = 0; i < numClassPaths; i++) {
    strcpy(path, classPaths[i]);
    if (path[strlen(path)-1] != '/')
      strcat(path, "/");
    len = strlen(path); 
    strncpy(&path[len], className.str, (size_t)className.len);
    path[len+className.len] = 0; // because className.str not null-terminated
    len = strlen(path);

    if (len>6 && strcmp(&path[len-6], ".class")!=0 )
      strcat(path, ".class");

    p = readFileIntoMemory(path, 0, size);
    if (p != NULL)
      break;

  }
  if (p == NULL)
    return NULL;
  // validate
  if (getUInt32(p) != (uint32)0xCAFEBABE) {
    VmError(ERR_BadClass, NULL, &className, NULL);
    xfree(p);
    return NULL;
  }

  //DPRINTF("nativeLoadClass(): returning %p\n", p);
  return p;
}



PUBLIC int main(int argc, char** argv)
{
  WObject mainWinObj;
  unsigned short err;


  // NOTE: set vmStatus to 0 since we may not call VmInit() if there
  // is an device compatibility error or error accessing a class database
  xmemzero((uchar *)&vmStatus, sizeof(vmStatus));

  mainWinObj = startApp(argc, argv);

#ifdef QUICKBIND
  if (mainWinObj != 0) {
      WClass *vclass;

      // cache method map numbers for commonly called methods
      vclass = WOBJ_class(mainWinObj);
      postEventMethodMapNum =
	getMethodMapNum(vclass, createUtfString("_postEvent"),
			createUtfString("(IIIIII)V"), SEARCH_ALL);
      onTimerTickMethodMapNum =
	getMethodMapNum(vclass, createUtfString("_onTimerTick"),
			createUtfString("()V"), SEARCH_ALL);
      if (postEventMethodMapNum == -1 || onTimerTickMethodMapNum == -1)
	mainWinObj = 0;
    }
#endif

  if (!isApplication && mainWinObj == 0)
    VmQuickError(ERR_CantAccessAppClasses);

  // NOTE: we don't get any OS level window repaint events after the program has
  // started because PalmOS uses save-unders when it pops up windows on top of
  // this one (for alerts, launch win, etc.)
  if (vmStatus.errNum == 0)
    drawMainWin();
  else
    drawErrorWin();

  globalNetState = NET_READY_FOR_OPEN;
  if (!isApplication) {

    ui_MainLoop();

  }
  stopApp(mainWinObj);

  if (globalNetState == NET_IS_OPEN)
    ; // TODO: NetLibClose(globalSocketLibRefNum, false);

  ui_exit(0);
}

/*
   Local Variables:
   c-file-style: "smartdata"
   End:
*/
