#!/usr/local/bin/perl
# show.cgi
# Output some file for the browser

require './file-lib.pl';
&ReadParse();
use POSIX;
$p = $ENV{'PATH_INFO'};
if ($in{'type'}) {
	# Use the supplied content type
	$type = $in{'type'};
	}
elsif ($in{'format'} == 1) {
	# Type comes from compression format
	$type = "application/zip";
	}
elsif ($in{'format'} == 2) {
	$type = "application/x-gzip";
	}
elsif ($in{'format'} == 3) {
	$type = "application/x-tar";
	}
else {
	# Try to guess type from filename
	if ($p =~ /\.([^\.\/]+)$/) {
		$ext = lc($1);
		&get_miniserv_config(\%miniserv);
		open(MIME, $miniserv{'mimetypes'});
		while(<MIME>) {
			s/#.*//g;
			if (/(\S+)\s+(.*)/) {
				foreach $e (split(/\s+/, $2)) {
					if ($ext eq $e) {
						$type = $1;
						last;
						}
					}
				}
			}
		close(MIME);
		}
	if (!$type) {
		# No idea .. use the 'file' command
		if (`file "$p"` =~ /text|script/) {
			$type = "text/plain";
			}
		else {
			$type = "application/unknown";
			}
		}
	}

# Dump the file
&switch_acl_uid_and_chroot();
if (!&can_access($p)) {
	# ACL rules prevent access to file
	&error_exit(&text('view_eaccess', $p));
	}

if ($in{'format'}) {
	# An archive of a directory was requested .. create it
	$archive || &error_exit($text{'view_earchive'});
	if ($in{'format'} == 1) {
		$p =~ s/\.zip$//;
		}
	elsif ($in{'format'} == 2) {
		$p =~ s/\.tgz$//;
		}
	elsif ($in{'format'} == 3) {
		$p =~ s/\.tar$//;
		}
	-d $p || &error_exit($text{'view_edir'}." ".$p);
	if ($archive == 2 && $archmax > 0) {
		# Check if directory is too large to archive
		local $kb = &disk_usage_kb($p);
		if ($kb*1024 > $archmax) {
			&error_exit(&text('view_earchmax', $archmax));
			}
		}

	# Work out the base directory and filename
	local $temp = &tempname();
	if ($p =~ /^(.*\/)([^\/]+)$/) {
		$pdir = $1;
		$pfile = $2;
		}
	else {
		$pdir = "/";
		$pfile = $p;
		}

	# Work out the command to run
	if ($in{'format'} == 1) {
		&has_command("zip") || &error_exit(&text('view_ecmd', "zip"));
		$cmd = "zip -r $temp ".quotemeta($pfile);
		}
	elsif ($in{'format'} == 2) {
		&has_command("tar") || &error_exit(&text('view_ecmd', "tar"));
		&has_command("gzip") || &error_exit(&text('view_ecmd', "gzip"));
		$cmd = "tar cf - ".quotemeta($pfile)." | gzip -c >$temp";
		}
	elsif ($in{'format'} == 3) {
		&has_command("tar") || &error_exit(&text('view_ecmd', "tar"));
		$cmd = "tar cf $temp ".quotemeta($pfile);
		}

	if ($in{'test'}) {
		# Don't actually do anything if in test mode
		&ok_exit();
		}

	# Run the command, and send back the resulting file
	local $qpdir = quotemeta($pdir);
	local $out = `cd $qpdir ; ($cmd) 2>&1 </dev/null`;
	if ($?) {
		unlink($temp);
		&error_exit(&text('view_ecomp', $out));
		}
	local @st = stat($temp);
	print "Content-length: $st[7]\n";
	print "Content-type: $type\n\n";
	open(FILE, $temp);
	while(read(FILE, $buf, 1024)) {
		print $buf;
		}
	close(FILE);
	unlink($temp);
	}
else {
	if (!open(FILE, $p)) {
		# Unix permissions prevent access
		&error_exit(&text('view_eopen', $p, $!));
		}

	if ($in{'test'}) {
		# Don't actually do anything if in test mode
		close(FILE);
		&ok_exit();
		}

	@st = stat($p);
	print "X-no-links: 1\n";
	print "Content-length: $st[7]\n";
	print "Content-type: $type\n\n";
	if ($type =~ /^text\/html/i && !$in{'edit'}) {
		while(read(FILE, $buf, 1024)) {
			$data .= $buf;
			}
		print &filter_javascript($data);
		}
	else {
		while(read(FILE, $buf, 1024)) {
			print $buf;
			}
		}
	close(FILE);
	}

sub error_exit
{
print "Content-type: text/plain\n";
print "Content-length: ",length($_[0]),"\n\n";
print $_[0];
exit;
}

sub ok_exit
{
print "Content-type: text/plain\n\n";
print "\n";
}

