// Copyright (c) 1997,1998,1999,2000 Albrecht Kleine    All rights reserved
// file version #300

#include "tyaconfig.h"
#include <stdio.h>
#include <native.h>
#include <monitor.h>
#include "tya.h"


#ifdef JDK12
 #define EXC_OFF 16
#else
 #define EXC_OFF 12
#endif

//------- compile exception throwing & handling during runtime ------------

static const char* jlAEbyZero ="/ by zero";
static const char* jlStringSig="(Ljava/lang/String;)";
static const char* jlIntSig   ="(I)";
static const char* jlVoidSig  ="()";
       const char* exDetail   ="(details not yet available)";

static const char* jlArithmeticEx   ="java/lang/ArithmeticException";
static const char* jlAIOutOfBoundsEx="java/lang/ArrayIndexOutOfBoundsException";
static const char* jlNegArraySizeEx ="java/lang/NegativeArraySizeException";
static const char* jlNullPointerEx  ="java/lang/NullPointerException";
static const char* jlOutOfMemoryErr ="java/lang/OutOfMemoryError";
static const char* jlLinkageError   ="java/lang/LinkageError";
static const char* jlArrayStoreEx   ="java/lang/ArrayStoreException";
static const char* jlClassCastEx    ="java/lang/ClassCastException";
static const char* jlStackOvErr	    ="java/lang/StackOverflowError";
static const char* jlIncompErr	    ="java/lang/IncompatibleClassChangeError";

#ifdef EXT_ERR
static const char* jlIllegalAcc	    ="java/lang/IllegalAccessError";
#endif

static HObject* CreateExceptObject(int param,int excnr);
static void CompPrepareLinkageError(struct CINFO* cinfo);
static void CompPrepareThrowDivZeroException(struct CINFO* cinfo);
static void CompPrepareThrowArrOutOfBoundsException(struct CINFO* cinfo);
static void CompPrepareThrowNegArraySizeException(struct CINFO* cinfo);
static void CompPrepareThrowNullPointerException(struct CINFO* cinfo);
static void CompPrepareOutOfMemoryException(struct CINFO* cinfo);
static void CompPrepareArrayStoreException(struct CINFO* cinfo);
static void CompPrepareClassCastException(struct CINFO* cinfo);
static void CompPrepareAthrowException(struct CINFO* cinfo);
static void CompPrepareIncompatibleClassChangeError(struct CINFO* cinfo);
static void CompPrepareExceptionFromInvoked(struct CINFO* cinfo);
static char* CompCommonPartofException(struct CINFO* cinfo);

static int Myis_subclass_of(ClassClass *cb, ClassClass *dcb, int dummy, ExecEnv *ee);
HObject *StOvExc;

/*
 * new in version 0.8:
 * (updated in version 1.5)
 * we are using a new memory layout at the beginning of code.
 * 
 * this is important to understand coding like this:
 *   CB(CALL);
 *   CL(cinfo->codebase-cinfo->cptr-4+LINKAGEERRHSIZE  
 *     + DIVZEROHANDSIZE+ARROUTOFFSIZE+NEGARRSIZESIZE+NULLPTRSIZE);
 *   (example taken from CompTriggerOutOfMemoryException() )
 *
 * 
 * Nr.	Address			Code produced by
 * ===	=======			================
 * 0	0			CompPrepareLinkageError (jumps to CommonPart)
 * 
 * 1	LINKAGEERRHSIZE		CompPrepareThrowDivZeroException (jumps to CommonPart)
 * 
 * 2	LINKAGEERRHSIZE
 * 	  +DIVZEROHANDSIZE	CompPrepareThrowArrOutOfBoundsException (jumps to CommonPart)
 * 
 * 3	LINKAGEERRHSIZE
 *  	  +DIVZEROHANDSIZE
 *   	  +ARROUTOFFSIZE	CompPrepareThrowNegArraySizeException (jumps to CommonPart)
 * 
 * 4	LINKAGEERRHSIZE
 * 	  +DIVZEROHANDSIZE
 * 	  +ARROUTOFFSIZE
 * 	  +NEGARRSIZESIZE	CompPrepareThrowNullPointerException (jumps to CommonPart)
 * 
 * 5	LINKAGEERRHSIZE
 * 	  +DIVZEROHANDSIZE
 * 	  +ARROUTOFFSIZE
 * 	  +NEGARRSIZESIZE
 * 	  +NULLPTRSIZE		CompPrepareOutOfMemoryException (jumps to CommonPart)
 * 
 * 6	LINKAGEERRHSIZE
 * 	  +DIVZEROHANDSIZE
 * 	  +ARROUTOFFSIZE
 * 	  +NEGARRSIZESIZE
 * 	  +NULLPTRSIZE
 * 	  +OUTOFMEMSIZE		CompPrepareArrayStoreException (jumps to CommonPart)
 * 
 * 7	LINKAGEERRHSIZE
 * 	  +DIVZEROHANDSIZE
 * 	  +ARROUTOFFSIZE
 * 	  +NEGARRSIZESIZE
 * 	  +NULLPTRSIZE
 * 	  +OUTOFMEMSIZE
 * 	  +ARRAYSTORESIZE	CompPrepareClassCastException (jumps to CommonPart)
 * 
 * 8	LINKAGEERRHSIZE
 * 	  +DIVZEROHANDSIZE
 * 	  +ARROUTOFFSIZE
 * 	  +NEGARRSIZESIZE
 * 	  +NULLPTRSIZE
 * 	  +OUTOFMEMSIZE
 * 	  +ARRAYSTORESIZE
 * 	  +CLASSCASTSIZE	CompPrepareAthrowException (jumps to CommonPart)
 * 
 * 9	LINKAGEERRHSIZE
 * 	  +DIVZEROHANDSIZE
 * 	  +ARROUTOFFSIZE
 * 	  +NEGARRSIZESIZE
 * 	  +NULLPTRSIZE
 * 	  +OUTOFMEMSIZE
 * 	  +ARRAYSTORESIZE
 * 	  +CLASSCASTSIZE
 *	  +ATHROWEXSIZE		CompPrepareIncompatibleClassChangeError (jumps to CommonPart)
 *  
 * 10	LINKAGEERRHSIZE
 * 	  +DIVZEROHANDSIZE
 * 	  +ARROUTOFFSIZE
 * 	  +NEGARRSIZESIZE
 * 	  +NULLPTRSIZE
 * 	  +OUTOFMEMSIZE
 * 	  +ARRAYSTORESIZE
 * 	  +CLASSCASTSIZE
 * 	  +INCOMPERRSIZE
 *	  +ATHROWEXSIZE		CompPrepareExceptionFromInvoked (runs into CommonPart)
 *  
 * 	  remember: ALLEXCEPTSIZE=LINKAGEERRHSIZE+DIVZEROHANDSIZE+ARROUTOFFSIZE+....+ATHROWEXSIZE+INVOKEDEXSIZE
 * 
 * 11	ALLEXCEPTSIZE	CompCommonPartofException (destination of above code)
 * 
 * 12	0			4 data byte RESERVED2
 * 
 * 13   method's code (xxxxx byte) starts here @ENTRYPOINT
 * 
 * 14	at last: 2nd part exception handling: catch frames
 */


// ---------------------- 10 exception triggers  --------------------------
// Consider: in most cases we are using "CALL", but we are _never_ returning!
// This is because we need on stack the address where the exception occured.

#ifdef EXCEPTIONS_BY_SIGNALS
inline void CompTriggerNullPointerException(struct CINFO * cinfo, int reg) {}
inline void CompTriggerDivZeroException(struct CINFO * cinfo) {}
/////inline void CompTriggerLONGDivZeroException(struct CINFO * cinfo) {}
#endif


// #0
// simply a jump to first byte (in first code part byte handling exceptions)
void CompTriggerLinkageError(struct CINFO* cinfo)
{
   CB(CALL);
   CL(cinfo->codebase-cinfo->cptr-4);
}


// #1a
// expecting proper flag set
//
///////#ifndef EXCEPTIONS_BY_SIGNALS        Wed Mar 11 20:01:11 1998
#define THROW_DIVZERO_EXLEN 7	  
void CompTriggerLONGDivZeroException(struct CINFO* cinfo)
{
//   dprintf(stderr,"l-divzero\n");
///////   CB(POPAX);
   CB(POPBX);
   CB(PUSHBX);
   CB(PUSHAX);
   CW(CMP_AXBX);
   CB(JNE);
   CB(THROW_DIVZERO_EXLEN + 2);
   CW(TEST_BXBX);

   CB(JNE);		// jne label (=5 byte)
   CB(SIZEOFJMP86);	
   CB(CALL);		// not JMP, but CALL because we need on stack the address ....
   CL(cinfo->codebase-cinfo->cptr-4+LINKAGEERRHSIZE);	//...where the exception occured
   // label:
}   

#ifndef EXCEPTIONS_BY_SIGNALS
// #1b
// expecting proper flag set
//
void CompTriggerDivZeroException(struct CINFO* cinfo)
{
   CB(JNE);		// jne label (=5 byte)
   CB(SIZEOFJMP86);	
   CB(CALL);		// not JMP, but CALL because we need on stack the address ....
   CL(cinfo->codebase-cinfo->cptr-4+LINKAGEERRHSIZE);	//...where the exception occured
   // label:
}
#endif // EXCEPTIONS_BY_SIGNALS

// #2	 

// expecting index in eax, array in ebx
// but does NOT change eax
// returns [ebx] in ebx (element 0 pointer) as side effect
//
void CompTriggerArrOutOfBoundsException(struct CINFO* cinfo)
{
   MOV_R_MBX8( ECX, 4 );
   CW(MOV_BX_MBX);	// points to element 0 for later usage
   SHR_R( ECX, METHOD_FLAG_BITS );
   CMP_R_R( EAX, ECX );
   
   CB(JB);		// jne label (=5 byte)
   CB(SIZEOFJMP86);	
   CB(CALL);		// not JMP, but CALL because we need on stack the address ....
   CL(cinfo->codebase-cinfo->cptr-4+LINKAGEERRHSIZE+DIVZEROHANDSIZE);	//...where the exception occured
   // label:
}

// #2A 
// just like CompTriggerArrOutOfBoundsException
// but expecting index in edx not eax
// returns [ebx] in ebx (element 0 pointer) as side effect
//
void CompTriggerArrOutOfBoundsException2(struct CINFO* cinfo, int usetmpreg)
{
   if ( usetmpreg )
   {
      CB(PUSHCX);
      MOV_R_MBX8( ECX, 4 );
      CW(MOV_BX_MBX);	// points to element 0 for later usage
      SHR_R( ECX, METHOD_FLAG_BITS );
      CMP_R_R( EDX, ECX );
      CB(POPCX);
   }
   else
   {
      MOV_R_MBX8( ECX, 4 );
      CW(MOV_BX_MBX);	// points to element 0 for later usage
      SHR_R( ECX, METHOD_FLAG_BITS );
      CMP_R_R( EDX, ECX );
   }   
   CB(JB);		// jne label (=5 byte)
   CB(SIZEOFJMP86+2);	
   CW(MOV_AXDX);	// index expected in eax
   CB(CALL);		// not JMP, but CALL because we need on stack the address ....
   CL(cinfo->codebase-cinfo->cptr-4+LINKAGEERRHSIZE+DIVZEROHANDSIZE);	//...where the exception occured
   // label:
}



// #3
// expecting arraysize in eax
//
void CompTriggerNegArraySizeException(struct CINFO* cinfo)
{
   CW(TEST_AXAX);
   CB(JNS);		// jne label (=5 byte)
   CB(SIZEOFJMP86);	
   CB(CALL);		// not JMP, but CALL because we need on stack the address ....
   CL(cinfo->codebase-cinfo->cptr-4+LINKAGEERRHSIZE+DIVZEROHANDSIZE+ARROUTOFFSIZE);
   //							...where the exception occured
   // label:
}

	  
// #4	  
// reg holds ptr object
//
#ifndef EXCEPTIONS_BY_SIGNALS
void CompTriggerNullPointerException(struct CINFO* cinfo, int reg)
{
   TEST_R_R( reg, reg );
   CB(JNE);
   CB(SIZEOFJMP86);
   CB(CALL);		// not JMP, but CALL 
   CL(cinfo->codebase-cinfo->cptr-4+LINKAGEERRHSIZE+DIVZEROHANDSIZE+ARROUTOFFSIZE+NEGARRSIZESIZE);
   // label:
}
#endif

// #4A
// a 2nd version independend of EXCEPTIONS_BY_SIGNALS
//
void CompTriggerNullPointerException2(struct CINFO* cinfo, int reg)
{
   TEST_R_R( reg, reg );
   CB(JNE);
   CB(SIZEOFJMP86);
   CB(CALL);		// not JMP, but CALL 
   CL(cinfo->codebase-cinfo->cptr-4+LINKAGEERRHSIZE+DIVZEROHANDSIZE+ARROUTOFFSIZE+NEGARRSIZESIZE);
   // label:
}


// #5
void CompTriggerOutOfMemoryException(struct CINFO* cinfo)
{
   CW(TEST_AXAX);
   CB(JNE);
   CB(SIZEOFJMP86);
   CB(CALL);		// not JMP, but CALL 
   CL(cinfo->codebase-cinfo->cptr-4+LINKAGEERRHSIZE
      + DIVZEROHANDSIZE+ARROUTOFFSIZE+NEGARRSIZESIZE+NULLPTRSIZE);
   // label:
}

// #6
void CompTriggerArrayStoreException(struct CINFO* cinfo)
{
   MOV_R_MBX8( ECX, 4 );
   SHR_R( ECX, METHOD_FLAG_BITS );
   CW(MOV_BX_MBX);		// points to element 0 for later usage
   CMP_R_R( EDX, ECX );

   CB(JB);		// jne label1 (=5 byte)
   CB(SIZEOFJMP86);	
   CB(CALL);		// not JMP, but CALL because we need on stack the address ....
   CL(cinfo->codebase-cinfo->cptr-4+LINKAGEERRHSIZE+DIVZEROHANDSIZE);	//...where the exception occured
   // label1:
   // ecx carries length
   CB(PUSHDX);			// save edx
   PUSH_Roffs8(EBP, LOCSTART-16);// push EE for is_instance_of()
   CB(MOV_DX);
   CL(is_instance_of);   
   CB(0xFF);CB(0x34);CB(0x8B);	// pushl ( %ebx,%ecx,4)
   CB(PUSHAX);
   CW(CALL_EDX);
   CW(TEST_AXAX);
   CB(POPAX);
   CB(POPCX);
   CB(POPCX);
   CB(POPDX);			// restore edx

   CB(JNE);
   CB(SIZEOFJMP86);
   CB(CALL);
   CL(cinfo->codebase-cinfo->cptr-4+LINKAGEERRHSIZE
      +DIVZEROHANDSIZE+ARROUTOFFSIZE+NEGARRSIZESIZE
      +NULLPTRSIZE+OUTOFMEMSIZE);
   // label2:
}


// #7	  
//
// expects object in eax and check result in ebx
void CompTriggerClassCastException(struct CINFO* cinfo)
{
   CW(TEST_BXBX);		// check result
   CB(JNE);
   CB(SIZEOFJMP86);
   CB(CALL);		
   CL(cinfo->codebase-cinfo->cptr-4+LINKAGEERRHSIZE
      +DIVZEROHANDSIZE+ARROUTOFFSIZE+NEGARRSIZESIZE
      +NULLPTRSIZE+OUTOFMEMSIZE+ARRAYSTORESIZE);	// 9 byte
   // label:
}
#define THROW_CCAST_EX 9	// handle with care: value of THROW_CCAST_EX


// #8
void CompTriggerAthrowException(struct CINFO*cinfo)
{
   CB(CALL);
   CL(cinfo->codebase-cinfo->cptr-4+LINKAGEERRHSIZE
      +DIVZEROHANDSIZE+ARROUTOFFSIZE+NEGARRSIZESIZE
      +NULLPTRSIZE+OUTOFMEMSIZE+ARRAYSTORESIZE+CLASSCASTSIZE);
}

// #9
// called by different locations ...
// ...with EAX ptr to string but also EAX zero (due check result)
void CompTriggerIncompatibleClassChangeError(struct CINFO* cinfo)
{
   CB(CALL);
   CL(cinfo->codebase-cinfo->cptr-4+LINKAGEERRHSIZE
      +DIVZEROHANDSIZE+ARROUTOFFSIZE+NEGARRSIZESIZE
      +NULLPTRSIZE+OUTOFMEMSIZE+ARRAYSTORESIZE+CLASSCASTSIZE+ATHROWEXSIZE);
}

// #10
// here we are expecting EE in ee_reg / do _not_ touch eax
//
void CompTriggerExceptionFromInvoked(struct CINFO* cinfo,int ee_reg)
{
   if (ee_reg==ECX)
    CW(MOV_CX_MCX_8);		// points to ee->exceptionkind char
   else
    CW(MOV_CX_MBX_8);
   CB(EXC_OFF);
   CW(TEST_CLCL);		// new #148, was buggy #139
   CB(JE);
   CB(SIZEOFJMP86);
   CB(CALL);
   CL(cinfo->codebase-cinfo->cptr-4+LINKAGEERRHSIZE
      +DIVZEROHANDSIZE+ARROUTOFFSIZE+NEGARRSIZESIZE
      +NULLPTRSIZE+OUTOFMEMSIZE+ARRAYSTORESIZE+CLASSCASTSIZE+ATHROWEXSIZE+INCOMPERRSIZE);
   // label:
}


//----------10 exception preparations + 1 common part ---------------
//
// They are arranged just like the later produced code is arranged in memory.
// Consider: some of the #defines are repeated intentionally.
// If necessary you must adjust the values in tya.h .
// (In general you have to be _very_ careful if you change
// the size of produced code snippets as follows.)


// common for all CompPrepare.....Exception functions:
// eax holds array_index (#2) or object (#7,#8) or dummy (#0,#1,#3,#4,#5,#6,#9,#10)

char*CompExceptionHandlerPart1(struct CINFO* cinfo)
{
   // compile exception preparation+ common part
   CompPrepareLinkageError(cinfo);
   CompPrepareThrowDivZeroException(cinfo);
   CompPrepareThrowArrOutOfBoundsException(cinfo);
   CompPrepareThrowNegArraySizeException(cinfo);
   CompPrepareThrowNullPointerException(cinfo);
   CompPrepareOutOfMemoryException(cinfo);
   CompPrepareArrayStoreException(cinfo);
   CompPrepareClassCastException(cinfo);
   CompPrepareAthrowException(cinfo);
   CompPrepareIncompatibleClassChangeError(cinfo);
   CompPrepareExceptionFromInvoked(cinfo);
   return CompCommonPartofException(cinfo);
}

// #0
void CompPrepareLinkageError(struct CINFO* cinfo)
{
   CB(PUSHLONG2);
   CB(0);
   CB(JMPS);
   CB((cinfo->codebase-cinfo->cptr) -1 + ALLEXCEPTSIZE);
}
#define DIVZEROHANDSIZE 4

// #1
void CompPrepareThrowDivZeroException(struct CINFO* cinfo)
{
   CB(PUSHLONG2);
   CB(1);
   CB(JMPS);
   CB((cinfo->codebase-cinfo->cptr) -1 + ALLEXCEPTSIZE);
}
#define DIVZEROHANDSIZE 4

// #2
// in eax: index
void CompPrepareThrowArrOutOfBoundsException(struct CINFO* cinfo)
{
   CB(PUSHLONG2);
   CB(2);
   CB(JMPS);
   CB((cinfo->codebase-cinfo->cptr) -1 + ALLEXCEPTSIZE);
}
#define ARROUTOFFSIZE 4

// #3
void CompPrepareThrowNegArraySizeException(struct CINFO* cinfo)
{
   CB(PUSHLONG2);
   CB(3);
   CB(JMPS);
   CB((cinfo->codebase-cinfo->cptr) -1 + ALLEXCEPTSIZE);
}
#define NEGARRSIZESIZE 4

// #4
void CompPrepareThrowNullPointerException(struct CINFO* cinfo)
{
   CB(PUSHLONG2);
   CB(4);
   CB(JMPS);
   CB((cinfo->codebase-cinfo->cptr) -1 + ALLEXCEPTSIZE);
}
#define NULLPTRSIZE 4

// #5
void CompPrepareOutOfMemoryException(struct CINFO* cinfo)
{
   CB(PUSHLONG2);
   CB(5);
   CB(JMPS);
   CB((cinfo->codebase-cinfo->cptr) -1 + ALLEXCEPTSIZE);
}
#define OUTOFMEMSIZE 4

// #6
void CompPrepareArrayStoreException(struct CINFO* cinfo)
{
   CB(PUSHLONG2);
   CB(6);
   CB(JMPS);
   CB((cinfo->codebase-cinfo->cptr) -1 + ALLEXCEPTSIZE);
}
#define ARRAYSTORESIZE 4

// #7
// in eax: object
//
void CompPrepareClassCastException(struct CINFO* cinfo)
{
   CB(PUSHLONG2);
   CB(7);
   CB(JMPS);
   CB((cinfo->codebase-cinfo->cptr) -1 + ALLEXCEPTSIZE);
}
#define CLASSCASTSIZE 4

// #8
// in eax: exception object expected
//
void CompPrepareAthrowException(struct CINFO* cinfo)
{
   CB(PUSHLONG2);
   CB(8);
   CB(JMPS);
   CB((cinfo->codebase-cinfo->cptr) -1 + ALLEXCEPTSIZE);
}
#define ATHROWEXSIZE 4

// #9
void CompPrepareIncompatibleClassChangeError(struct CINFO* cinfo)
{
   CB(PUSHLONG2);
   CB(9);
   CB(JMPS);
   CB((cinfo->codebase-cinfo->cptr) -1 + ALLEXCEPTSIZE);
}
#define INCOMPERRSIZE 4

// #10
void CompPrepareExceptionFromInvoked(struct CINFO* cinfo)
{
  CW(MOV_BX_MBP_8);	// get EE again
  CB(LOCSTART-16);
  CB(PUSHBX);
  // doesn't contain a jump, because common part follows here...
}
#define INVOKEDEXSIZE 4

 
// #11 == common jump destination
char *CompCommonPartofException(struct CINFO* cinfo)
{
   char *backpatch;
   CB(PUSHAX);		// 1
   CB(MOV_BX);		// 2
   CL(CreateExceptObject);// 6
   CW(CALL_EBX);
   CB(POPBX);
   CB(POPCX);		// ret ad on tos
   //
   CB(PUSHLONG);	// 11
   if  (cinfo->mb->exception_table_length || 
      cinfo->mb->CompiledCodeFlags & CCF_invokeSynchronizedJavaMethod)
     {
      backpatch=cinfo->cptr;
      CL(0);		// 15
     }
   else
     {
      CL(SimpleExcHandler);
      backpatch=NULL;
     }
   CB(RETN);		// 16
   return backpatch;
}
#define COMMONEXSIZE 16



//-----------------------------------------------------------------

HObject* CreateExceptObject(int param,int excnr)
{
#define  MAXCL 100
   const char *sig,*excname;
   char buffer[MAXCL];
   switch(excnr)
     {
      case 0:			// Sun Nov 15 14:39:58 1998
	excname=jlLinkageError;
	sig=jlVoidSig;
	break;
      case 1:
	param=(int)makeJavaString((char*)jlAEbyZero,strlen(jlAEbyZero));
	excname=jlArithmeticEx;
	sig=jlStringSig;
	break;
      case 2:
	excname=jlAIOutOfBoundsEx;
	sig=jlIntSig;				// index on stack (param)
	break;
      case 3:
	excname=jlNegArraySizeEx;
	sig=jlVoidSig;
	break;
      case 4:
	excname=jlNullPointerEx;
	sig=jlVoidSig;
	break;
      case 5:
	excname=jlOutOfMemoryErr;
	sig=jlVoidSig;
	break;
      case 6:
	excname=jlArrayStoreEx;
	sig=jlVoidSig;
	break;
      case 7:
	excname=jlClassCastEx;
	sig=jlStringSig;
	dprintf(stderr,"obj=%x\n",param);	// object on stack
        classname2string(unha11(obj_array_classblock((HObject*)param))->name,buffer,MAXCL);
	param=(int)makeJavaString(buffer,strlen(buffer));
	break;
      case 8:					// athrow exceptions
	return (HObject*)param;
      case 9:
	if (param)
	{
	   classname2string(unha11(obj_array_classblock((HObject*)param))->name,buffer,MAXCL);
	   param=(int)makeJavaString(buffer,strlen(buffer));
	}
	else
	  param=(int)makeJavaString((char*)exDetail,strlen(exDetail));
	excname=jlIncompErr;
	sig=jlStringSig;
	break;
      default:					// = exceptions thrown by invoked methods
	exceptionClear((struct execenv *)excnr);
	//dprintf(stderr,"CreateExceptObject ee=%x %p\n",excnr,EE());
	return (((struct execenv *)excnr)->exception.exc);
	// we do not need to create an exception, because it's already stored in ExecEnv
     }
 return execute_java_constructor(NULL,(char*)excname,NULL,(char*)sig,param);
}

	  
void PrepareExceptions()
{
  StOvExc = execute_java_constructor(NULL,(char*)jlStackOvErr,NULL,(char*)jlVoidSig,0);
  MakeClassSticky(obj_classblock(StOvExc));
}


#ifdef EXT_ERR
HObject* CreateIAException(char *detail)
{
  return execute_java_constructor(NULL,(char*)jlIllegalAcc,NULL,
	(char*)jlStringSig,makeJavaString(detail,strlen(detail)));
}
#endif


#if 0
HObject* CreateNPException()
{
  return execute_java_constructor(NULL,(char*)jlNullPointerEx,NULL,(char*)jlVoidSig,0);
}
#endif

void ExecExcep(ExecEnv *ee,HObject *exception_obj)
{
#ifdef DEBUG
 void *messi=(void*)execute_java_dynamic_method(0,exception_obj,"getMessage","()Ljava/lang/String;");
 char *res=makeCString(messi);
 ClassClass *clazz=obj_classblock(exception_obj);
 dprintf(stderr,"EXXXXXXXXXXXXXXXCEPTION %p %p !%s!\n",exception_obj,clazz,res);
 dprintf(stderr," Exception class %s\n",unha11(clazz)->name);
 dprintf(stderr," current method %s\n",ee->current_frame->current_method->fb.name);
   DumpThreads();
#endif
 ee->exceptionKind=EXCKIND_THROW;
 ee->exception.exc=exception_obj;
}


 
//---------------------ExceptionHandler / catch-frames-----------------------------------
//
int Myis_subclass_of(ClassClass *cb, ClassClass *dcb, int dummy, ExecEnv *ee)
{
   return is_subclass_of(cb, dcb, ee);
}

// Compile exception catchframe 
// expecting ExcObject in eax
//
void CompExceptionHandlerPart2(struct CINFO* cinfo)
{
#ifdef USE_REG_OPT   
   #define PREPARE_RET 23
#else
   #define PREPARE_RET 11
#endif
   int n;
   CW(MOV_BXAX);
   CB(POPAX);	//<---address of _next_ instruction (because of CALL)
   		//    could be a problem, because we don't know the EXACT location of exc ?
   CB(PUSHBX);	//<---object again on stack (%1), needed for catch-frame
   CW(MOV_DX_MBP_8);
   CB(LOCSTART-16);		// get EE into edx
   CB(PUSHDX);
   if  (cinfo->mb->exception_table_length)
     {
	CB(DEC_AX);	//<---So we go back on byte
	CW(MOV_BX_MBX_8);
	CB(4);
	// ^^ object->methodtab
	CW(MOV_BX_MBX);
	// ^^ points to class struct (version info at first)
     }
   //
    for (n=0;n<cinfo->mb->exception_table_length;n++)
     {
	dprintf(stderr,"CompExcH  %p .. %p  ---> %p  cla %p\n",cinfo->start[n],
	       cinfo->end[n],cinfo->handler[n],cinfo->exclazz[n]);	
	CB(CMP_AX);
	cinfo->adrstart[n]=cinfo->cptr;		// for later backpatch
	CL(cinfo->start[n]);
	CB(JB);
	if (cinfo->exclazz[n])
	 CB(7+PREPARE_RET +20);
	else
	 CB(7+PREPARE_RET );
	//
	CB(CMP_AX);
	cinfo->adrend[n]=cinfo->cptr;
	CL(cinfo->end[n]);
	CB(JAE);
	//----------------13+1below
	//
	if (cinfo->exclazz[n])
	  {
	     CB( PREPARE_RET +20);		// <-- this jump offset belongs to JAE !!
	     CB(PUSHAX);	//1
	     CB(PUSHLONG);	//2
	     CL(cinfo->exclazz[n]);	//6
	     CB(PUSHBX);	//7
	     // each class is its own subclass in is_subclass_of()
	     CB(MOV_BX);	//8
	     CL(Myis_subclass_of);//12
	     CW(CALL_EBX);	//14
	     CB(POPBX);		//15
	     CB(POPDX);		//16
	     CB(POPCX);		//17
	     CB(XCHG_AXCX);	//18
	     CB(JCXZ);		//19
	     CB(PREPARE_RET );	//20 Byte
	  }
	else			// ... else we ignore the exception class test
          CB(PREPARE_RET );		// <-- this jump offset belongs to JAE !!
	//--------------20
	//
	// compare (%1) object is on stack
#ifdef USE_REG_OPT
	CW(MOV_DI_MBP_32);
	CL(LOCSTART + SIS4* (cinfo->mb->nlocals -1 ));
	CW(MOV_SI_MBP_32);
	CL(LOCSTART + SIS4* (cinfo->mb->nlocals -2 ));
#endif
	CB(POPDX);	
	CB(POPAX);		// get proper stacktop value
	CW(MOV_SPBP);
	CB(PUSHAX);	
	CB(PUSHLONG);
	cinfo->adrhandler[n]=cinfo->cptr;
	CL(cinfo->handler[n]);
	CB(RETN);		// 11 Byte	 jmp to catch{}
        //cont:
	//-------------23==11+12
	#ifdef USE_REG_OPT   
	   #define PREPARE_RET 23
	#else
	   #define PREPARE_RET 11
	#endif	  
     }
   // object and ee are on stack
   CB(MOV_BX);
   CL(ExecExcep);
   CW(CALL_EBX);
#ifndef NOCOMPSYNC
 if (cinfo->mb->CompiledCodeFlags & CCF_invokeSynchronizedJavaMethod)
   {
      if (cinfo->mb->fb.access & ACC_STATIC)
      {
	CB(PUSHLONG);
	CL(cinfo->mb->fb.clazz);
      }
      else
      {
	Comp_PUSH_LocalVarToReg(0,cinfo,EAX);
	CB(PUSHAX);
      }
      CB(MOV_BX);
      CL(monitorExit);
      CW(CALL_EBX);
   }
#endif
   CW(MOV_SPBP);
   CL(POPBPDISIBX);
   CB(RETN);
}

// preserve ax,bx,dx
