package org.apache.turbine.torque.engine.intake.model;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and 
 *    "Apache Turbine" must not be used to endorse or promote products 
 *    derived from this software without prior written permission. For 
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Turbine", nor may "Apache" appear in their name, without 
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

// JDK
import java.io.*;
import java.util.*;

// Xerces
import org.xml.sax.*;

/**
 * A class for holding application data structures.
 *
 * @author <a href="mailto:jmcnally@collab.net>John McNally</a>
 * @version $Id: AppData.java,v 1.3 2001/03/09 11:54:21 jmcnally Exp $
 */
public class AppData
{

    private Vector inputs;
    private String basePackage;

    /**
     * Default Constructor
     */
    public AppData()
    {
        inputs = new Vector();
    }

    /**
     * Imports a column from an XML specification
     */
    public void loadFromXML (Attributes attrib)
    {
        String basePkg = attrib.getValue("basePackage");
        System.out.println("basePackage loaded: " + basePkg);
        if ( basePkg == null )
        {
            setBasePackage("");
        }
        else
        {            
            setBasePackage(basePkg);
        }
    }

    /**
     * Return a collection of input sections (<input-group>)
     */
    public Vector getInputGroups()
    {
        return inputs;
    }


    /**
     * An utility method to add a new input group from
     * an xml attribute.
     */
    public InputGroup addInputGroup(Attributes attrib)
    {
        InputGroup input = new InputGroup();
        input.loadFromXML(attrib);
        addInputGroup(input);
        return input;
    }

    /**
     * Add an input group to the vector and sets the
     * AppData property to this AppData
     */
    public void addInputGroup(InputGroup input)
    {
        input.setAppData(this);
        inputs.addElement(input);
    }

    
    /**
     * Get the value of basePackage.
     * @return value of basePackage.
     */
    public String getBasePackage() 
    {
        return basePackage;
    }
    
    /**
     * Set the value of basePackage.
     * @param v  Value to assign to basePackage.
     */
    public void setBasePackage(String  v) 
    {
        this.basePackage = v;
    }
    
    /**
     * Creats a string representation of this AppData.
     * The representation is given in xml format.
     */
    public String toString()
    {
        StringBuffer result = new StringBuffer();

        result.append ("<app-data>\n");
        for (Enumeration e = inputs.elements() ; e.hasMoreElements() ;)
        {
            result.append (e.nextElement());
        }
        result.append ("</app-data>");
        return result.toString();
  }
}
