package org.apache.turbine.torque.engine.database.model;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and 
 *    "Apache Turbine" must not be used to endorse or promote products 
 *    derived from this software without prior written permission. For 
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Turbine", nor may "Apache" appear in their name, without 
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

// JDK
import java.io.*;
import java.util.*;

// Xerces
import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 * A Class for information regarding possible objects representing a table
 *
 * @author <a href="mailto:jmcnally@collab.net">John McNally</a>
 * @version $Id: Inheritance.java,v 1.3 2001/04/02 20:49:55 jmcnally Exp $
 */
public class Inheritance
{
    private String key;
    private String className;
    private String ancestor;    
    private Column parent;

    /**
     * Default Constructor
     */
    public Inheritance()
    {
    }

    /**
     * Imports foreign key from an XML specification
     */
    public void loadFromXML (Attributes attrib)
    {
        setKey(attrib.getValue("key"));
        setClassName(attrib.getValue("class"));
        setAncestor(attrib.getValue("extends"));
    }

    /**
     * Get the value of key.
     * @return value of key.
     */
    public String getKey() 
    {
        return key;
    }
    
    /**
     * Set the value of key.
     * @param v  Value to assign to key.
     */
    public void setKey(String  v) 
    {
        this.key = v;
    }
    
    
    /**
     * Get the value of parent.
     * @return value of parent.
     */
    public Column getColumn() 
    {
        return parent;
    }
    
    /**
     * Set the value of parent.
     * @param v  Value to assign to parent.
     */
    public void setColumn(Column  v) 
    {
        this.parent = v;
    }
    
    /**
     * Get the value of className.
     * @return value of className.
     */
    public String getClassName() 
    {
        return className;
    }
    
    /**
     * Set the value of className.
     * @param v  Value to assign to className.
     */
    public void setClassName(String  v) 
    {
        this.className = v;
    }
    
    /**
     * Get the value of ancestor.
     * @return value of ancestor.
     */
    public String getAncestor() 
    {
        return ancestor;
    }
    
    /**
     * Set the value of ancestor.
     * @param v  Value to assign to ancestor.
     */
    public void setAncestor(String  v) 
    {
        this.ancestor = v;
    }
    
    /**
     * String representation of the foreign key. This
     * is an xml representation.
     */
    public String toString()
    {
        StringBuffer result = new StringBuffer();
        result.append(" <inheritance key=\"")
              .append(key)
              .append("\" class=\"")
              .append(className)
              .append('\"');


        if (ancestor != null)
        {
            result.append(" extends=\"")
                  .append(ancestor)
                  .append('\"');
        }
                
        result.append("/>");
        
        return result.toString();
    }

}








