package org.apache.turbine.services.intake.xmlmodel;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and 
 *    "Apache Turbine" must not be used to endorse or promote products 
 *    derived from this software without prior written permission. For 
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Turbine", nor may "Apache" appear in their name, without 
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

// JDK
import java.io.*;
import java.util.*;

// Xerces
import org.xml.sax.*;
import org.xml.sax.helpers.*;

import org.apache.turbine.util.StringUtils;

/**
 * A Class for holding data about a constraint on a property.
 *
 * @author <a href="mailto:jmcnally@collab.net>John McNally</a>
 * @version $Id: Rule.java,v 1.2 2001/03/21 00:17:14 jmcnally Exp $
 */
public class Rule
{
    private String mask;
    private String minLength;
    private String maxLength;
    private String minValue;
    private String maxValue;
    private String requireProp;
    private String message;
    private String action;
    private XmlField parent;

    /**
     * Default Constructor
     */
    public Rule()
    {
    }

    /**
     * Imports a column from an XML specification
     */
    public void loadFromXML (Attributes attrib)
    {
        setMask(attrib.getValue("mask"));
        setMinLength(attrib.getValue("minLength"));
        setMaxLength(attrib.getValue("maxLength"));
        setMinValue(attrib.getValue("minValue"));
        setMaxValue(attrib.getValue("maxValue"));
        setRequiresProp(attrib.getValue("requires"));
        setAction(attrib.getValue("action"));
    }


    /**
     * Set the regexp used to verify parameter
     */
    public void setMask(String newMask)
    {
        mask = newMask;
    }
    /**
     * Get regexp used to verify a parameter
     */
    public String getMask()
    {
        return mask;
    }

    /**
     * Set the name of the property
     */
    public void setRequiresProp(String newRequireProp)
    {
        requireProp = newRequireProp;
    }

    /**
     * Get the name of the property
     */
    public String getRequiresProp()
    {
        if ( requireProp == null ) 
        {
            return null;
        }
        else 
        {
            return StringUtils.removeUnderScores(requireProp);
        }
    }

    /**
     * Set the minimum length of the parameter value
     */
    public void setMinLength(String length)
    {
        minLength = length;
    }
    /**
     * Get minimum length of the parameter value
     */
    public String getMinLength()
    {
        return minLength;
    }

    /**
     * Set the maximum length of the parameter value
     */
    public void setMaxLength(String length)
    {
        maxLength = length;
    }
    /**
     * Get maximum length of the parameter value
     */
    public String getMaxLength()
    {
        return maxLength;
    }

    /**
     * Set the minimum value of the parameter
     */
    public void setMinValue(String value)
    {
        minValue = value;
    }
    /**
     * Get minimum value of the parameter
     */
    public String getMinValue()
    {
        return minValue;
    }

    /**
     * Set the maximum value of the parameter
     */
    public void setMaxValue(String value)
    {
        maxValue = value;
    }
    /**
     * Get maximum value of the parameter
     */
    public String getMaxValue()
    {
        return maxValue;
    }

    /**
     * Set the error message
     */
    public void setMessage(String newMessage)
    {
        message = newMessage;
    }

    /**
     * Get the error message
     */
    public String getMessage()
    {
        return message;
    }
    /**
     * Set the action to take on failure
     */
    public void setAction(String newAction)
    {
        action = newAction;
    }

    /**
     * Get the action to take on failure
     */
    public String getAction()
    {
        if ( action == null) 
        {
            action = "invalidate";    
        }
        return action;
    }

    /**
     * Set the parent Field of the rule
     */
    public void setField(XmlField parent)
    {
        this.parent = parent;
    }

    /**
     * Get the parent Field of the rule
     */
    public XmlField getField()
    {
        return parent;
    }

    /**
     * String representation of the column. This
     * is an xml representation.
     */
    public String toString()
    {
        StringBuffer result = new StringBuffer();

        if (mask != null)
        {
            result.append(" mask=\""+mask+"\"");
        }        
        if (minLength != null)
        {
            result.append(" minLength=\""+minLength+"\"");
        }        
        if (maxLength != null)
        {
            result.append(" maxLength=\""+maxLength+"\"");
        }        
        if (minValue != null)
        {
            result.append(" minValue=\""+minValue+"\"");
        }        
        if (maxValue != null)
        {
            result.append(" maxValue=\""+maxValue+"\"");
        }        
        if (requireProp != null)
        {
            result.append(" requires=\""+requireProp+"\"");
        }        
        if (action != null)
        {
            result.append(" action=\""+action+"\"");
        }        

        result.append(">\n");

        if (message != null)
        {
            result.append(message);
        }        

        result.append("</rule>\n");
        return result.toString();
    }

}



