package org.apache.turbine.modules.layouts;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and 
 *    "Apache Turbine" must not be used to endorse or promote products 
 *    derived from this software without prior written permission. For 
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Turbine", nor may "Apache" appear in their name, without 
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

// Java Core Classes
import java.util.*;

// Turbine Modules
import org.apache.turbine.modules.*;

// Turbine Utility Classes
import org.apache.turbine.util.*;

// ECS Classes
import org.apache.ecs.*;
import org.apache.ecs.html.*;

/**
 * This is a sample FreeMarker Layout module
 *
 * @author <a href="mailto:mbryson@mont.mindspring.com">Dave Bryson</a>
 * @version $Id: FreeMarkerLayout.java,v 1.4 2001/04/01 06:12:57 jvanzyl Exp $
 */
public class FreeMarkerLayout extends Layout
{
    /**
     * Build the layout.
     *
     * @param data Turbine information.
     * @exception Exception, a generic exception.
     */
    public void doBuild( RunData data )
        throws Exception
    {
        ParameterParser params = data.getParameters();
        String fmScreen = params.getString("template");
        params.add("template", "navigations/default_top.html");

        // Execute the Top Navigation portion for this Layout.
        ConcreteElement topNav =
            ScreenLoader.getInstance().eval ( data, "FreeMarkerScreen" );
        
        if ( topNav != null)
        {
            data.getPage().getBody().addElement( topNav );
        }            

        // If an Action has defined a message, attempt to display it
        // here.
        if ( data.getMessage() != null )
        {
            data.getPage().getBody()
                .addElement(new P())
                .addElement(
                    new Font().setColor(HtmlColor.red)
                        .addElement(data.getMessageAsHTML()));
        }

        params.add("template", "screens/" + fmScreen);

        // Now execute the Screen portion of the page.
        ConcreteElement screen = ScreenLoader.getInstance().eval ( data, data.getScreen() );
        if (screen != null)
            data.getPage().getBody().addElement( screen );

        // The screen should have attempted to set a Title for itself,
        // otherwise, a default title is set.
        data.getPage().getTitle().addElement(data.getTitle());

        // The screen should have attempted to set a Body bgcolor for
        // itself, otherwise, a default body bgcolor is set.
        data.getPage().getBody().setBgColor(HtmlColor.white);

        // Execute the Bottom Navigation portion for this Layout.
        params.add("template", "navigations/default_bottom.html");
        ConcreteElement bottomNav =
        ScreenLoader.getInstance().eval ( data, "FreeMarkerScreen" );
        
        if ( bottomNav != null)
        {
            data.getPage().getBody().addElement( bottomNav );
        }            
    }
}
