/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.util.HashMap;
import java.util.Iterator;
import org.webmacro.util.SparseArrayIterator;

public class IntMap {
    Object[] _values;

    public IntMap(int n) {
        this._values = new Object[n];
    }

    public void put(int n, Object object) {
        if (n > this._values.length) {
            int n2 = n * 2 + 1;
            Object[] objectArray = new Object[n2];
            System.arraycopy(this._values, 0, objectArray, 0, this._values.length);
            this._values = objectArray;
        }
        this._values[n] = object;
    }

    public Object get(int n) {
        try {
            return this._values[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public void remove(int n) {
        try {
            this._values[n] = null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public Iterator iterator() {
        return new SparseArrayIterator(this._values);
    }

    public static void main(String[] stringArray) {
        Object object;
        int n;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
        IntMap intMap = new IntMap(83);
        Integer[] integerArray = new Integer[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            hashMap.put(stringArray[n2], stringArray[n2]);
            intMap.put(n2, stringArray[n2]);
            integerArray[n2] = new Integer(n2);
            hashMap2.put(integerArray[n2], stringArray[n2]);
            ++n2;
        }
        int n3 = 10000000;
        long l = System.currentTimeMillis();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < stringArray.length) {
                String string = stringArray[n5];
                Object v = hashMap.get(string);
                ++n5;
            }
            ++n4;
        }
        long l2 = System.currentTimeMillis() - l;
        System.out.println("hashmap: " + l2);
        l = System.currentTimeMillis();
        int n6 = 0;
        while (n6 < n3) {
            n = 0;
            while (n < stringArray.length) {
                Integer n7 = integerArray[n];
                object = hashMap2.get(n7);
                ++n;
            }
            ++n6;
        }
        l2 = System.currentTimeMillis() - l;
        System.out.println("i-hashmap: " + l2);
        l = System.currentTimeMillis();
        n = 0;
        while (n < n3) {
            int n8 = 0;
            while (n8 < stringArray.length) {
                object = stringArray[n8];
                Object object2 = intMap.get(n8);
                ++n8;
            }
            ++n;
        }
        l2 = System.currentTimeMillis() - l;
        System.out.println("intmap: " + l2);
    }
}

