/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.util.HashMap;
import java.util.Iterator;
import org.webmacro.util.SimpleStack;
import org.webmacro.util.SparseArrayIterator;

public final class Atomizer {
    final HashMap _atoms;
    Object[] _values;
    final SimpleStack _freeAtoms = new SimpleStack();
    int _max = 0;

    public Atomizer() {
        this(100);
    }

    public Atomizer(int n) {
        this._atoms = new HashMap((int)((double)n / 0.75 + 1.0));
        this._values = new Object[n];
    }

    public int atomize(Object object) {
        int n;
        Integer n2 = (Integer)this._atoms.get(object);
        if (n2 == null) {
            n2 = (Integer)this._freeAtoms.pop();
            if (n2 == null) {
                n2 = new Integer(this._max++);
            }
            n = n2;
            if (this._max == this._values.length) {
                System.out.println("expanding space");
                int n3 = this._max * 2 + 1;
                Object[] objectArray = new Object[n3];
                System.arraycopy(this._values, 0, objectArray, 0, this._max);
                this._values = objectArray;
            }
            this._values[n] = object;
            this._atoms.put(object, n2);
        } else {
            n = n2;
        }
        return n;
    }

    public Object get(int n) {
        try {
            return this._values[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public Object remove(int n) {
        try {
            Object object = this._values[n];
            this.remove(object);
            return object;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public void remove(Object object) {
        if (object == null) {
            return;
        }
        Integer n = (Integer)this._atoms.remove(object);
        if (n == null) {
            return;
        }
        this._values[n.intValue()] = null;
        this._freeAtoms.push(n);
    }

    public Iterator iterator() {
        return new Iter(this._values);
    }

    public static void main(String[] stringArray) {
        Atomizer atomizer = new Atomizer(3);
        int[] nArray = new int[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            nArray[n] = atomizer.atomize(stringArray[n]);
            System.out.println("Atomized " + stringArray[n] + " to " + nArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            System.out.println("Atom " + nArray[n2] + " is " + atomizer.get(nArray[n2]));
            ++n2;
        }
        Iterator iterator = atomizer.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            System.out.println("RM: Object " + e + " was atom " + atomizer.atomize(e));
            iterator.remove();
        }
        nArray = new int[stringArray.length];
        int n3 = 0;
        while (n3 < stringArray.length) {
            nArray[n3] = atomizer.atomize(stringArray[n3]);
            System.out.println("Atomized " + stringArray[n3] + " to " + nArray[n3]);
            ++n3;
        }
    }

    class Iter
    extends SparseArrayIterator {
        Iter(Object[] objectArray) {
            super(objectArray);
        }

        public void remove() throws IllegalStateException {
            if (this._last < 0) {
                throw new IllegalStateException("Remove called before next()");
            }
            Atomizer.this.remove(this._values[this._last]);
        }
    }
}

