/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import javax.servlet.ServletException;
import org.webmacro.InvalidTypeException;
import org.webmacro.NotFoundException;
import org.webmacro.Template;
import org.webmacro.servlet.Handler;
import org.webmacro.servlet.HandlerException;
import org.webmacro.servlet.WMServlet;
import org.webmacro.servlet.WebContext;
import org.webmacro.util.Log;

public final class Reactor
extends WMServlet {
    private static String HANDLER_TYPE = "handler";
    private static final Log _log = new Log("reactor", "Reactor Servlet");
    private String _errorVariable;

    public final void start() throws ServletException {
        try {
            this._errorVariable = this.getConfig("ErrorVariable");
        }
        catch (Exception exception) {
            _log.exception(exception);
            _log.error("Could not grab handler or errorVariable from broker");
            throw new ServletException("Cannot initialize critical resources");
        }
    }

    public final Handler getHandler(String string) throws NotFoundException {
        try {
            return (Handler)this.getBroker().getValue(HANDLER_TYPE, string);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new NotFoundException("Type \"" + HANDLER_TYPE + "\"" + " is not known to the Broker: " + invalidTypeException);
        }
    }

    public final Template handle(WebContext webContext) throws HandlerException {
        Handler handler = null;
        String string = webContext.getRequest().getServletPath();
        try {
            handler = this.getHandler(string);
        }
        catch (Exception exception) {
            _log.exception(exception);
            Template template = this.error(webContext, "Reactor: Unable to create handler for script name: " + string + "... this may be because your handler is not in your CLASSPATH," + " or that you have not registered WebMacro as the handler for " + " the name " + string + " in servlet.properties (or equiv.).");
        }
        return handler.accept(webContext);
    }
}

