/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.ContextException;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.engine.Argument;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Directive;
import org.webmacro.engine.Engine;
import org.webmacro.engine.Variable;

final class SetDirective
implements Directive {
    private final Variable myVariable;
    private final Object myValue;
    private static final String[] _verbs = new String[]{"="};

    public static final String[] getArgumentNames() {
        return _verbs;
    }

    SetDirective(Object object, Object object2) {
        this.myVariable = (Variable)object;
        this.myValue = object2;
    }

    public static final Object build(BuildContext buildContext, Object object, Argument[] argumentArray) throws BuildException {
        Variable variable;
        if (argumentArray.length != 1 || !argumentArray[0].getName().equals("=")) {
            throw new BuildException("SetDirective requites an = argument");
        }
        Object object2 = argumentArray[0].getValue();
        try {
            variable = (Variable)object;
        }
        catch (ClassCastException classCastException) {
            throw new BuildException("lhs of set must be a variable(was " + object.getClass() + ")");
        }
        return new SetDirective(variable, object2);
    }

    public static final String getVerb() {
        return "=";
    }

    public final void write(FastWriter fastWriter, Context context) throws ContextException, IOException {
        Object object = this.evaluate(context);
        if (object != null) {
            fastWriter.write(object.toString());
        }
    }

    public final Object evaluate(Context context) {
        try {
            if (this.myValue instanceof Macro) {
                this.myVariable.setValue(context, ((Macro)this.myValue).evaluate(context));
            } else {
                this.myVariable.setValue(context, this.myValue);
            }
        }
        catch (ContextException contextException) {
            Engine.log.exception(contextException);
            Engine.log.error("Set: Unable to set value: " + this.myVariable);
            return "<!--\n Unable to set value: " + this.myVariable + " \n-->";
        }
        return null;
    }
}

