/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.ContextException;
import org.webmacro.FastWriter;
import org.webmacro.InvalidTypeException;
import org.webmacro.Macro;
import org.webmacro.NotFoundException;
import org.webmacro.Template;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Directive;
import org.webmacro.engine.Engine;

class ParseDirective
implements Directive {
    private final Macro _fileName;

    ParseDirective(Macro macro) {
        this._fileName = macro;
    }

    public static Object build(BuildContext buildContext, Object object) throws BuildException {
        if (object == null) {
            return null;
        }
        if (object instanceof Macro) {
            return new ParseDirective((Macro)object);
        }
        try {
            return buildContext.getBroker().getValue("template", object.toString());
        }
        catch (NotFoundException notFoundException) {
            return new BuildException("Template " + object + " not found: " + notFoundException);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new BuildException("Broker cannot load templates: " + invalidTypeException);
        }
    }

    public final Object evaluate(Context context) throws ContextException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
            FastWriter fastWriter = new FastWriter(byteArrayOutputStream, "UTF8");
            this.write(fastWriter, context);
            fastWriter.flush();
            return byteArrayOutputStream.toString("UTF8");
        }
        catch (IOException iOException) {
            Engine.log.exception(iOException);
            Engine.log.warning("Include: evaluate got IO exception on write to StringWriter");
            return "";
        }
    }

    public final void write(FastWriter fastWriter, Context context) throws ContextException, IOException {
        if (this._fileName == null) {
            Engine.log.error("Include: attempt to write with null filename");
            return;
        }
        String string = this._fileName.evaluate(context).toString();
        Engine.log.debug("Include fname: " + string);
        try {
            Template template = (Template)context.getBroker().getValue("template", string);
            template.write(fastWriter, context);
        }
        catch (IOException iOException) {
            Engine.log.exception(iOException);
            String string2 = "Error reading file " + string;
            Engine.log.warning(string2);
            fastWriter.write("<!--\nWARNING: " + string2 + " \n-->");
        }
        catch (Exception exception) {
            Engine.log.exception(exception);
            String string3 = "Template not found: " + string;
            Engine.log.warning(string3);
            fastWriter.write("<!--\nWARNING: " + string3 + " \n-->");
        }
    }
}

