/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.broker;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.Observable;
import java.util.Observer;
import org.webmacro.BrokerRequest;
import org.webmacro.InvalidTypeException;
import org.webmacro.NotFoundException;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.broker.ResourceRevokedException;

public abstract class ResourceEvent
extends EventObject
implements BrokerRequest,
Observer,
PropertyChangeListener {
    private String type;
    private String name;
    private Object resource;
    private boolean valid = true;
    private boolean notfound = true;
    boolean deleted = false;
    boolean accessed = true;

    protected ResourceEvent(ResourceBroker resourceBroker, String string, String string2, Object object) throws InvalidTypeException {
        super(resourceBroker);
        this.type = string.intern();
        this.name = string2.intern();
        this.resource = object;
        if (object == null || string == null || string2 == null || resourceBroker == null) {
            throw new InvalidTypeException("Arguments cannot be null.");
        }
    }

    ResourceEvent(ResourceBroker resourceBroker, String string, String string2) throws InvalidTypeException {
        super(resourceBroker);
        this.type = string.intern();
        this.name = string2.intern();
        this.resource = null;
        if (string == null || string2 == null || resourceBroker == null) {
            throw new InvalidTypeException("Arguments cannot be null.");
        }
    }

    public final String getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final synchronized void set(Object object) throws ResourceRevokedException, InvalidTypeException {
        this.accessed = true;
        if (object == null) {
            throw new InvalidTypeException("Cannot set to null value");
        }
        if (!this.valid || this.resource != null) {
            throw new ResourceRevokedException(this + " has been revoked: " + this.resource);
        }
        this.notfound = false;
        this.resource = object;
        this.notifyAll();
    }

    final synchronized void revoke(String string) {
        this.valid = false;
        this.resource = string;
        this.notifyAll();
    }

    public final void update() {
        this.accessed = true;
    }

    public final void update(Observable observable, Object object) {
        this.accessed = true;
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.accessed = true;
    }

    public final String toString() {
        return "Resource[" + this.type + ", " + this.name + "]";
    }

    public final synchronized Object getValue() throws NotFoundException, ResourceRevokedException {
        this.accessed = true;
        try {
            if (this.valid && this.resource == null) {
                ResourceBroker resourceBroker = (ResourceBroker)this.getSource();
                resourceBroker.blocked(this);
                while (this.valid && this.resource == null) {
                    this.wait();
                }
                this.accessed = true;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
        }
        if (this.valid) {
            return this.resource;
        }
        if (this.notfound) {
            throw new NotFoundException(this + " not found: " + this.resource);
        }
        throw new ResourceRevokedException(this + " has been revoked: " + this.resource);
    }

    public final boolean isAvailable() {
        return this.valid && this.resource != null;
    }

    public final boolean isRevoked() {
        return !this.valid;
    }

    public final boolean isSettable() {
        return this.valid && this.resource == null;
    }

    abstract void providerSet(ResourceProvider var1) throws NotFoundException, InterruptedException;

    void providerSave(ResourceProvider resourceProvider) {
        resourceProvider.resourceSave(this);
    }
}

