/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.webmacro.Broker;
import org.webmacro.ContextException;
import org.webmacro.ContextTool;
import org.webmacro.InvalidTypeException;
import org.webmacro.NotFoundException;
import org.webmacro.util.Log;
import org.webmacro.util.PropertyException;
import org.webmacro.util.PropertyOperator;

public class Context
implements Cloneable {
    private Broker _broker;
    private Object _bean;
    private Map _toolbox;
    private Map _tools = null;
    private HashMap _globals = null;
    private Locale _locale = Locale.getDefault();
    private static final Log _log = new Log("context", "Context Messages");

    protected Context(Broker broker) {
        this._broker = broker;
        this._bean = null;
        this._toolbox = null;
        try {
            String string = (String)broker.getValue("config", "ContextTools");
            this.registerTools(string);
        }
        catch (InvalidTypeException invalidTypeException) {
            _log.exception(invalidTypeException);
            _log.error("config type not registered with broker!");
        }
        catch (NotFoundException notFoundException) {
            _log.exception(notFoundException);
            _log.warning("could not load ContextTools from config: " + notFoundException);
        }
    }

    protected Context(Broker broker, Map map, Object object) {
        this._broker = broker;
        this._bean = object;
        this._toolbox = map;
    }

    protected Object clone() {
        Context context = null;
        try {
            context = (Context)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        context._globals = null;
        context._bean = null;
        context._locale = this._locale;
        return context;
    }

    public void clear() {
        this._tools = null;
        this._globals = null;
        this._bean = null;
    }

    protected final void registerTool(String string, ContextTool contextTool) throws ContextException {
        if (this._toolbox == null) {
            this._toolbox = new HashMap();
        }
        this._toolbox.put(string, contextTool);
    }

    private String findToolName(String string) {
        int n = string.lastIndexOf(46) + 1;
        int n2 = string.endsWith("Tool") ? string.length() - 4 : string.length();
        String string2 = string.substring(n, n2);
        return string2;
    }

    protected final void registerTools(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            try {
                Class<?> clazz = Class.forName(string2);
                String string3 = this.findToolName(string2);
                ContextTool contextTool = (ContextTool)clazz.newInstance();
                this.registerTool(string3, contextTool);
            }
            catch (ClassCastException classCastException) {
                _log.exception(classCastException);
                _log.error("Tool class " + string2 + " newInstance returns invalid type.");
            }
            catch (ClassNotFoundException classNotFoundException) {
                _log.exception(classNotFoundException);
                _log.error("Tool class " + string2 + " not found: " + classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                _log.exception(illegalAccessException);
                _log.error("Tool class and methods must be public for " + string2 + ": " + illegalAccessException);
            }
            catch (ContextException contextException) {
                _log.exception(contextException);
                _log.error("ContextException thrown while registering Tool: " + string2);
            }
            catch (InstantiationException instantiationException) {
                _log.exception(instantiationException);
                _log.error("Tool class " + string2 + " must have a public zero " + "argument or default constructor: " + instantiationException);
            }
        }
    }

    public final Broker getBroker() {
        return this._broker;
    }

    public final Map getGlobalVariables() {
        if (this._globals == null) {
            this._globals = new HashMap();
        }
        return this._globals;
    }

    public final Object getBean() {
        return this._bean;
    }

    public final void setBean(Object object) {
        this._bean = object;
    }

    public final Object getProperty(Object[] objectArray) throws PropertyException, ContextException {
        Object object = null;
        object = this._bean == null ? this.getGlobal(objectArray) : PropertyOperator.getProperty(this, this._bean, objectArray);
        if (object == null) {
            object = this.getTool(objectArray);
        }
        return object;
    }

    public final boolean setProperty(Object[] objectArray, Object object) throws PropertyException, ContextException {
        if (objectArray.length == 0) {
            return false;
        }
        if (this._bean == null) {
            return this.setGlobal(objectArray, object) || this.setTool(objectArray, object);
        }
        return PropertyOperator.setProperty(this, this._bean, objectArray, object) || this.setTool(objectArray, object);
    }

    public final Object get(Object object) {
        return this._globals != null ? this._globals.get(object) : null;
    }

    public final void put(Object object, Object object2) {
        if (this._globals == null) {
            this.getGlobalVariables().put(object, object2);
        } else {
            this._globals.put(object, object2);
        }
    }

    public final Object getGlobal(Object[] objectArray) throws PropertyException, ContextException {
        int n = objectArray.length;
        if (this._globals == null || n == 0) {
            return null;
        }
        Object object = this.get(objectArray[0]);
        if (n == 1 || object == null) {
            return object;
        }
        return PropertyOperator.getProperty(this, object, objectArray, 1);
    }

    public final boolean setGlobal(Object[] objectArray, Object object) throws PropertyException, ContextException {
        if (objectArray.length == 0) {
            return false;
        }
        if (objectArray.length == 1) {
            this.put(objectArray[0], object);
            return true;
        }
        Object object2 = this.get(objectArray[0]);
        if (object2 == null) {
            return false;
        }
        return PropertyOperator.setProperty(this, object2, objectArray, 1, object);
    }

    public final Object getTool(Object object) throws ContextException {
        try {
            ContextTool contextTool;
            Object object2;
            if (this._toolbox == null) {
                return null;
            }
            Object object3 = object2 = this._tools != null ? (Object)this._tools.get(object) : null;
            if (object2 == null && (contextTool = (ContextTool)this._toolbox.get(object)) != null) {
                if (this._tools == null) {
                    this._tools = new HashMap();
                }
                object2 = contextTool.init(this);
                this._tools.put(object, object2);
            }
            return object2;
        }
        catch (ClassCastException classCastException) {
            throw new ContextException("Tool" + object + " does not implement the ContextTool interface!");
        }
    }

    public final Object getTool(Object[] objectArray) throws PropertyException, ContextException {
        if (objectArray.length == 0 || this._toolbox == null) {
            return null;
        }
        Object object = this.getTool(objectArray[0]);
        if (objectArray.length == 1) {
            return object;
        }
        return PropertyOperator.getProperty(this, this.getTool(objectArray[0]), objectArray, 1);
    }

    public final boolean setTool(Object[] objectArray, Object object) throws PropertyException, ContextException {
        if (objectArray.length == 0) {
            return false;
        }
        if (objectArray.length == 1) {
            throw new ContextException("Cannot reset tool in a running context. Tools can only be registered via the registerTool method.");
        }
        return PropertyOperator.setProperty(this, this.getTool(objectArray[0]), objectArray, 1, object);
    }

    public final void setLocale(Locale locale) {
        this._locale = locale;
    }

    public final Locale getLocale() {
        return this._locale;
    }
}

