/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.junit.BaseTest;
import org.apache.tools.ant.taskdefs.optional.junit.BatchTest;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.apache.tools.ant.taskdefs.optional.junit.SummaryJUnitResultFormatter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class JUnitTask
extends Task {
    private CommandlineJava commandline = new CommandlineJava();
    private Vector tests = new Vector();
    private Vector batchTests = new Vector();
    private Vector formatters = new Vector();
    private File dir = null;
    private Integer timeout = null;
    private boolean summary = false;

    public JUnitTask() throws Exception {
        this.commandline.setClassname("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner");
    }

    public void addFormatter(FormatterElement fe) {
        this.formatters.addElement(fe);
    }

    public void addTest(JUnitTest test) {
        this.tests.addElement(test);
    }

    protected Enumeration allTests() {
        return new Enumeration(this){
            private Enumeration testEnum;
            private Enumeration batchEnum;
            {
                this.testEnum = this$0.tests.elements();
                this.batchEnum = this$0.batchTests.elements();
            }

            public boolean hasMoreElements() {
                return this.testEnum.hasMoreElements() || this.batchEnum.hasMoreElements();
            }

            public Object nextElement() {
                if (this.testEnum.hasMoreElements()) {
                    return this.testEnum.nextElement();
                }
                return this.batchEnum.nextElement();
            }
        };
    }

    public BatchTest createBatchTest() {
        BatchTest test = new BatchTest(this.project);
        this.batchTests.addElement(test);
        return test;
    }

    public Path createClasspath() {
        return this.commandline.createClasspath(this.project).createPath();
    }

    public Commandline.Argument createJvmarg() {
        return this.commandline.createVmArgument();
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.timeout.intValue());
    }

    public void execute() throws BuildException {
        BaseTest test;
        boolean errorOccurred = false;
        boolean failureOccurred = false;
        Vector runTests = (Vector)this.tests.clone();
        Enumeration list = this.batchTests.elements();
        while (list.hasMoreElements()) {
            test = (BatchTest)list.nextElement();
            Enumeration list2 = ((BatchTest)test).elements();
            while (list2.hasMoreElements()) {
                runTests.addElement(list2.nextElement());
            }
        }
        list = runTests.elements();
        while (list.hasMoreElements()) {
            boolean failureOccurredHere;
            int i;
            FormatterElement[] add;
            FormatterElement fe;
            int i2;
            test = (JUnitTest)list.nextElement();
            if (!((JUnitTest)test).shouldRun(this.project)) continue;
            if (((JUnitTest)test).getOutfile() == null) {
                ((JUnitTest)test).setOutfile(this.project.resolveFile("TEST-" + ((JUnitTest)test).getName()));
            }
            int exitValue = 2;
            if (!test.getFork()) {
                if (this.dir != null) {
                    this.log("dir attribute ignored if running in the same VM", 1);
                }
                JUnitTestRunner runner = null;
                Path classpath = this.commandline.getClasspath();
                if (classpath != null) {
                    this.log("Using CLASSPATH " + classpath, 3);
                    AntClassLoader l = new AntClassLoader(this.project, classpath, false);
                    l.addSystemPackageRoot("junit");
                    l.addSystemPackageRoot("org.apache.tools.ant");
                    runner = new JUnitTestRunner((JUnitTest)test, test.getHaltonerror(), test.getHaltonfailure(), (ClassLoader)l);
                } else {
                    runner = new JUnitTestRunner((JUnitTest)test, test.getHaltonerror(), test.getHaltonfailure());
                }
                if (this.summary) {
                    this.log("Running " + ((JUnitTest)test).getName(), 2);
                    SummaryJUnitResultFormatter f = new SummaryJUnitResultFormatter();
                    f.setOutput((OutputStream)new LogOutputStream((Task)this, 2));
                    runner.addFormatter(f);
                }
                i2 = 0;
                while (i2 < this.formatters.size()) {
                    fe = (FormatterElement)this.formatters.elementAt(i2);
                    if (fe.getUseFile()) {
                        fe.setOutfile(this.project.resolveFile(String.valueOf(((JUnitTest)test).getOutfile()) + fe.getExtension()));
                    } else {
                        fe.setOutput((OutputStream)new LogOutputStream((Task)this, 2));
                    }
                    runner.addFormatter(fe.createFormatter());
                    ++i2;
                }
                add = ((JUnitTest)test).getFormatters();
                i = 0;
                while (i < add.length) {
                    if (add[i].getUseFile()) {
                        add[i].setOutfile(this.project.resolveFile(String.valueOf(((JUnitTest)test).getOutfile()) + add[i].getExtension()));
                    } else {
                        add[i].setOutput((OutputStream)new LogOutputStream((Task)this, 2));
                    }
                    runner.addFormatter(add[i].createFormatter());
                    ++i;
                }
                runner.run();
                exitValue = runner.getRetCode();
            } else {
                CommandlineJava cmd = (CommandlineJava)this.commandline.clone();
                cmd.setClassname("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner");
                cmd.createArgument().setValue(((JUnitTest)test).getName());
                cmd.createArgument().setValue("haltOnError=" + test.getHaltonerror());
                cmd.createArgument().setValue("haltOnFailure=" + test.getHaltonfailure());
                if (this.summary) {
                    this.log("Running " + ((JUnitTest)test).getName(), 2);
                    cmd.createArgument().setValue("formatter=org.apache.tools.ant.taskdefs.optional.junit.SummaryJUnitResultFormatter");
                }
                StringBuffer formatterArg = new StringBuffer();
                i2 = 0;
                while (i2 < this.formatters.size()) {
                    fe = (FormatterElement)this.formatters.elementAt(i2);
                    formatterArg.append("formatter=");
                    formatterArg.append(fe.getClassname());
                    if (fe.getUseFile()) {
                        formatterArg.append(",");
                        formatterArg.append(this.project.resolveFile(String.valueOf(((JUnitTest)test).getOutfile()) + fe.getExtension()).getAbsolutePath());
                    }
                    cmd.createArgument().setValue(formatterArg.toString());
                    formatterArg.setLength(0);
                    ++i2;
                }
                add = ((JUnitTest)test).getFormatters();
                i = 0;
                while (i < add.length) {
                    formatterArg.append("formatter=");
                    formatterArg.append(add[i].getClassname());
                    if (add[i].getUseFile()) {
                        formatterArg.append(",");
                        formatterArg.append(this.project.resolveFile(String.valueOf(((JUnitTest)test).getOutfile()) + add[i].getExtension()).getAbsolutePath());
                    }
                    cmd.createArgument().setValue(formatterArg.toString());
                    formatterArg.setLength(0);
                    ++i;
                }
                Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), this.createWatchdog());
                execute.setCommandline(cmd.getCommandline());
                if (this.dir != null) {
                    execute.setWorkingDirectory(this.dir);
                    execute.setAntRun(this.project);
                }
                this.log("Executing: " + cmd.toString(), 3);
                try {
                    exitValue = execute.execute();
                }
                catch (IOException e) {
                    throw new BuildException("Process fork failed.", (Throwable)e, this.location);
                }
            }
            boolean errorOccurredHere = exitValue == 2;
            boolean bl = failureOccurredHere = exitValue != 0;
            if (errorOccurredHere && test.getHaltonerror() || failureOccurredHere && test.getHaltonfailure()) {
                throw new BuildException("Test " + ((JUnitTest)test).getName() + " failed", this.location);
            }
            if (!errorOccurredHere && !failureOccurredHere) continue;
            this.log("TEST " + ((JUnitTest)test).getName() + " FAILED", 0);
        }
    }

    private void rename(String source, String destination) throws BuildException {
        File src = new File(source);
        File dest = new File(destination);
        if (dest.exists()) {
            dest.delete();
        }
        src.renameTo(dest);
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setFork(boolean value) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setFork(value);
        }
    }

    public void setHaltonerror(boolean value) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setHaltonerror(value);
        }
    }

    public void setHaltonfailure(boolean value) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setHaltonfailure(value);
        }
    }

    public void setJvm(String value) {
        this.commandline.setVm(value);
    }

    public void setMaxmemory(String max) {
        if (Project.getJavaVersion().startsWith("1.1")) {
            this.createJvmarg().setValue("-mx" + max);
        } else {
            this.createJvmarg().setValue("-Xmx" + max);
        }
    }

    public void setPrintsummary(boolean value) {
        this.summary = value;
    }

    public void setTimeout(Integer value) {
        this.timeout = value;
    }
}

