/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;

public class WLStop
extends Task {
    private String classpath;
    private String username;
    private String password;
    private String serverURL;
    private int delay = 0;

    public void execute() throws BuildException {
        if (this.username == null || this.password == null) {
            throw new BuildException("weblogic username and password must both be set");
        }
        if (this.serverURL == null) {
            throw new BuildException("The url of the weblogic server must be provided.");
        }
        String execClassPath = Project.translatePath((String)this.classpath);
        Java weblogicAdmin = (Java)this.project.createTask("java");
        weblogicAdmin.setFork(true);
        weblogicAdmin.setClassname("weblogic.Admin");
        String args = String.valueOf(this.serverURL) + " SHUTDOWN " + this.username + " " + this.password + " " + this.delay;
        weblogicAdmin.setArgs(args);
        weblogicAdmin.setClasspath(new Path(this.project, execClassPath));
        weblogicAdmin.execute();
    }

    public void setClasspath(String s) {
        this.classpath = Project.translatePath((String)s);
    }

    public void setDelay(String s) {
        this.delay = Integer.parseInt(s);
    }

    public void setPassword(String s) {
        this.password = s;
    }

    public void setUrl(String s) {
        this.serverURL = s;
    }

    public void setUser(String s) {
        this.username = s;
    }
}

