/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.apache.log4j.Category;
import org.apache.log4j.NDC;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LocationInfo;

public class LoggingEvent
implements Serializable {
    private static long startTime = System.currentTimeMillis();
    static final long serialVersionUID = -868428216207166145L;
    public transient String fqnOfCategoryClass;
    public String categoryName;
    public transient Priority priority;
    public String ndc;
    public boolean ndcLookupRequired = true;
    public String message;
    public String threadName;
    public transient Throwable throwable;
    public String throwableInformation;
    public long timeStamp;
    public LocationInfo locationInfo;

    public static long getStartTime() {
        return startTime;
    }

    public String getNDC() {
        if (this.ndcLookupRequired) {
            this.ndcLookupRequired = false;
            this.ndc = NDC.get();
        }
        return this.ndc;
    }

    public String getThreadName() {
        if (this.threadName == null) {
            this.threadName = Thread.currentThread().getName();
        }
        return this.threadName;
    }

    public String getThrowableInformation() {
        if (this.throwable == null) {
            return null;
        }
        if (this.throwableInformation == null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.throwable.printStackTrace(printWriter);
            this.throwableInformation = stringWriter.toString();
        }
        return this.throwableInformation;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.getThreadName();
        this.getNDC();
        this.getThrowableInformation();
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.priority.toInt());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.priority = Priority.toPriority(objectInputStream.readInt());
        if (this.locationInfo == null) {
            this.locationInfo = new LocationInfo(null, null);
        }
    }

    public void setLocationInformation() {
        if (this.locationInfo == null) {
            this.locationInfo = new LocationInfo(new Throwable(), this.fqnOfCategoryClass);
        }
    }

    public LoggingEvent(String string, Category category, Priority priority, String string2, Throwable throwable) {
        this.fqnOfCategoryClass = string;
        this.categoryName = category.getName();
        this.priority = priority;
        this.message = string2;
        this.throwable = throwable;
        this.timeStamp = System.currentTimeMillis();
    }
}

