/*
 * Decompiled with CFR 0.152.
 */
package junit.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class TestCaseClassLoader
extends ClassLoader {
    private String[] fPathItems;
    private String[] fExcluded = new String[]{"com.sun.", "sun."};
    static final String EXCLUDED_FILE = "excluded.properties";

    public TestCaseClassLoader() {
        String classPath = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(classPath, separator);
        int i = 0;
        while (st.hasMoreTokens()) {
            st.nextToken();
            ++i;
        }
        this.fPathItems = new String[i];
        st = new StringTokenizer(classPath, separator);
        i = 0;
        while (st.hasMoreTokens()) {
            this.fPathItems[i++] = st.nextToken();
        }
        String[] excluded = this.readExcludedPackages();
        if (excluded != null) {
            this.fExcluded = excluded;
        }
    }

    public URL getResource(String name) {
        return ClassLoader.getSystemResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return ClassLoader.getSystemResourceAsStream(name);
    }

    protected boolean isExcluded(String name) {
        if (name.startsWith("java.") || name.startsWith("junit.framework") || name.startsWith("junit.extensions") || name.startsWith("junit.util") || name.startsWith("junit.ui")) {
            return true;
        }
        int i = 0;
        while (i < this.fExcluded.length) {
            if (name.startsWith(this.fExcluded[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (this.isExcluded(name)) {
            try {
                c = this.findSystemClass(name);
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (c == null) {
            File file = this.locate(name);
            if (file == null) {
                throw new ClassNotFoundException();
            }
            byte[] data = this.loadClassData(file);
            c = this.defineClass(name, data, 0, data.length);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private byte[] loadClassData(File f) throws ClassNotFoundException {
        try {
            FileInputStream stream = new FileInputStream(f);
            try {
                byte[] b = new byte[stream.available()];
                stream.read(b);
                stream.close();
                return b;
            }
            catch (IOException e) {
                throw new ClassNotFoundException();
            }
        }
        catch (FileNotFoundException e) {
            throw new ClassNotFoundException();
        }
    }

    private File locate(String fileName) {
        fileName = String.valueOf(fileName.replace('.', '/')) + ".class";
        File path = null;
        if (fileName != null) {
            int i = 0;
            while (i < this.fPathItems.length) {
                path = new File(this.fPathItems[i], fileName);
                if (path.exists()) {
                    return path;
                }
                ++i;
            }
        }
        return null;
    }

    private String[] readExcludedPackages() {
        InputStream is = this.getClass().getResourceAsStream(EXCLUDED_FILE);
        if (is == null) {
            return null;
        }
        Properties p = new Properties();
        try {
            p.load(is);
        }
        catch (IOException e) {
            return null;
        }
        Vector<String> v = new Vector<String>(10);
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("excluded.")) continue;
            String path = p.getProperty(key);
            if (path.endsWith("*")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.length() <= 0) continue;
            v.addElement(path);
        }
        String[] excluded = new String[v.size()];
        int i = 0;
        while (i < v.size()) {
            excluded[i] = (String)v.elementAt(i);
            ++i;
        }
        return excluded;
    }
}

