/*
	**
	** report.c
	**
	** Routines and data structures used to store and manage packet 
	** summary report
	**
	** Copyright 1998-1999 Damien Miller <dmiller@ilogic.com.au>
	**
	** This software is licensed under the terms of the GNU General 
	** Public License (GPL). Please see the file COPYING for details.
	** 
	** $Id: report.c,v 1.4 1999/03/27 00:12:50 dmiller Exp $
	**
 */

#include <stdlib.h>
#include <stdio.h>
#include <netdb.h>
#include <time.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "report.h"
#include "util.h"

static char rcsid[] = "$Id: report.c,v 1.4 1999/03/27 00:12:50 dmiller Exp $";

/* Prototypes */
char *resolve_hostname(u_int32_t ip_addr);

void free_report(report_t *r)
{
	free_hosts(r->hosts);
	free(r);
}

void free_host(host_t *h)
{
	if (h->hostname != NULL)
		free(h->hostname);
	free(h);
}

void free_hosts(host_t *h)
{
	host_t *last_h;

	while (h != NULL)
	{
		last_h = h;
		h = h->next;

		free_peers(last_h->peers);
		free_host(last_h);
	}
}

void free_peer(peer_t *p)
{
	free(p);
}

void free_peers(peer_t *p)
{
	peer_t *last_p;

	while (p != NULL)
	{
		last_p = p;
		p = p->next;

		free_peer(last_p);
	}
}

/* Hashes a host's ip address */
unsigned int host_hash(u_int32_t *ip_addr)
{
	return((unsigned int)(*ip_addr));
}

/* Compares two hosts */
unsigned int host_compare(u_int32_t *ip_addr1, u_int32_t *ip_addr2)
{
	return((*ip_addr1) == (*ip_addr2));
}

/* Resolves all DNS names in host list 'h' */
void resolve_hosts(host_t *h)
{
	while(h != NULL)
	{
		if (h->hostname != NULL)
			free(h->hostname);
			
		h->hostname = resolve_hostname(h->ip_addr);
		
		h = h->next;
	}
}

/* attempts to look up DNS name for ip_addr */
/* returns NULL if no name found */
/* returns name in malloc'd buffer if found */
char *resolve_hostname(u_int32_t ip_addr)
{
	struct hostent *h;
	
	if (ip_addr == INADDR_ANY)
		return(util_strdup("ALL-ZEROS"));

	if (ip_addr == INADDR_BROADCAST)
		return(util_strdup("ALL-ONES"));

	h = gethostbyaddr((char *)&ip_addr, sizeof(ip_addr), AF_INET);
	
	if ((h == NULL) || (h->h_name == NULL))
		return(NULL);
		
	return(util_strdup(h->h_name));
}
