-- `Topal': GPG/Pine integration
--
-- Copyright (C) 2001-3  Phillip J. Brooke
--
--     This program is free software; you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation; either version 2 of the License, or
--     (at your option) any later version.
--
--     This program is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
--
--     You should have received a copy of the GNU General Public License
--     along with this program; if not, write to the Free Software
--     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

with Ada.Exceptions;
with Ada.Strings.Maps;
with Ada.Text_IO;
with Echo;
with Misc;         use Misc;

package body Char_Menus is

   function Menu (Prompt : in String := Default_Prompt) return Index is
      use Ada.Strings.Maps;
      use Ada.Text_IO;
      C : Character;
   begin
      Debug("+Char_Menu.Menu");
      if Accept_Chars'Length /= Char_Words'Length
        or Accept_Chars'First /= Char_Words'First then
         raise Arrays_Not_Matched;
      end if;
      if Config.Debug then
         Debug("Char_Menu.Menu: Prompt is `" & Prompt & "'");
         begin
            for I in Accept_Chars'Range loop
               Debug("Char_Menu.Menu: Group "
                     & Index'Image(I)
                     & "  Accept_Chars=`" & ToStr(Accept_Chars(I)) & "'");
            end loop;
         exception
            when The_Exception : others =>
               Debug("Exception raised in Accept_Chars bit: "
                     & Ada.Exceptions.Exception_Name(The_Exception));
         end;
         begin
            for I in Char_Words'Range loop
               Debug("Char_Menu.Menu: Group "
                     & Index'Image(I)
                     & "  Char_Words=`" & ToStr(Char_Words(I)) & "'");
            end loop;
         exception
            when The_Exception : others =>
               Debug("Exception raised in Char_Words bit: "
                     & Ada.Exceptions.Exception_Name(The_Exception));
         end;
      end if;
      Put(Prompt);
  Entry_Loop:
      loop
         Echo.Clear_Echo;
         Debug("Menu.Char_Menu: About to Get_Immediate");
         Get_Immediate(C);
         Debug("Menu.Char_Menu: Got: `" & C
               & "'  value " & Integer'Image(Character'Pos(C)));
         Echo.Set_Echo;
         -- Now, run through the menu.
         for I in Accept_Chars'Range loop
            if Is_In(C, To_Set(ToStr(Accept_Chars(I)))) then
               Put(ToStr(Char_Words(I)));
               New_Line(2);
               Debug("-Char_Menu.Menu with value "
                     & Index'Image(I)
                     & " for character `"
                     & C & "'");
               return I;
            end if;
         end loop;
         Debug("Menu.Char_Menu: No match for character `" & C & "'");
      end loop Entry_Loop;
   exception
      when others =>
         ErrorNE("Char_Menu.Menu: In exception handler.  Re-raising.");
         raise;
         return Index'First; -- Never executed.
   end Menu;

end Char_Menus;

