#ifndef S9X_MISC_H
#define S9X_MISC_H

#include <fstream>
#include <sys/stat.h>
#include "frend.h"

class s9x_Notepage :	public fr_Notepage, protected fr_Listener {
 private:
   virtual void		EventOccurred(fr_Event*e) = 0;
 public:
   s9x_Notepage(fr_Element*parent, char*name): fr_Notepage(parent, name) {}
   virtual void		SetToDefaults() = 0;
   virtual void		SiftArgs(fr_ArgList& L) = 0;
   virtual void		CompileArgs(fr_ArgList& L) = 0;
};

class s9x_FileOps :	public fstream {
 protected:
   char			*Filename, *FileBasename;
   static char*		ExpandFilename(const char*name);
   static void		MkDir();
   static void		RmDir();
 public:
   s9x_FileOps(int fd) : fstream(fd), Filename(0) {}
   s9x_FileOps(const char*name);
   ~s9x_FileOps();
   void			SetFilename(const char*name);
   char*		GetFilename() { return FileBasename; }
   char*		GetFullname() { return Filename; }
   void			open(int mode=ios::in, int prot=0664);
   void			erase();
   int			stat(struct stat& statbuf);
   void			funnel(ios& s);
};

#endif
