#include "seaview.h"
#include <ctype.h>
#include <stdlib.h>


typedef struct {
	FL_OBJECT *scroller_field;
	FL_OBJECT *seq_name_field;
	FL_OBJECT *seq_field;
	} view_name_struct;

/* included prototypes */
void clear_callback(FL_OBJECT *ob, long val);
void refresh_callback(FL_OBJECT *ob, long val);
void remove_gaps_callback(FL_OBJECT *ob, long val);
void remove_numbers_callback(FL_OBJECT *ob, long val);
void void_callback(FL_OBJECT *ob, long val);
void load_seq_callback(FL_OBJECT *ob, long val);
void cancel_seq_callback(FL_OBJECT *ob, long val);
void load_seq_dialog(FL_OBJECT *scroller);
void add_seq_to_align(FL_OBJECT *scroller, char *newname, char *newseq, 
	int lenseq);
char complement_base(char old);
void edit_comments_dialog(FL_OBJECT *scroller);
void update_comments_callback(FL_OBJECT *ob, long val);
int load_comments(SEA_VIEW *view, FL_OBJECT *input, FL_OBJECT *name);
char *cre_consensus(SEA_VIEW *view, char *newname);


void clear_callback(FL_OBJECT *ob, long val)
{
FL_OBJECT *seq_input, *seq_name_input;
seq_name_input = ((view_name_struct *)ob->u_vdata)->seq_name_field;
seq_input = ((view_name_struct *)ob->u_vdata)->seq_field;
fl_set_input(seq_input, "");
if(seq_name_input != NULL) fl_set_input(seq_name_input, "");
}


void refresh_callback(FL_OBJECT *ob, long val)
{
FL_OBJECT *seq_input;
seq_input = ((view_name_struct *)ob->u_vdata)->seq_field;
fl_redraw_object(seq_input);
}


void remove_gaps_callback(FL_OBJECT *ob, long val)
{
FL_OBJECT *seq_input;
char *old_seq, *new_seq, *p, *q;
size_t lseq;

seq_input = (FL_OBJECT *)ob->u_vdata;
old_seq = (char *)fl_get_input(seq_input);
lseq = strlen(old_seq);
new_seq = (char *)malloc(lseq+1);
if(new_seq == NULL) return;
p = old_seq; q = new_seq;
while(*p != 0) {
	if(*p != '-' ) *(q++) = *p;
	p++;
	}
*q = 0;
fl_set_input(seq_input, new_seq);
}


void remove_numbers_callback(FL_OBJECT *ob, long val)
{
FL_OBJECT *seq_input;
char *old_seq, *new_seq, *p, *q;
size_t lseq;

seq_input = (FL_OBJECT *)ob->u_vdata;
old_seq = (char *)fl_get_input(seq_input);
lseq = strlen(old_seq);
new_seq = (char *)malloc(lseq+1);
if(new_seq == NULL) return;
p = old_seq; q = new_seq;
while(*p != 0) {
	if( ! isdigit(*p) ) *(q++) = *p;
	p++;
	}
*q = 0;
fl_set_input(seq_input, new_seq);
}


void void_callback(FL_OBJECT *ob, long val)
{
}


void load_seq_callback(FL_OBJECT *ob, long val)
{
FL_OBJECT *seq_name_input, *scroller, *seq_input;
char *name, *newseq, *tmp, *p, *q;
int lenseq;

seq_name_input = ((view_name_struct *)ob->u_vdata)->seq_name_field;
scroller = ((view_name_struct *)ob->u_vdata)->scroller_field;
seq_input = ((view_name_struct *)ob->u_vdata)->seq_field;
name = (char *)fl_get_input(seq_name_input);
if(strlen(name) == 0) {
	fl_show_alert("`Seq. name' field is empty",
		"Please enter a sequence name", "", TRUE);
	return;
	}
tmp = (char *)fl_get_input(seq_input);
lenseq = (int)strlen(tmp);
newseq = (char *)malloc(lenseq+1);
if(newseq == NULL) {
	fl_show_alert("Not enough memory", "", "", TRUE);
	return;
	}
fl_hide_form(ob->form);
p = tmp; q = newseq; lenseq = 0;
while(*p != 0) {
	if(*p != ' ' && *p != '\n') { *(q++) = toupper(*p); lenseq++;}
	p++;
	}
*q = 0;
add_seq_to_align(scroller, name, newseq, lenseq);
free(newseq);
}


void cancel_seq_callback(FL_OBJECT *ob, long val)
{
fl_hide_form(ob->form);
}


FL_OBJECT *cre_adjusted_button(int btype, int x, int y, int *w, int h, 
	char *label)
{
FL_OBJECT *obj;
*w = fl_get_string_width(FL_NORMAL_STYLE, FL_SMALL_SIZE, label, strlen(label)) +
	4 * 3;
obj = fl_add_button(btype, x, y, *w, h, label);
fl_set_object_lsize(obj, FL_SMALL_SIZE);
fl_set_object_lstyle(obj, FL_NORMAL_STYLE);
return obj;
}


void load_seq_dialog(FL_OBJECT *scroller)
{
static FL_FORM *load_form;
static int first = TRUE;
static FL_OBJECT *seq_input, *seq_name_input;

if(first) {
	FL_OBJECT *obj;
	int fin, width;
	static view_name_struct view_name;
	first = FALSE;
	load_form = fl_bgn_form(FL_FLAT_BOX,490,600);
	seq_name_input = obj = 
		fl_add_input(FL_NORMAL_INPUT,70,10,100,25,"Seq. name:");
	fl_set_object_callback(obj, void_callback, 0);
	fl_set_object_resize(obj, FL_RESIZE_NONE);
	fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
	fin = 190;
	
	obj = cre_adjusted_button(FL_NORMAL_BUTTON,fin,10,&width,25,
		"Add to alignment");
	fl_set_object_callback(obj, load_seq_callback, 0);
	fl_set_object_resize(obj, FL_RESIZE_NONE);
	fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
	obj->u_vdata = &view_name;
	fin += width + 5;
	
	obj = cre_adjusted_button(FL_NORMAL_BUTTON,fin,10,&width,25,"Cancel");
	fl_set_object_callback(obj, cancel_seq_callback, 0);
	fl_set_object_resize(obj, FL_RESIZE_NONE);
	fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
	fin += width + 5;
	
	seq_input = obj = fl_add_input(FL_MULTILINE_INPUT,10,50,470,515,
	    "Type or paste sequence with middle mouse button in panel below");
	fl_set_object_callback(obj, void_callback, 0);
	fl_set_object_lalign(obj, FL_ALIGN_TOP);
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, FL_NorthWest, FL_SouthEast);
	fl_set_object_lstyle(obj, FL_FIXED_STYLE);
	fl_set_object_lsize(obj, FL_SMALL_SIZE);
	
	fin = 60;
	obj = cre_adjusted_button(FL_NORMAL_BUTTON,fin,570,&width,25,"Refresh");
	fl_set_object_callback(obj, refresh_callback, 0);
	fl_set_object_resize(obj, FL_RESIZE_NONE);
	fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
	obj->u_vdata = &view_name;
	fin += width + 5;
	
	obj = cre_adjusted_button(FL_NORMAL_BUTTON,fin,570,&width,25,"Clear");
	fl_set_object_callback(obj, clear_callback, 0);
	fl_set_object_resize(obj, FL_RESIZE_NONE);
	fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
	obj->u_vdata = &view_name;
	fin += width + 5;
	
	obj = cre_adjusted_button(FL_NORMAL_BUTTON,fin,570,&width,25,
		"Remove gaps");
	fl_set_object_callback(obj, remove_gaps_callback, 0);
	fl_set_object_resize(obj, FL_RESIZE_NONE);
	fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
	obj->u_vdata = seq_input;
	fin += width + 5;
	
	obj = cre_adjusted_button(FL_NORMAL_BUTTON,fin,570,&width,25,
		"Remove numbers");
	fl_set_object_callback(obj, remove_numbers_callback, 0);
	fl_set_object_resize(obj, FL_RESIZE_NONE);
	fl_set_object_gravity(obj, FL_SouthWest, FL_SouthWest);
	obj->u_vdata = seq_input;
	
	view_name.scroller_field = scroller;
	view_name.seq_name_field = seq_name_input;
	view_name.seq_field = seq_input;
	fl_end_form();
	fl_set_form_atclose(load_form, simple_close_callback, NULL);
	}
fl_set_input(seq_name_input, "");
fl_set_input(seq_input, "");
fl_set_focus_object(load_form, seq_input);
if(load_form->visible) {
	my_open_and_raise_form(load_form);
	}
else 
	fl_show_form(load_form, FL_PLACE_CENTER|FL_FREE_SIZE, FL_FULLBORDER,
		"Sequence Loading");
}


void add_seq_to_align(FL_OBJECT *scroller, char *newname, char *newseq, 
	int lenseq)
{
SEA_VIEW *view;
int num, *newsel, numset;
void *newcol;

view = (SEA_VIEW *)scroller->u_vdata;
if(view->tot_seqs >= MAXNSEQS - 1) {
	fl_show_alert("Cannot create a new sequence",
		"Maximum number of sequences is reached", "", TRUE);
	return;
	}
if(lenseq > view->max_seq_length) {
	char tmp[20];
	lenseq = view->max_seq_length;
	newseq[lenseq] = 0;
	sprintf(tmp,"%d",lenseq);
	fl_show_alert("Warning: sequence was truncated to current max length",
		tmp, "", TRUE);
	}
num = view->tot_seqs + 1;
if( (view->seqname[num-1] = (char *)malloc(strlen(newname)+1)) == NULL) 
	goto nomem;
strcpy(view->seqname[num-1], newname);
if( (view->comments[num-1] = (char *)malloc(3)) == NULL) goto nomem;
strcpy(view->comments[num-1], ";\n");
if( (view->sequence[num-1] = (char *)malloc(view->max_seq_length + 1)) == NULL) 
	goto nomem;
memcpy(view->sequence[num-1], newseq, lenseq+1);
if(view->tot_seqs == 0) {
	newname = (char *) fl_show_input("Name of the new file?", "");
	init_dna_scroller(scroller, view->sequence, view->seqname, 
		1, view->comments, ( newname == NULL ? "newfile" : newname ), 
		FALSE, NULL);
	view->modif_but_not_saved = TRUE;
	{ char *q, *p = newname;
	while ( (q = strchr(p, '/')) != NULL ) p = q + 1;
	fl_wintitle(view->dnawin, p);
	}
	fl_redraw_object(view->DNA_obj);
	fl_set_menu_item_mode(view->menu_file, SAVE, FL_PUP_NONE);
	return;
	}
if( (newsel = (int *)malloc(num*sizeof(int))) == NULL) goto nomem;
memcpy(newsel, view->each_length, (num-1)*sizeof(int) );
free(view->each_length);
view->each_length = newsel;
view->each_length[num-1] = lenseq;
if(lenseq > view->seq_length) {
	double x; int l;
	view->seq_length = lenseq;
	x = ( (double) view->tot_sites ) / ( view->seq_length + 3 ); 
	if(x>1) x=1;
	fl_set_slider_size(view->horsli,x);
	l = view->seq_length - view->tot_sites+3;
	if(l<1) l=1;
	fl_set_slider_bounds(view->horsli,1,l);
	}
if(view->numb_dnacolors > 1) {
	if( (newcol = (void *)malloc(num*sizeof(void *))) == NULL) 
		goto nomem;
	memcpy(newcol, view->col_seq, (num-1)*sizeof(void *) );
	free(view->col_seq);
	view->col_seq = (char ***)newcol;
	view->col_seq[num-1] = * prepcolseqs(view->sequence+num-1, 1, 
		view->max_seq_length,
		view->each_length+num-1, 
		( view->protein ? get_color_for_aa : get_color_for_base ), 
		view->numb_gc);
	}
if( (newsel = (int *)malloc(num*sizeof(int))) == NULL) goto nomem;
memcpy(newsel, view->sel_seqs, (num-1)*sizeof(int) );
free(view->sel_seqs);
view->sel_seqs = newsel;
view->sel_seqs[num-1] = FALSE;
for(numset = 0; numset < view->numb_species_sets; numset++) {
	if( (newsel = (int *)malloc(num*sizeof(int))) == NULL) goto nomem;
	memcpy(newsel, view->list_species_sets[numset], (num-1)*sizeof(int) );
	free(view->list_species_sets[numset]);
	view->list_species_sets[numset] = newsel;
	view->list_species_sets[numset][num-1] = FALSE;
	}
view->tot_seqs = num;
view->cursor_seq = num;
view->cursor_site = 1;
view->first_site = 1;
view->modif_but_not_saved = TRUE;
fl_set_slider_value(view->horsli, 1);
set_tot_lines(view, view->tot_lines);
view->first_seq = FL_max(num - view->tot_lines + 1, 1);
fl_set_slider_value(view->vertsli, view->first_seq);
fl_redraw_object(view->DNA_obj);
fl_redraw_object(view->vertsli);
fl_redraw_object(view->horsli);
return;
nomem:
fl_show_alert("Not enough memory", "to create the new sequence",
		newname, TRUE);
}


char complement_base(char old)
{
static char bases[] = "ACGTURYMWSKVHDB";
static char compl[] = "TGCAAYRKWSMBDHV";
char *p;
if( (p = strchr(bases, old)) != NULL )
	return compl[ p - bases ];
else
	return old;
}


void edit_comments_dialog(FL_OBJECT *scroller)
{
static FL_FORM *comments_form;
static int first = TRUE;
static FL_OBJECT *comments_input, *comments_name;
SEA_VIEW *view;

if(first) {
	FL_OBJECT *obj;
	int fin, width;
	static view_name_struct comments_data;
	first = FALSE;
	comments_form = fl_bgn_form(FL_FLAT_BOX,490,600);
	
	fin = 10;
	obj = cre_adjusted_button(FL_NORMAL_BUTTON,fin,10,&width,25, "Apply");
	fl_set_object_callback(obj, update_comments_callback, 0);
	fl_set_object_resize(obj, FL_RESIZE_NONE);
	fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
	obj->u_vdata = &comments_data;
	fin += width + 5;
	
	obj = cre_adjusted_button(FL_NORMAL_BUTTON,fin,10,&width,25,"Cancel");
	fl_set_object_callback(obj, cancel_seq_callback, 0);
	fl_set_object_resize(obj, FL_RESIZE_NONE);
	fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
	fin += width + 5;
	
	obj = cre_adjusted_button(FL_NORMAL_BUTTON,fin,10,&width,25,"Refresh");
	fl_set_object_callback(obj, refresh_callback, 0);
	fl_set_object_resize(obj, FL_RESIZE_NONE);
	fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
	obj->u_vdata = &comments_data;
	fin += width + 5;

	comments_name = obj = fl_add_box(FL_DOWN_BOX, fin, 10, 480-fin, 25, "");
	fl_set_object_lalign(obj, FL_ALIGN_CENTER);
	fl_set_object_lstyle(obj, FL_FIXED_STYLE);
	fl_set_object_lsize(obj, FL_NORMAL_SIZE);
	fl_set_object_resize(obj, FL_RESIZE_X);
	fl_set_object_gravity(obj, FL_NorthWest, FL_NorthEast);

	comments_input = obj = 
		fl_add_input(FL_MULTILINE_INPUT,10,50,470,545, "");
	fl_set_object_callback(obj, void_callback, 0);
	fl_set_object_lalign(obj, FL_ALIGN_TOP);
	fl_set_object_resize(obj, FL_RESIZE_ALL);
	fl_set_object_gravity(obj, FL_NorthWest, FL_SouthEast);
	fl_set_object_lstyle(obj, FL_FIXED_STYLE);
	fl_set_object_lsize(obj, FL_SMALL_SIZE);
	
	comments_data.scroller_field = scroller;
	comments_data.seq_field = comments_input;
	fl_end_form();
	fl_set_form_atclose(comments_form, simple_close_callback, NULL);
	}
view = (SEA_VIEW *)scroller->u_vdata;
if(load_comments(view, comments_input, comments_name)) {
	fl_show_alert("Not enough memory","", "", TRUE);
	return;
	}
fl_set_focus_object(comments_form, comments_input);
if(comments_form->visible) {
	my_open_and_raise_form(comments_form);
	}
else 
	fl_show_form(comments_form, FL_PLACE_CENTER|FL_FREE_SIZE, FL_FULLBORDER,
		"Comments Editing");
}


void update_comments_callback(FL_OBJECT *ob, long val)
{
FL_OBJECT *scroller, *comments_input;
SEA_VIEW *view;
int num, l, num_l;
char *temp, *p, *q, *r;

fl_hide_form(ob->form);
scroller = ((view_name_struct *)ob->u_vdata)->scroller_field;
comments_input = ((view_name_struct *)ob->u_vdata)->seq_field;
view = (SEA_VIEW *)scroller->u_vdata;
num = comments_input->u_ldata;
num_l = 0;
p = (char *)fl_get_input(comments_input); l =strlen(p);
q = p;
while( (q = strchr(q, '\n')) != NULL) {
	q++; num_l++;
	}
if(p[l - 1] != '\n') num_l++;
temp = (char *)malloc(l + num_l + 1);
if(temp == NULL) {
	fl_show_alert("Not enough memory","", "", TRUE);
	return;
	}
r = temp;
do	{
	q = strchr(p, '\n'); if(q == NULL) q = strchr(p, 0) - 1;
	*(r++) = ';';
	memcpy(r, p, q - p + 1); r += q - p + 1;
	p = q + 1;
	}
while( *p != 0);
if( *(r - 1) != '\n') *(r++) = '\n';
*r = 0;
if(view->comments[num] != NULL) free(view->comments[num]);
view->comments[num] = temp;
view->modif_but_not_saved = TRUE;
}


int load_comments(SEA_VIEW *view, FL_OBJECT *input, FL_OBJECT *name)
{
int num;
char *temp, *p, *q, *r;

for(num = 0; num <view->tot_seqs; num++) 
	if(view->sel_seqs[num]) break;
input->u_ldata = num;
fl_set_object_label(name, view->seqname[num]);
if( view->comments[num] == NULL) {
	fl_set_input(input, "");
	return FALSE;
	}
temp = (char *)malloc(strlen(view->comments[num]) + 1);
if( temp == NULL) return TRUE;
r = temp; p = view->comments[num];
do	{
	q = strchr(p, '\n');
	memcpy(r, p + 1, q - p); r += q - p;
	p = q + 1;
	}
while( *p != 0);
*r = 0;
fl_set_input(input, temp);
free(temp);
return FALSE;
}


char *cre_consensus(SEA_VIEW *view, char *newname)
{
char *newseq, *p, *residues, unknown;
int pos, num, total, kind, dernier, maxi, vu;
static char dna_residues[]="ACGTU";
static const char prot_residues[] = "EDQNHRKILMVAPSGTFYWC";
static int freqs[30];

newseq = (char *)malloc(view->seq_length + 1);
if(newseq == NULL) return NULL;
if(view->protein) {
	residues = (char *)prot_residues;
	unknown = 'X';
	}
else	{
	residues = (char *)dna_residues;
	unknown = 'N';
	}
dernier = strlen(residues) + 1;
	
for (pos = 0; pos < view->seq_length; pos++) {
	vu = total = 0; memset(freqs, 0, dernier * sizeof(int));
	for(num = 0; num < view->tot_seqs; num++) {
		if( !view->sel_seqs[num] ) continue;
		if(pos >= view->each_length[num]) continue;
		vu++;
		if(view->sequence[num][pos] == '-') continue;
		total++;
		p = strchr(residues, view->sequence[num][pos]);
		if(p == NULL) kind = 0;
		else kind = p - residues + 1;
		++(freqs[kind]);
		}
	if(vu == 0) break;
	if(total == 0)
		newseq[pos] = '-';
	else	{
		maxi = 0;
		for(num = 0; num < dernier; num++) {
			if(freqs[num] > maxi) {
				maxi = freqs[num]; kind = num;
				}
			}
		if(kind == 0)
			newseq[pos] = unknown;
		else if( maxi >= total * (view->consensus_threshold / 100.) )
			newseq[pos] = residues[kind - 1];
		else
			newseq[pos] = unknown;
		}
	newseq[pos + 1] = 0;
	}
strcpy(newname, "Consensus");
return newseq;
}
