#include "common.h"

int serial()
{
	int a;
	int x1;
	int i,j,n1;
	
	/* Waiting for the START bit */
	do {	
		/* first we wait until a falling edge */
		while (!demodulator());
		while (demodulator());
		/* then we wait 0.5 bits */
		for(i=0;i<0x8000;i+=fskdp->phs) x1=demodulator();
	} while (x1); /* If the start bit fails we wait again */
	
	/* We now read the word data bits using DPLL */
	bit_phase=0;
	j=fskdp->nbit;
	for (a=n1=0;j;j--) {
		i=get_bit_raw();
		if (i) n1++;
		a>>=1; a|=i;
	}
	j=8-fskdp->nbit;
	a>>=j;

	/* we read the parity bit (if needed) and we check it */
	if (fskdp->parity) {
		i=get_bit_raw(); if (i) n1++;
		if (fskdp->parity==1) {		/* parity=1 (even) */
			if (n1&1) a|=0x100;	/* error */
		} else {			/* parity=2 (odd) */
			if (!(n1&1)) a|=0x100;	/* error */
		}
	}
	
	/* We read the STOP bits. All these bits must be 1.*/
        /* We don't return until all the STOP bits are 1.*/

	j=fskdp->nstop;	
	for (;;) {
		if (get_bit_raw()) {
			j--;
			if(!j) break;
		} else {
			fskdp->nstop;
			a|=0x200;	/* Framing error */
		}
	}
	
	/* We return:  */
	/* Bit 8 : Parity Error */
	/* Bit 9 : Framing Error */
	
	return a;
}
