/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Visitor;

public final class SourceFile
extends Attribute {
    private int sourcefile_index;

    public SourceFile(SourceFile sourceFile) {
        this(sourceFile.getNameIndex(), sourceFile.getLength(), sourceFile.getSourceFileIndex(), sourceFile.getConstantPool());
    }

    SourceFile(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInputStream.readUnsignedShort(), constantPool);
    }

    public SourceFile(int n, int n2, int n3, ConstantPool constantPool) {
        super((byte)0, n, n2, constantPool);
        this.sourcefile_index = n3;
    }

    public void accept(Visitor visitor) {
        visitor.visitSourceFile(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.sourcefile_index);
    }

    public final int getSourceFileIndex() {
        return this.sourcefile_index;
    }

    public final void setSourceFileIndex(int n) {
        this.sourcefile_index = n;
    }

    public final String getSourceFileName() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.sourcefile_index, (byte)1);
        return constantUtf8.getBytes();
    }

    public final String toString() {
        return "SourceFile(" + this.getSourceFileName() + ")";
    }

    public Attribute copy(ConstantPool constantPool) {
        return (SourceFile)this.clone();
    }
}

