/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;

public final class ConstantNameAndType
extends Constant {
    private int name_index;
    private int signature_index;

    public ConstantNameAndType(ConstantNameAndType constantNameAndType) {
        this(constantNameAndType.getNameIndex(), constantNameAndType.getSignatureIndex());
    }

    ConstantNameAndType(DataInputStream dataInputStream) throws IOException {
        this(dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
    }

    public ConstantNameAndType(int n, int n2) {
        super((byte)12);
        this.name_index = n;
        this.signature_index = n2;
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantNameAndType(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.signature_index);
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final String getName(ConstantPool constantPool) {
        return constantPool.constantToString(this.getNameIndex(), (byte)1);
    }

    public final int getSignatureIndex() {
        return this.signature_index;
    }

    public final String getSignature(ConstantPool constantPool) {
        return constantPool.constantToString(this.getSignatureIndex(), (byte)1);
    }

    public final void setNameIndex(int n) {
        this.name_index = n;
    }

    public final void setSignatureIndex(int n) {
        this.signature_index = n;
    }

    public final String toString() {
        return super.toString() + "(name_index = " + this.name_index + ", signature_index = " + this.signature_index + ")";
    }
}

