#include "RSGGobi.h"

#include "Rinternals.h"
/*
#include "Rdefines.h"
*/
/*
  R & S routines for querying the system values
  such as glyphs, color names, etc. in the X/GGobi
  session.
 */

USER_OBJECT_ 
RS_GGOBI(getGlyphTypes)()
{
 USER_OBJECT_ ans, names;
 int n = -1, i;
 gint *gtypes;
 const gchar **gnames;
 
  gtypes = GGOBI(getGlyphTypes)(&n); 
  gnames = GGOBI(getGlyphTypeNames)(&n); 

 PROTECT(ans = NEW_INTEGER(n));
 PROTECT(names = NEW_CHARACTER(n));

 for(i = 0; i < n; i++) {
  INTEGER_DATA(ans)[i] = gtypes[i];
  SET_STRING_ELT(names, i, COPY_TO_USER_STRING(gnames[i]));
 }

 SET_NAMES(ans, names);

 UNPROTECT(2);

 return(ans);
}


USER_OBJECT_
RS_GGOBI(getGlyphSizes)()
{
  int i;
  USER_OBJECT_ ans;

  PROTECT(ans = NEW_INTEGER(NGLYPHSIZES+1));
  for(i = 0;  i <= NGLYPHSIZES; i++)
    INTEGER_DATA(ans)[i] = i;

  UNPROTECT(1);

  return(ans);
}



USER_OBJECT_ 
RS_GGOBI(getModeNames)()
{
 USER_OBJECT_ ans;
 int n = -1, i;
 const gchar *const *gnames;
 
 gnames = GGOBI(getOpModeNames)(&n); 

 PROTECT(ans = NEW_CHARACTER(n));

 for(i = 0; i < n; i++) {
  SET_STRING_ELT(ans, i, COPY_TO_USER_STRING(gnames[i]));
 }

 UNPROTECT(1);

 return(ans);
}

void
RS_GGOBI(flush)()
{
  gdk_flush();
}
