\name{close.ggobiDisplay}
\alias{close.ggobiDisplay}
\alias{close.ggobiDisplayDescription}
\title{Close and discard a ggobi display/plot window.}
\description{
These functions allow one to discard a 
display window belonging to a ggobi instance.
}
\usage{
close.ggobiDisplay(con, ...)
close.ggobiDisplayDescription(con,...)
}
\arguments{
  \item{con}{the \code{ggobiDisplay} or \code{ggobiDisplayDescription}
   object that identifies the actual display window to be closed.}
  \item{...}{ignored but present to be consistent with the definition of the generic function.}
}
\details{
 Note that these are methods rather than functions that
can take integer values to identify the display 
and ggobi.
}
\value{
 A logical value indicating whether the close operation
 was successful (\code{TRUE}) or not (\code{FALSE}).
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}
\seealso{
 \code{\link{scatmat.ggobi}}
 \code{\link{scatterplot.ggobi}}
 \code{\link{parcoords.ggobi}}
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
  d <- g$scatmat(1:3)
  close(d)

 
  g$parcoords(1:5)
     # close based on a description, specifically
     # its type and the particular variables
     # in the plot.
  for(i in g$getDisplays(TRUE)) {
   if(names(i$Type) == "Parallel Coordinates") {
     if(!is.na(match("tars1", names(unlist(d$Plots)))))
      close(i)
   }
  }
}
\keyword{iplot}
\keyword{dynamic}

