/* Copyright (c) 2003 Hewlett-Packard Development Company, L.P.

   Permission is hereby granted, free of charge, to any person
   obtaining a copy of this software and associated documentation
   files (the "Software"), to deal in the Software without
   restriction, including without limitation the rights to use, copy,
   modify, merge, publish, distribute, sublicense, and/or sell copies
   of the Software, and to permit persons to whom the Software is
   furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be
   included in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
   NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
   BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
   ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.  */

#ifndef q_lib_h
#define q_lib_h

#include <stdio.h>

extern FILE *q_create_file (char *buf, size_t buf_size);
extern void q_close (FILE *fp);

enum q_link_method
  {
    Q_LINK_ANY = 0,
    Q_LINK_FORCE_COPY
  };

extern int q_checksummed_link (enum q_link_method lm,
			       char *buf, size_t buf_size,
			       const char *name, const char *path);

#endif /* q_lib_h */
