/* pgp4pine common.c
 *
 * See common.c for the version and license.
 * Copyright (C) 1998 by Chris Wiegand
 */

#include "defines.h"
#include "includes.h"
#include "structs.h"
#include "declares.h"
#include "externs.h"

/* *************************************************************** */

void clearScreen()
{
#ifndef NCURSES_OKAY
	int i;
	for (i=1;i<60;i++) printf("\n");
#else
	system("clear");
#endif
}

int runProcessFG(const char *commandToRun)
{
	int c;
	snprintf(debugLine,DEBUG_LINE_LENGTH,"common.c: runProcessFG (commandToRun ='%s')\n",commandToRun);
	documentStatus(debugLine);
	c = system(commandToRun);
	snprintf(debugLine,DEBUG_LINE_LENGTH,"common.c: runProcessFG Return: %i\n",c);
	return c;
}
/* ------------------------------------------------------------ */
/* Ask for an Integer Value. If none entered, use defaultVal    */
/* ------------------------------------------------------------ */

int askInteger(const char *prompt,int defaultVal)
{
	char inChar[3];
	int returnVal;
	int c;
	char ch;

	snprintf(debugLine,DEBUG_LINE_LENGTH,"common.c: askInteger (prompt = '%s', defaultVal = %i)\n",prompt,defaultVal);
	documentStatus(debugLine);

	/* This function is meant to ask a Y/N question...
	 * I think I'm amazed... CW
	 * I don't really understand it, seems to read from itself twice, but
	 * that's okay, it works, and it works great. I'll study it someday. :)
	 * This code is from Sean Farley. */
	
	do {
		printf("%s",prompt); fflush(stdout);
		if (defaultVal > 0) { printf(" [Y/n] ? "); } else { printf(" [y/N] ? "); }
		fgets(inChar, 3, stdin);

		/* Eat up loose characters in stdin buffer */
		if ((inChar[0] != '\n') && (inChar[1] != '\n'))
		{
			while ((c = fgetc(stdin)) != EOF)
			{
				if ((char) c == '\n')
				{
					break;
				}
			}

			if (c == EOF)
			{
				fprintf(stderr, "fgetc() failed\n");
			}
		}
	} while (inChar[0] != '\n' && tolower(inChar[0]) != 'y' && tolower(inChar[0]) != 'n');
	ch = tolower(inChar[0]);
	returnVal = defaultVal;
	/* ch is a char, remember? */
	if (strncmp(&ch,"y",1) == 0) returnVal = 1;
	if (strncmp(&ch,"n",1) == 0) returnVal = -1;
	snprintf(debugLine,DEBUG_LINE_LENGTH,"common.c: askInteger Return: %i\n",returnVal);
	documentStatus(debugLine);
	return returnVal;
}

/* -------------------------------------------------------------------------- */
/* Ask for a letter out of a range. If none entered, use defaultVal (if !=0). */
/* Extended to allow an additional letter, usually 'q' for quit.              */
/* -------------------------------------------------------------------------- */

int askAlphaRange(const char *prompt,char maxVal, char defaultVal, char extraVal)
{
	char inChar[3];
	int c, canLeave=0;

	snprintf(debugLine,DEBUG_LINE_LENGTH,"common.c: askAlphaRange (prompt = '%s', maxVal = '%c')\n",prompt,maxVal);
	documentStatus(debugLine);

	/* This function is meant to ask a a-z/A-Z question...
	 * I think I'm amazed... CW - it's modified from askInteger (above)
	 * I don't really understand it, seems to read from itself twice, but
	 * that's okay, it works, and it works great. I'll study it someday. :)
	 * This code is from Sean Farley / Chris Wiegand, rewritten by Holger Lamm. */
	
	/* make stdin unbuffered */
	setbuf(stdin,NULL);
	do {
		printf("%s",prompt);
		if (defaultVal) printf("[%c]:",defaultVal);
		else            putchar(':');
		fflush(stdout);
		fgets(inChar, 3, stdin);

		/* Eat up loose characters in stdin buffer */
		if ((inChar[0] != '\n') && (inChar[1] != '\n'))
		{
			while ((c = fgetc(stdin)) != EOF)
			{
				if ((char) c == '\n')
				{
					break;
				}
			}

			if (c == EOF)
			{
				fprintf(stderr, "fgetc() failed\n");
			}
			inChar[0]=c;
		}
		if (isalpha(inChar[0])) {
		   /* a-zA-Z */
		   inChar[0] = tolower(inChar[0]);
		   if (maxVal >= inChar[0]) canLeave = (int) inChar[0];
		   if (inChar[0] == extraVal) canLeave = (int) inChar[0];
		   /* At this point, canLeave is something like 'a' or 'b' */
		} else if (defaultVal && inChar[0]=='\n') {
		   canLeave=(int) defaultVal;
		}
	} while (!canLeave);
	snprintf(debugLine,DEBUG_LINE_LENGTH,"common.c: askAlphaRange Return: %c\n",canLeave);
	documentStatus(debugLine);
	setvbuf(stdin, (char *)NULL, _IOLBF, 0);	/* set back to line-buffered mode. 'setlinebuf' is not available under every OS. Reported by David Maclean. */
	return canLeave;
}

void waitForReturn()
{
	char tmpChar;
	printf("\nPlease press Enter / Return a couple times to continue.\n");
	printf("If you want to cancel, press Control-C.\n");
	if (prefsExtraCRLFAtEnd > 0) tmpChar = getchar(); /* first, to clear the cache... */
	tmpChar = getchar(); /* then for real. */
	printf("\n");
}

/* --------------------------------------------------------------------------------- */

void printUsage()
{
	printf("Usage: pgp4pine (options)\n");
	printf("-e: Encrypt / Sign file  <-- OR -->  -d: Decrypt / Verify file\n");
	printf("-i <file>: Incoming file\n");
	printf("-o <file>: Outgoing file (OPTIONAL)\n");
	printf("-t <file>: Temporary file (OPTIONAL)\n");
	printf("-k: Keep temp files (or incoming/outgoing files) after done.\n");
	printf("-r <recipients>: Recipients (OPTIONAL)\n");
	printf("Note: recipients MUST be last!\n");
	printf("Type \"man pgp4pine\" for more options.\n");
}

void printVersion()
{
	printf("pgp4pine %s\n",VERSION);
	printf("by Holger Lamm <holger@flatline.de>\n");
	printf("Homepage: http://pgp4pine.flatline.de/\n");
	printf("This program is protected by the GPL v2.\n");
}

void pipeSTDINToFile(const char *fileName)
{
	FILE *fp;
	int ch;
	if ((fp = fopen(fileName,"w")) == NULL) {
		fprintf(stderr,"Sorry, but I was unable to open the temp pipe file for input.\n");
	} else {
		do {
			ch = fgetc(stdin);
			if (ch != EOF) fputc(ch,fp);
		} while (ch != EOF);
		fclose(fp);
		fclose(stdin); /* I'm assuming this is necessary... */
	}
}

void *myMalloc(size_t size)
{
	void *newPtr;
	newPtr = calloc(size,1);
	if (!newPtr) {
		fprintf(stderr,"Fatal Error: not able to malloc (%d bytes)!\n",size);
		exit(-2);
	}
	return newPtr;
}

void myFree(void *oldPtr)
{
	if (oldPtr) free(oldPtr);
	/* Fixed: was if (!oldPtr) free (oldPtr); */
}	

void stillAlive()
{
	printf(".");
	fflush(stdout);
}
/* -------------------------------------------------------------------------- */
/* Unescape '\'-escaped letters. Happens in PGP5 and GPG UIDs. (GPG only ':') */
/* -------------------------------------------------------------------------- */

void UnescapeString(char *inString)
{
	unsigned int i=0,o=0;
	/* inString is passed back, so it's a pointer */
	do {
	  if (inString[i]=='\\') 	/* Got a '\' */
	  {
	    i++;
	    if ((inString[i]>='0') && (inString[i]<='7'))	/* an oct number */
	    {
	      inString[o] = ((inString[i]-'0') << 6) + ((inString[i+1]-'0') << 3) + inString[i+2]-'0';
	      i += 3;
	    }
	    else if ((inString[i]=='x')	|| (inString[i]=='X'))	/* hex quoted */
	    {
	      if ((inString[i+1]>='0') && (inString[i+1]<='9'))
	        inString[o] = (inString[i+1]-'0')<<4;
	      else if ((inString[i+1]>='a') && (inString[i+1]<='f'))
	        inString[o] = (inString[i+1]-'a')<<4;
	      else
	        inString[o] = (inString[i+1]-'A')<<4;
	      if ((inString[i+2]>='0') && (inString[i+2]<='9'))
	        inString[o] |= (inString[i+2]-'0');
	      else if ((inString[i+2]>='a') && (inString[i+2]<='f'))
	        inString[o] |= (inString[i+2]-'a');
	      else
	        inString[o] |= (inString[i+2]-'A');
	      i+=2;
	    }
	    else				/* another escaped character */
	      inString[o] = inString[i++];
	  } else
	    inString[o] = inString[i++];	/* nothing special */
	} while (inString[o++]!='\0');
}


