/* pgp4pine common.c 1.61
 *
 * See common.c for the version and license.
 * Copyright (C) 1998 by Chris Wiegand
 */

/* This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version. This program is distributed in the hope that it will be useful,but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details. You should have received a copy of the GNU General Public Licensealong
 * with this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "defines.h"
#include "includes.h"
#include "structs.h"
#include "declares.h"
#include "externs.h"

/* *************************************************************** */

void clearScreen()
{
#ifndef NCURSES_OKAY
	int i;
	for (i=1;i<60;i++) printf("\n");
#else
	system("clear");
#endif
}

int runProcessFG(const char *commandToRun)
{
	int c;
	snprintf(debugLine,DEBUG_LINE_LENGTH,"common.c: runProcessFG (commandToRun ='%s')\n",commandToRun);
	documentStatus(debugLine);
	c = system(commandToRun);
	snprintf(debugLine,DEBUG_LINE_LENGTH,"common.c: runProcessFG Return: %i\n",c);
	return c;
}

int askInteger(const char *prompt,int defaultVal)
{
	char inChar[3];
	int returnVal;
	int c;
	char ch;

	snprintf(debugLine,DEBUG_LINE_LENGTH,"common.c: askInteger (prompt = '%s', defaultVal = %i)\n",prompt,defaultVal);
	documentStatus(debugLine);

	/* This function is meant to ask a Y/N question...
	 * I think I'm amazed... CW
	 * I don't really understand it, seems to read from itself twice, but
	 * that's okay, it works, and it works great. I'll study it someday. :)
	 * This code is from Sean Farley. */
	
	do {
		printf("%s",prompt); fflush(stdout);
		if (defaultVal > 0) { printf(" [Y/n] ? "); } else { printf(" [y/N] ? "); }
		fgets(inChar, 3, stdin);

		/* Eat up loose characters in stdin buffer */
		if ((inChar[0] != '\n') && (inChar[1] != '\n'))
		{
			while ((c = fgetc(stdin)) != EOF)
			{
				if ((char) c == '\n')
				{
					break;
				}
			}

			if (c == EOF)
			{
				fprintf(stderr, "fgetc() failed\n");
			}
		}
	} while (inChar[0] != '\n' && tolower(inChar[0]) != 'y' && tolower(inChar[0]) != 'n');
	ch = tolower(inChar[0]);
	returnVal = defaultVal;
	/* ch is a char, remember? */
	if (strncmp(&ch,"y",1) == 0) returnVal = 1;
	if (strncmp(&ch,"n",1) == 0) returnVal = -1;
	snprintf(debugLine,DEBUG_LINE_LENGTH,"common.c: askInteger Return: %i\n",returnVal);
	documentStatus(debugLine);
	return returnVal;
}

int askAlphaRange(const char *prompt,char defaultVal,char maxVal)
{
	char inChar[3];
	int c, canLeave=0;

	snprintf(debugLine,DEBUG_LINE_LENGTH,"common.c: askAlphaRange (prompt = '%s', defaultVal = '%c', maxVal = '%c')\n",prompt,defaultVal,maxVal);
	documentStatus(debugLine);

	/* This function is meant to ask a a-z/A-Z question...
	 * I think I'm amazed... CW - it's modified from askInteger (above)
	 * I don't really understand it, seems to read from itself twice, but
	 * that's okay, it works, and it works great. I'll study it someday. :)
	 * This code is from Sean Farley modified by Chris Wiegand. */
	
	do {
		printf("%s",prompt);
//		printf(" [%c] ? ",tolower(defaultVal));
		fflush(stdout);
		fgets(inChar, 3, stdin);

		/* Eat up loose characters in stdin buffer */
		if ((inChar[0] != '\n') && (inChar[1] != '\n'))
		{
			while ((c = fgetc(stdin)) != EOF)
			{
				if ((char) c == '\n')
				{
					break;
				}
			}

			if (c == EOF)
			{
				fprintf(stderr, "fgetc() failed\n");
			}
		}
		if (isalpha(inChar[0]) != 0) {
			/* a-zA-Z */
			if (tolower(maxVal) >= tolower(inChar[0])) canLeave = (int) inChar[0];
			/* At this point, canLeave is something like 'a' or 'b' */
		}
//		if (inChar[0] == '\n') canLeave = 1;
	} while (canLeave == 0);
//	if (canLeave == 1) canLeave = defaultVal;
//	canLeave = canLeave - 'a' + 1; // we subtract 'a' (the base value) and add one.
	snprintf(debugLine,DEBUG_LINE_LENGTH,"common.c: askAlphaRange Return: %c\n",canLeave);
	documentStatus(debugLine);
	/* This is so that we return a number for the choice... */
	return canLeave;
}

void waitForReturn()
{
	char tmpChar;
	printf("\nPlease press Enter / Return a couple times to continue.\n");
	printf("If you want to cancel, press Control-C.\n");
	if (prefsExtraCRLFAtEnd > 0) tmpChar = getchar(); /* first, to clear the cache... */
	tmpChar = getchar(); /* then for real. */
	printf("\n");
}

// ---------------------------------------------------------------------------------

void printUsage()
{
	printf("Usage: pgp4pine (options)\n");
	printf("-e: Encrypt / Sign file  <-- OR -->  -d: Decrypt / Verify file\n");
	printf("-i <file>: Incoming file\n");
	printf("-o <file>: Outgoing file (OPTIONAL)\n");
	printf("-t <file>: Temporary file (OPTIONAL)\n");
	printf("-k: Keep temp files (or incoming/outgoing files) after done.\n");
	printf("-r <recipients>: Recipients (OPTIONAL)\n");
	printf("Note: recipients MUST be last!\n");
	printf("Type \"man pgp4pine\" for more options.\n");
}

void printVersion()
{
	printf("pgp4pine %s\n",MY_VERSION_STRING);
	printf("Written by Chris Wiegand <cwiegand@urgentmail.com>\n");
	printf("Current development by Holger Lamm <holger@e-technik.uni-kl.de>\n");
	printf("Homepage: http://pgp4pine.flatline.de\n");
	printf("This program is protected by the GPL v2.\n");
}

void pipeSTDINToFile(const char *fileName)
{
	FILE *fp;
	int ch;
	if ((fp = fopen(fileName,"w")) == NULL) {
		fprintf(stderr,"Sorry, but I was unable to open the temp pipe file for input.\n");
	} else {
		do {
			ch = fgetc(stdin);
			if (ch != EOF) fputc(ch,fp);
		} while (ch != EOF);
		fclose(fp);
		fclose(stdin); /* I'm assuming this is necessary... */
	}
}

void *myMalloc(size_t size)
{
	void *newPtr;
	newPtr = malloc(size);
	if (!newPtr) {
		fprintf(stderr,"Fatal Error: not able to malloc (%d bytes)!\n",size);
		exit(-2);
	}
	return newPtr;
}

void myFree(void *oldPtr)
{
	if (oldPtr) free(oldPtr);
	/* Fixed: was if (!oldPtr) free (oldPtr); */
}	

void stillAlive()
{
	printf(".");
	fflush(stdout);
}

void killFirstChar(char *inString)
{
	unsigned int c;
	/* inString is passed back, so it's a pointer */
	for (c=0;c<strlen(inString);c++) inString[c] = inString[c+1];
}

void cpString(FILE *inFile, char *buf, int maxLen)
{
	int ch;
	int i = 0;
	
	ch = fgetc(inFile);
	
	while((ch != EOF) && (ch != '\n') && (i < maxLen))
	{
		buf[i] = ch;
		ch = fgetc(inFile);
		i++;
	}
	buf[i] = '\0';
}

