// Copyright (C)  2001 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/jar_zip_utils/Jar_Entry.h,v 1.3 2001/09/19 07:17:32 gwu2 Exp $
//

#ifndef _JAR_ENTRY_H
#define _JAR_ENTRY_H

/////////////////////////////////////////////////////////////////////////////////////////
/*Jar_Entry is an entry of a zip or jar file. The zip or jar file can be opened here, and
  also can be opened somewhere else and p_JarFile point to this JarFile.
*/
/////////////////////////////////////////////////////////////////////////////////////////
/*Include the definition of JarFile, and in "JarFile.h", it includes "zlib.h".
  You also can include "zlib.h" here.

#include "zlib.h"
*/
#include "JarFile.h"					
/////////////////////////////////////////////////////////////////////////////////////////
#ifdef __cplusplus
extern "C" {
#endif

class Jar_Entry
{
/////////////////////////////////////////////////////////////////////////////////////////
public:
	Jar_Entry();
	Jar_Entry(const char*,const char*);
	Jar_Entry(JarFile*,const char*);
	~Jar_Entry();

/////////////////////////////////////////////////////////////////////////////////////////
public:
/*
Read the entry file into buf.
Notice:this function read all the content of the entry file by one time.
return:a buffer;NULL if meet errors.
*/
	Bytef* Read();

	bool Is_Open_OK();
	int Get_Entry_File_Length();

/////////////////////////////////////////////////////////////////////////////////////////
private:
	JarFile* p_JarFile;				//NULL if the file is not opened or not opened here.
	general_info* p_JarFile_Info;	//NULL if the file is not opened.

	file_in_jar_info m_Entry_Info;

	bool m_Is_Reading_Info_OK;
	file_in_reading_info m_Reading_Info;

/////////////////////////////////////////////////////////////////////////////////////////
private:
	int Get_Current_File_Info();
	int Open(const char*);
	int Check_Header_Coherency(uLong*);
	int Close();
	int Open_Current_File();
};

#ifdef __cplusplus
}
#endif

#endif		/*_JAR_ENTRY_H*/

