// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/jni_utils.h,v 1.4 2001/12/19 09:23:33 gwu2 Exp $
//




#ifndef _JNI_UTILS_H_
#define _JNI_UTILS_H_

#include "platform.h"
#include "jni.h"
#include "ini.h"


ORPExport Class_Loader *class_loader_lookup(jobject loader);
ORPExport Class_Loader *class_loader_find_if_exists(jobject loader);

ORPExport jvalue *get_jvalue_arg_array(Method *method, va_list args);

ORPExport Object_Handle put_class_in_handle(Class *clss);

int unhandle_jobjectArray(JNIEnv *env,
					   Arg_List_Iterator arglist,
                       jobjectArray args,
					   J_Value *vargs,
                       int nvargs); //from jobjectArray to J_Value

ORPExport void unhandle_jni_args(JNIEnv *env,
                       Method *method,
                       J_Value *direct_args,
                       jvalue *args,
                       unsigned num_args);



ORPExport jobject ConstructJavaConstructor (JNIEnv*, Method*);
ORPExport jobject ConstructJavaConstructor (JNIEnv*, Method*, Class_Loader*);
ORPExport jobject ConstructJavaField (JNIEnv*, Field*);
ORPExport jobject ConstructJavaMethod (JNIEnv *, Method*);
ORPExport Method* GetConstructor (JNIEnv *, jobject /* constructor */); 
ORPExport Field* GetField (JNIEnv*, jobject /* field */);
ORPExport Method* GetMethod (JNIEnv*, jobject /* method */);
ORPExport jclass GetConstructorClass (JNIEnv *, jobject /* constructor */);
ORPExport jclass GetFieldClass (JNIEnv*, jobject /* field */);
ORPExport jclass GetMethodClass (JNIEnv*, jobject /* method */);

ORPExport jclass* GetMethodParameterTypes (JNIEnv*, const char*, int*);
ORPExport jclass* GetMethodParameterTypes (JNIEnv*, const char*, int*, Class_Loader*);

ORPExport char* ParameterTypesToMethodSignature (JNIEnv*, jobjectArray);
ORPExport jclass SignatureToClass (JNIEnv*, const char*);
ORPExport jclass SignatureToClass (JNIEnv*, const char*, Class_Loader *loader);

ORPExport char* GetClassSignature (Class*);
ORPExport void GetClassSignature (Class*, char*);

ORPExport char PrimitiveNameToSignature (const char*);
ORPExport Field *LookupField (Class*, const char*);
ORPExport Method* LookupMethod (Class*, const char*, const char*);

ORPExport char* PrimitiveSignatureToName (const char sig);
ORPExport void PrimitiveSignatureToName (const char sig, char *classname);

ORPExport const char* SignatureToName (const char* sig);
ORPExport void SignatureToName (const char* sig, char *name);

// get class name from jclass
ORPExport const char* GetJClassName(jclass clazz);

jclass FindClassWithClassLoader(const char *name, Class_Loader *loader);
jclass FindClassWithContextClassLoader(const char *name);
jclass FindClassWithContextClassLoader(const char *name, int depth);

Field* LookupDeclaredField (Class *clss, const char *name);
Method* LookupDeclaredMethod (Class *clss, const char *mname, const char *msig);

#endif
