// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/Signature.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//


#ifndef _SIGNATURE_H_
#define _SIGNATURE_H_

#include <iostream.h>
#include "String_Pool.h"
#include "Mem_Manager.h"



class Signature {
public:
	Signature(String *n, String *d, Signature *t) :
	  name(n), descriptor(d), next(t) {
	  }
	String *const name;
	String *const descriptor;
	Signature *const next;	// link for hash table bucket
	void *operator new(size_t sz,Mem_Manager& m) {
		return m.alloc(sz);
	}
};



class Signature_Table {
public:
	Signature_Table(Mem_Manager& m);
	ORPExport Signature *lookup(String *name,String *descriptor);
private:
	Mem_Manager& _mem_manager;
#define SIG_TABLE_SIZE 256
	Signature *_table[SIG_TABLE_SIZE];
};


#endif // _SIGNATURE_H_
