// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/Arena.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//


#ifndef _ARENA_H_
#define _ARENA_H_

#include "orp_types.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

typedef struct Arena {
	struct Arena	*next_arena;// next arena
	char			*next_byte;	// next byte available in arena
	char			*last_byte;	// end of arena	space
	char			bytes[1];	// start of arena space
} Arena;

static const unsigned int default_arena_size = 1024;
//
// given an empty space of memory, make it into an arena of given size.
//
ORPExport Arena	*init_arena(void *space,Arena *next_arena,unsigned size);
//
// malloc (free) an arena from the global (thread-safe) heap
//
Arena	*alloc_arena(Arena *next,unsigned size);
void	free_arena(Arena *a);
//
// allocate and return space from Arena
//
void *arena_alloc_space(Arena *arena,unsigned size);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif	// _ARENA_H_
