// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/pair_table.cpp,v 1.3 2001/10/12 14:47:04 rlhudson Exp $
//

#include "platform.h"
#include "pair_table.h"
#include <string.h>
#include "orp_for_gc.h"

extern unsigned primes [];

const int NUMBER_OF_PRIMES     = 10;

const double HASH_TABLE_THRESHOLD = 0.6;

Pair_Table::Pair_Table()
: Hash_Table()
{
    if ((_value_table = (unsigned *)malloc(_size_in_bytes)) == NULL) {
        DWORD LastError = GetLastError();
        fprintf(stderr,
                "Error: malloc failed when creating pair table "
                "%d (0x%x)\n",
                LastError, LastError);
        assert(LastError);
    }

    memset((void *)_value_table, 0, _size_in_bytes);

    return;
}

Pair_Table::~Pair_Table()
/* Discard this pair table. */
{

    free((void *)_value_table);
}

int
Pair_Table::get_key_value(void *address)
{
    int offset = _get_offset(address);
    return _value_table[offset];
}

bool 
Pair_Table::is_present(void *address)
{
    return Hash_Table::is_present(address);
}

void 
Pair_Table::set_key_value(void *address, unsigned value)
{
    int offset = Hash_Table::_get_offset(address);

    if (offset >= 0) {
        _value_table[offset] = value;

    } else {
        offset = add_entry(address);
        _value_table[offset] = value;
    }
}


//
// Add an entry into this hash table, if it doesn't already exist.
//
unsigned 
Pair_Table::add_entry(void *address)
{
    unsigned table_offset = Hash_Table::add_entry(address);

    return table_offset;
}

int
Pair_Table::increment_entry(void *address)
{
    int table_offset = Hash_Table::_get_offset(address);

#if (GC_DEBUG>0)
    assert(table_offset >= 0);
#endif

    _value_table[table_offset] += 1;

    return table_offset;
}


int
Pair_Table::decrement_entry(void *address)
{
    int table_offset = Hash_Table::_get_offset(address);

#if (GC_DEBUG>0)
    assert(table_offset >= 0);
#endif

    _value_table[table_offset] -= 1;

    return table_offset;
}

//
// Remove an entry from this hash table.
//
int
Pair_Table::delete_entry(void *address)
{

    int table_offset = Hash_Table::delete_entry(address);
    //
    // If the result is not -1, then a delete did occur.
    //
    if (table_offset >= 0) {
        _value_table[table_offset] = 0;
    }

    return table_offset;
}

void
Pair_Table::empty_all()
{
    Hash_Table::empty_all();
    // This is done above.
//    memset(_value_table, 0, _size_in_bytes);
}

void
Pair_Table::_extend()

{
    free((void *)_value_table);

    unsigned size_in_bytes = sizeof (unsigned) * 
                                   primes[_prime_index + 1];

    _value_table = (unsigned *)malloc(size_in_bytes);

    if (_value_table == NULL) {
        fprintf(stderr,"Error: malloc failed when extending pair table\n");
        orp_exit(1);
    }

	memset((void *)_value_table, 0, _size_in_bytes);

    Hash_Table::_extend();
}

void *
Pair_Table::next(int *count)
{
    void *p_return = Hash_Table::next();

    if (p_return==NULL) {
        return NULL;
    }

    unsigned save_pointer;

    if (_save_pointer > 0) {
        save_pointer = _save_pointer - 1;

    } else {
        save_pointer = _size_in_entries - 1;

    }

    *count = _value_table[save_pointer];

    return p_return;
}

// end file gc\pair_table.cpp




