// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/object_list.h,v 1.1 2001/09/14 18:01:59 rlhudson Exp $
//

#ifndef _Object_List_H_
#define _Object_List_H_

//
// An Object List is used to keep track of lists of objects when
// a hash table-style remembered set or object set is overkill.
//


#include "platform.h"
#include "object_layout.h"

class Object_List {
public:
    Object_List();

    virtual ~Object_List();

    unsigned add_entry(Java_java_lang_Object *p_obj);

	Java_java_lang_Object *next(void);

    void rewind();

    void reset();

    unsigned size();

    void debug_check_list_integrity();

    void debug_dump_list();

private:

    unsigned _current_pointer;

    void _extend();

    unsigned _resident_count;

    unsigned _size_in_entries;

    Java_java_lang_Object **_store;
};


class Root_List {
public:
    Root_List();

    virtual ~Root_List();

    unsigned add_entry(Java_java_lang_Object **pp_obj);

	Java_java_lang_Object **pp_next(void);

    void rewind();

    void reset();

    unsigned size();

    void debug_check_list_integrity();

    void debug_dump_list();

private:

    unsigned _current_pointer;

    void _extend();

    unsigned _resident_count;

    unsigned _size_in_entries;

    Java_java_lang_Object ***_store;
};


#endif // _Object_List_H_

