// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/block_list.cpp,v 1.16 2002/01/11 15:47:38 weldon Exp $
//

#include "platform.h"

#include "gc_header.h"
#include "remembered_set.h"
#include "block_store.h"
#include "generation.h"
#include "descendents.h"
#include "gc_hooks.h"
#include "block_list.h"
#include "gc_asserts.h"
#include "card_table.h"
#include "step.h"
#include "los.h"
#include "nursery_step_gen.h"
#include "train_generation.h"
#include "car.h"
#include "gc_debug.h"

extern Step_Plus_Nursery_Generation *p_young_gen;

#if 0
int count16 = 0;
int count24 = 0;
int count32 = 0;
int count40 = 0;
int count48 = 0;
int count56 = 0;
int count64 = 0;
int count72 = 0;
int count84 = 0;
int count96 = 0;
int count128 = 0;
int count256 = 0;
int count512 = 0;
int count1024 = 0;
int count2048 = 0;
int count4096 = 0;
int count8192 = 0;
int count_big = 0;
#endif

//
// Cars and Steps use this routine to copy in objects when
// doing scavenges. We make sure to give the ORP an opportunity
// to update any monitor lock blocks to reflect the object move.
//
inline void fast_copy_forward_and_update_locks(Object_Gc_Header *p_old_start,
										Object_Gc_Header *p_new_start,
										unsigned real_object_size_bytes)
{
	Java_java_lang_Object *p_new_obj = P_OBJ_FROM_START(p_new_start);

#ifdef OBJECT_SPLITTING
	Java_java_lang_Object *p_old_obj = P_OBJ_FROM_START(p_old_hdr);

	Gc_Space *p_source_container = p_global_bs->p_get_address_container(p_new_obj);
	Gc_Space *p_target_container = p_global_bs->p_get_address_container(p_old_obj);

	int source_block_size = p_source_container->_p_gc_plan->step_block_size_bytes();
	int target_block_size = p_target_container->_p_gc_plan->step_block_size_bytes();
	
	// All blocks will have to be uniform for the OBJECT_SPLITTING scheme to work...
	assert(source_block_size == target_block_size);

	extern ORP_Control *p_orp_control;
	memcpy((void *)p_new_hdr, (void *)p_old_hdr, (real_object_size_bytes / 2));	
	void *p_old_cold = (void *)((POINTER_SIZE_INT) p_old_hdr + (source_block_size / 2));
	void *p_new_cold = (void *)((POINTER_SIZE_INT) p_new_hdr + (target_block_size / 2));
	memcpy((void *)p_new_cold, (void *)p_old_cold, (real_object_size_bytes / 2));	

#else
#if 0
    if (real_object_size_bytes <= 16) {
        count16++;
    } else if (real_object_size_bytes <= 24) {
        count24++;
    } else if (real_object_size_bytes <= 32) {
        count32++;
    } else if (real_object_size_bytes <= 40) {
        count40++;
    } else if (real_object_size_bytes <= 48) {
        count48++;
    } else if (real_object_size_bytes <= 56) {
        count56++;
    } else if (real_object_size_bytes <= 64) {
        count64++;
    } else if (real_object_size_bytes <= 72) {
        count72++;
    } else if (real_object_size_bytes <= 84) {
        count84++;
    } else if (real_object_size_bytes <= 96) {
        count96++;
    } else if (real_object_size_bytes <= 128) {
        count128++;
    } else if (real_object_size_bytes <= 256) {
        count256++;
    } else if (real_object_size_bytes <= 512) {
        count512++;
    } else if (real_object_size_bytes <= 1024) {
        count1024++;
    } else if (real_object_size_bytes <= 4096) {
        count4096++;
    } else if (real_object_size_bytes <= 8192) {
        count8192++;
    } else {
        count_big++;
    }
#endif
	//
	// Copy all the bytes from old location to new.
	//
	memcpy((void *)p_new_start, (void *)p_old_start, real_object_size_bytes);
#endif // OBJECT_SPLITTING

	//
	// Use the ORP callback to notify it that we have moved an object
	// so that it can update any incoming lock block pointers.
	//
#ifndef OBJECT_LOCK_V2
	orp_fixup_monitor_lock(P_OBJ_INFO_FROM_START(p_old_start), P_OBJ_INFO_FROM_START(p_new_start));
#endif
	//
	// Update the header of old obj to point to new obj header
	// and set the forward bit.
	//
	*(P_OBJ_INFO_FROM_START(p_old_start)) = ((POINTER_SIZE_INT)p_new_obj | FORWARDING_BIT_MASK);
}

Java_java_lang_Object *p_get_forwarded_object (block_info *alloc_block, Java_java_lang_Object *p_obj)
{
    assert (alloc_block?(!alloc_block->c_area_p):true); // If we have an alloc block make sure it isn't in the c area.

    if (!(GC_BLOCK_INFO(p_obj)->c_area_p)) {
        // If it isn't in the c area it can't be forwarded.
        assert (!(GC_BLOCK_INFO(p_obj)->in_los_p));
        assert (!(is_object_forwarded(p_obj)));
        return p_obj;
    }

    // LOS objects are never "forwarded"

    if (GC_BLOCK_INFO(p_obj)->in_los_p) {
        assert (!is_object_forwarded(p_obj));
        Java_java_lang_Object *temp = mark_and_scan_object(p_obj);
        assert (temp == p_obj);
        return p_obj;
    }

    if (is_object_forwarded(p_obj)) {
        assert (GC_BLOCK_INFO(p_obj)->c_area_p); // If it is forwarded it had better be in a c area.
        assert (!(GC_BLOCK_INFO(p_obj)->in_los_p));
        return p_get_already_forwarded_object(p_obj); 
    }
    
    unsigned size = get_object_size_bytes(p_obj);
    Object_Gc_Header *p_obj_start = (Object_Gc_Header *)alloc_block->free;
    Java_java_lang_Object *p_return_object;
    char *new_free = (char *)p_obj_start + size;
    if (GC_BLOCK_INFO(new_free) == GC_BLOCK_INFO(p_obj_start)) {
        // OK, there was enough space - return the object.
        p_return_object = P_OBJ_FROM_START(p_obj_start);
        unsigned int temp = GC_CARD_INDEX(p_return_object);
        alloc_block->card_last_object_table[GC_CARD_INDEX(p_return_object)] = p_return_object;
        void *p_old_start = P_OBJ_START(p_obj);
        fast_copy_forward_and_update_locks((POINTER_SIZE_INT *)p_old_start, (POINTER_SIZE_INT *)P_OBJ_START(p_return_object), size);
        assert (GC_BLOCK_INFO(p_return_object)->in_los_p || (!GC_BLOCK_INFO(p_return_object)->c_area_p));
        gc_trace (p_return_object, "Moving object to a this new location");
        alloc_block->free = new_free; // Commit after all slots are in place or cheney fetcher could see garbage.
        return p_return_object;
    } else {
        if (alloc_block->train_birthday) { 
            // We have an alloc block in a car...
            // Should we create a new car??
            car_info *this_car = alloc_block->list_info;
            train_info *this_train = this_car->my_train;
            block_info *a_block = this_car->blocks;
            unsigned int block_count = 0;
            while (a_block) {
                block_count++;
                a_block = a_block->next;
            }
            if (block_count > GC_MAX_BLOCKS_PER_CAR) {
                add_car(this_train);
                return p_get_forwarded_object(this_train->last_car->alloc_block, p_obj); // Retry with new car blocks in same train.
            }
        }

        block_info *new_alloc_block = p_get_new_block(true, false, true); // extend heap if we need to we are in a GC
        
        new_alloc_block->in_free_p = false;
        new_alloc_block->in_step_p = alloc_block->in_step_p;
        assert(gc_block_status_table[new_alloc_block->block_status_table_index] == block_in_free);
        gc_block_status_table[new_alloc_block->block_status_table_index] = gc_block_status_table[alloc_block->block_status_table_index];
        assert (gc_block_status_table[new_alloc_block->block_status_table_index] != block_in_free);
        alloc_block->next = new_alloc_block;
        new_alloc_block->list_info = alloc_block->list_info;
        new_alloc_block->train_birthday = alloc_block->train_birthday;
        new_alloc_block->car_birthday = alloc_block->car_birthday;
        alloc_block->list_info->alloc_block = new_alloc_block;
        alloc_block = alloc_block->next;
        gc_trace_block ((void *)alloc_block, "p_get_forwarded_object allocs a new block");
        return p_get_forwarded_object(alloc_block, p_obj); // Retry
    }
    assert (0); // Should return from some spot above.
    return NULL;
}


train_info *get_youngest_train ()
{
    if (fixed_gc) {
        return NULL;
    }
    train_info *youngest_train = trains;
    while (youngest_train->next) {
        youngest_train = youngest_train->next;
        assert (youngest_train->previous);
        assert ((youngest_train->previous->birthday + 1) == youngest_train->birthday);
    }
    return youngest_train;
}

//
// This takes a slot in the heap in an array or an object, if the target is in a c area
// we move the target and update the slot. We also check to see if the slot
// is interesting and if it is we mark the related card.
//
void scan_array_object(Java_java_lang_Object *p_object);
// "this" is the block list holding the object being scanned.

//
// scan_slot - Given a slot in an object (or array) scan it, possible causing the
//             object to be copied into "TO" space. If the object is in "TO" space
//             then update the slot to point to the correct version.
// return    - true if this results in an interesting pointer being installed that 
//             requires that the corresponding card needs to be marked.
//

inline boolean scan_slot(Java_java_lang_Object **pp_target_object, block_info *slot_block_info) 
{
    boolean mark_card = false;
    // ignore NULL
    if (*pp_target_object != NULL) {
        block_info *target_block_info = GC_BLOCK_INFO(*pp_target_object);
        assert (!slot_block_info->in_nursery_p); // We never scan nursery items.
        // We have a slot holding an object in a c area. 
        // If the target c area is a nursery, move it to the step.
        // If the target c area is a step, move it to the youngest car in the youngest train.
        
        if (target_block_info->c_area_p) {
            if (target_block_info->in_nursery_p) {
                assert (!target_block_info->in_step_p);
                *pp_target_object = p_get_forwarded_object (step->alloc_block, *pp_target_object);
                // target object is in a nursery so we move the object into a step.
            } else {
                // It isn't in the nursery so it is going into a train somewhere.
                block_info *to_alloc_block;
                if (slot_block_info->train_birthday) {
                    // We are in mature space or train birthday would be 0.
                    to_alloc_block = slot_block_info->list_info->my_train->last_car->alloc_block;
                } else {
                    if (fixed_gc) {
                        to_alloc_block = NULL; // fixed GC should not need an alloc block.
                    } else {
                        // Its in a step so move it into the youngest car in the youngest train.
                        train_info *temp_train = get_youngest_train();
                        to_alloc_block = temp_train->last_car->alloc_block;
                    }
                }
                *pp_target_object = p_get_forwarded_object (to_alloc_block, *pp_target_object);
            }
        }
        // Object could have been moved so get the new target block info.
        target_block_info = GC_BLOCK_INFO(*pp_target_object);
        // Only in MOS are interesting.
        // YOS and LOS objects are considered born at time 0 so are always older.
        // Slots in trains younger than targets are interesting. This includes all MOS->YOS
        // Slots and targets in the same train where target is in younger car is interesting.
        // Since we are comparing birthdays > means younger. Someone born in 1980 is younger (>) than 1950 
        if (slot_block_info->train_birthday != 0)  {
            // Slot is in MOS.
            if (slot_block_info->train_birthday > target_block_info->train_birthday) {
                // Slot is in younger train so remember this.
                mark_card = true;
            } else {
                if (slot_block_info->train_birthday == target_block_info->train_birthday) {
                    // We are in the same train.
                    if (slot_block_info->car_birthday > target_block_info->car_birthday) {
                        // We are in the same train but slot car is younger than target car
                        mark_card = true;
                    }
                }
            }
        }
    }
    return mark_card;
}

void
scan_object(Java_java_lang_Object *p_object)
{   
    // We have an object header, get the object
    boolean mark_card = false; // set to true if we find a slot that is interesting.
    
    gc_trace (p_object, "In scan_object scanning this object");
    
    if (is_array(p_object)) {
        scan_array_object (p_object);
        return;
    }
    block_info *slot_block_info = GC_BLOCK_INFO(p_object);
    unsigned int *offset_scanner = init_object_scanner (p_object);
    Java_java_lang_Object **pp_target_object;
    while ((pp_target_object = p_get_ref(offset_scanner, p_object)) != NULL) {
        // Move the scanner to the next reference.
        offset_scanner = p_next_ref (offset_scanner);
        if (scan_slot (pp_target_object, slot_block_info)) {
            mark_card = true;
        }
    }
    
    if (mark_card) {
        // Mark the card so it will be scanned next time around.
        slot_block_info->card_table[GC_CARD_INDEX(p_object)] = true;
    }
    
    return;
}

void
scan_array_object(Java_java_lang_Object *p_object)
{
    bool mark_card = false;
    block_info *slot_block_info = GC_BLOCK_INFO(p_object);
    
    // If array is an array of primitives, then there are no references, so return.
    if (is_array_of_primitives(p_object)) {
        return;  // false
    }
    
    // Initialize the array scanner which will scan the array from the
    // top to the bottom. IE from the last element to the first element.
    
    unsigned int offset = init_array_scanner (p_object);
    
    //
    // Cycle through all the descendents.
    //
    Java_java_lang_Object **pp_target_object;
    while ((pp_target_object = p_get_array_ref(p_object, offset)) != NULL) {
        offset = next_array_ref (offset);
        if (scan_slot (pp_target_object, slot_block_info)) {
            mark_card = true;
        }
    }
    
    if (mark_card) {
        // Mark the card so it will be scanned next time around.
        slot_block_info->card_table[GC_CARD_INDEX(p_object)] = true;
    }
    return; 
}

#ifdef GC_SAPPHIRE
//
//  This takes blocks in arg1's block list and moves them to arg2's block list.
//  The blocks in arg1 list are removed and interesting param are updated.
//
void Block_List::scavenge_block(void *the_block, 
                                 int the_size_bytes,
                                 void *block_end)
{
    assert ((char *)block_end <= ((char *)the_block+the_size_bytes));
    _p_block[_number_of_blocks] = the_block;
    _p_block_end[_number_of_blocks] = (Object_Gc_Header *)block_end;
    _p_free = block_end; // Since this can be for a step _p_free should not be changed.
    _p_scan = block_end; // One can only scavenge scanned blocks.
    _p_scan_start = block_end;
mumble gone    _p_base = the_block;
    // Since we are scavenging blocks then we won't be doing any scanning 
    // so _current_block_id is not used.
    _current_block_id = _number_of_blocks; // point to this the last block.
    _number_of_blocks++;
    p_global_bs->set_address_container (the_block, this);
    assert (((Byte *)the_block + (unsigned long)the_size_bytes) > (Byte *)block_end);
    assert ((Byte *)the_block <= (Byte *)block_end);
    assert (_current_block_id == (_number_of_blocks - 1));
}
#endif // GC_SAPPHIRE




//
// After a reclaim, the Mrl_Gc_Vxxx calls each generation 
// to give it an opportunity to clean up. Step_Generation calls us.
//
void
Block_List::cleanup()
{
    assert(0);
    orp_cout << "Error: Block_List::cleanup stub" << endl;
    orp_exit(1); // who calls me?
}


// end file gc\block_list.cpp
