// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/gc_debug.cpp,v 1.2 2001/10/01 13:38:01 rlhudson Exp $
//

#include "platform.h"

#include "gc_space.h"
#include "remembered_set.h"
#include "Block_Store.h"
#include "card_table.h"
#include "descendents.h"
#include "gc_hooks.h"
#include "generation.h"
#include "nursery_step_gen.h"
#include "car.h"
#include "train.h"
#include "obsolete_space.h"
#include "Class.h"
#ifdef _DEBUG
// If GC_DEBUG is 0 then this is an inline empty latency free routine..

// We have a selection of 4 objects that are normally NULL.
// If we want to trace an object we set the address of one
// of the objectn to the object we want to trace.
void *object1 = (void *)0x0 ; // 166f490; //0x01c5a928; 
void *object2 = (void *)0x0 ; // The object holding the slot pointing to 13e9144 .
void *object3 = (void *)0x0 ; // object is moved from step into oldest car during gc 1 a YOS gc.
void *object4 = (void *)0x0 ; // The object pointing to the object with the slot pointing to the array...

// This is called from a lot of places and if the object passed in
// and non-NULL and equal one of the objects being traced then
// string_x is printed out along with the object. 
void gc_trace (void *object, const char *string_x)
{
    // The NULL object is not interesting
    if (!object) {
        return;
    }
    if ((object==object1)||(object==object2)||(object==object3)||(object==object4)) {
        orp_cout << " GC Trace " << object << " " << string_x << endl;
        if (((Java_java_lang_Object *)object)->vt) {
            // Sometimes the JIT doesn't give us the base so be careful
            orp_cout << " The vt is " << ((Java_java_lang_Object *)object)->vt << endl;
            orp_cout << " The class is " << ((VTable *)((Java_java_lang_Object *)object)->vt)->clss << endl;
        } else {
            // On IA32, some of the JITs don't pass the base of the object instead
            // they pass the slot. This is not what the interface says but for historical 
            // reasons (Changing the JIT would require too much effort) this has not
            // been done.
            orp_cout << " This object has a null vtable, it might be broken." << endl;
        }
    }
    return;
}


void **object_slot1 = (void **)0x0;
void **object_slot2 = (void **)0x0;
void **object_slot3 = (void **)0x0;
void **object_slot4 = (void **)0x0;
void **object_slot5 = (void **)0x0;
void gc_trace_slot (void **object_slot, void *object, const char *string_x) {
    
    if ((object_slot==object_slot1)||(object_slot==object_slot2)||(object_slot==object_slot3)
        ||(object_slot==object_slot4)||(object_slot==object_slot5)) {
        orp_cout << " GC Slot Trace " << object_slot << " with value " << object << " " << string_x << endl;
    }
    return;
}
#endif // (GC_DEBUG>0) 
//
// This API can be called at debug time by the ORP to determine
// if the specified reference is to a live, valid Java object.
// The answer is approximate, however, since live objects can
// take the places of previous dead objects. (I.e. the response
// may occasionally mislead the ORP.)
//
bool is_valid_java_object(Java_java_lang_Object *p_obj_ref)
{
	//
	// If the reference isn't in the heap, clearly the answer
	// is NO, since all valid Java objects should be 
	// in the GC heap.
	//
	if (p_global_bs->is_object_outside_heap(p_obj_ref)) {
		return false;
	}

	//
	// The object may appear to be valid, but it may be in
	// an obsolete FROM space. (The forward bit will be set,
	// though.) So we next check to see if the container is
	// obsolete.
	//
	Gc_Space *p_container = 
		p_global_bs->p_get_object_container(p_obj_ref);

	if (p_container->is_obsolete()) {
		return false;
	}
	//
	// Finally the acid test. We can tell definitively if
	// this is an object by checking to see if the VTable
	// pointer is to a known VTable. (We maintain a database
	// of valid VTable pointers in the class loader code.)
	//
	if (is_java_object(p_obj_ref)) {
		return true;
	}

	return false;
}

#if (GC_DEBUG>3)
extern Block_Store *p_global_bs;
extern Gc_Interface *p_gc;
void __stdcall orp_dump_object_and_return_ip(void *obj, void *eip);

bool trace_aux (Java_java_lang_Object **pp_obj_ref, 
                Java_java_lang_Object *p_obj)
{
    return true;
}

void trace_graph_to_object(Remembered_Set *p_rs,
                           Java_java_lang_Object *p_obj)
{
    Java_java_lang_Object **pp_obj_ref;
    p_rs->rewind();

    while ((pp_obj_ref = p_rs->next()) != NULL) {
        if (*pp_obj_ref == p_obj) {
            //
            // The live reference points directly to the object.
            //
        } else {
            if (trace_aux(pp_obj_ref, p_obj)) {
                cout << pp_obj_ref << endl;
            }
        }
    }
}

void display(void *p_addr)
{
 	Gc_Space *p_gc_space = 0;
	Car *p_car = 0;
	//Step *p_step;
	Train *p_train = 0;
	//Nursery *p_nursery;
	Generation *p_gen = 0;
	//Train_Generation *p_t_gen;
	//Step_Generation *p_s_gen;
	//Step_Plus_Nursery_Generation *p_ns_gen;

	p_gc_space = p_global_bs->p_get_address_container(p_addr);
	p_gc_space->inspect(0);
    (((Obsolete_Space *)p_gc_space)->p_previous)->inspect(0);

	p_car = (Car *)p_global_bs->p_get_address_container(p_addr);
	p_train = p_car->p_get_train();
	p_train->inspect(0);

	//
	// Display remembered set of a car
	//
	//p_car->dump_container_write_barrier();
	p_car->inspect(0);

    // display obsolete container

	// display gc interface
	extern Gc_Interface *p_gc;
	((Mrl_Gc_V1 *)p_gc)->inspect(0);

	// display generation
	p_gen->inspect(0);

}
#endif // _DEBUG

// end file gc_space.cpp


