// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/common/object_generic.cpp,v 1.10 2001/11/20 20:09:22 rlhudson Exp $
//
#ifndef  OBJECT_LOCK_V2
#include "platform.h"
#include <assert.h>
#include <iostream.h>

#include "orp_types.h"
#include "Class.h"
#include "stack_manipulation.h"
#include "exceptions.h"
#include "environment.h"
#include "object_layout.h"
#include "orp_threads.h"
#include "nogc.h"
#include "root_set_enum.h"
#include "orp_utils.h"
#include "orp_synch.h"
#include "sync_bits.h"

#include "mon_enter_exit.h"

#include "object_generic.h"
#include "object_manager.h"

#include "orp_stats.h"

#ifdef OBJECT_SPLITTING
#include "gc_interface.h"
#endif // OBJECT_SPLITTING


#ifdef ORP_POSIX
#include "platform2.h"
#ifdef __linux__
#include <asm/bitops.h>
#endif
#endif

///////////////////////////////////////////////////////////////////////////////
///////////////
/////////////// WARNING: start_of_object_busybit_critical_zone() MUST BE  THE FIRST
///////////////
/////////////// PROCEDURE IN java_lang_Object.cpp
///////////////
///////////////////////////////////////////////////////////////////////////////

void start_of_object_generic_busybit_critical_zone()
{
////////////// THIS MUST BE THE FIRST PROCEDURE IN java_lang_Object.cpp
////////////// SEE in_busybit_critical_zone() for details
}


uint32 quick_hash_counter;


void java_lang_Object_registerNatives(Java_java_lang_Object *)
{
} //java_lang_Object_registerNatives


void java_lang_Object_notify (Java_java_lang_Object *p_obj)
{
    volatile Java_java_lang_Object *p_obj_volatile = p_obj;
    GC_Frame gcf1;
    orp_push_gc_frame(&gcf1, (void *)&p_obj_volatile, sizeof(void *) );
    orp_enable_gc();

    p_thread_lock->_lock_enum();

    orp_disable_gc();
    orp_pop_gc_frame(&gcf1);

    ORP_thread *p_orpthread = p_TLS_orpthread;    

#ifdef _DEBUG
    p_orpthread->number_of_notify++;
#endif

    Lock_Block *p_lock_chain;
    volatile POINTER_SIZE_INT *p_header = P_OBJ_INFO(p_obj_volatile);

    ACQUIRE_BUSY_BIT(p_header);

    // no lock blocks (thus nobody waiting for notify)
    if (  (*p_header & QUICK_RECURSION_MASK) == 0) {
        RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////

        p_thread_lock->_unlock_enum();

        return;
    }

    // the thread doing the notify() must own the lock
    if ( (*p_header & QUICK_RECURSION_MASK) == SLOW_LOCKING) {
        p_lock_chain = (Lock_Block *)(*p_header & LOCK_BLOCK_POINTER_MASK);

        // BUGBUG remove the following line after debugging
        assert( (p_lock_chain->old_object_header & QUICK_THREAD_INDEX_MASK) == 
                    p_orpthread->quick_thread_index_shifted_left);

        if ( (p_lock_chain->old_object_header & QUICK_THREAD_INDEX_MASK) != 
                    p_orpthread->quick_thread_index_shifted_left)
        {
            RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////
            assert(0);  // BUGBUG remove after debug
            throw_java_exception("java/lang/IllegalMonitorStateException");
        }

        while(1) {  // find the first thread that needs a "notify()" (if it exists)
            if (p_lock_chain->lock_or_wait_state == waiting_for_the_notify) break;

            p_lock_chain = p_lock_chain->p_forward_link;

            if (p_lock_chain == 0) break;
        }
        if ((p_lock_chain != 0) &&
            (p_lock_chain->lock_or_wait_state == waiting_for_the_notify) &&
            
            // the following line allows a java_lang_Thread_interrupt0() to happen
            // concurrently with this java_lang_Object_notify()
            (p_lock_chain->p_orp_thread->app_status == thread_is_waiting)    )
        {
            //_ F->F, F->D, E->D
            p_lock_chain->lock_or_wait_state = waiting_for_the_lock;
           
            assert(p_lock_chain->lock_recursion_count_shifted_left != 0);

            assert(p_lock_chain->p_orp_thread->app_status == thread_is_waiting);

            assert(p_lock_chain->p_orp_thread->which_trap == x_java_wait);

            assert(p_lock_chain->p_orp_thread->gc_status == gc_at_safepoint);
        }

#ifdef _DEBUG
        queue_verifier((volatile Java_java_lang_Object *)p_obj_volatile);
#endif            
        RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////

        p_thread_lock->_unlock_enum();

        return;
    }
    // nobody is waiting for notify, throw exception if we don't hold the lock 

    if ( (*p_header & QUICK_THREAD_INDEX_MASK) != p_orpthread->quick_thread_index_shifted_left)
    {
        assert(0);  // BUGBUG -- toss this after debugging
        RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////
        p_thread_lock->_unlock_enum();
        throw_java_exception("java/lang/IllegalMonitorStateException");
    }
#ifdef _DEBUG
        queue_verifier((volatile Java_java_lang_Object *)p_obj_volatile);
#endif  
    RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////////

    p_thread_lock->_unlock_enum();
}


void java_lang_Object_notifyAll (/*struct*/ Java_java_lang_Object *p_obj)
{
    volatile Java_java_lang_Object *p_obj_volatile = p_obj;

    GC_Frame gcf1;
    orp_push_gc_frame(&gcf1, (void *)&p_obj_volatile, sizeof(void *) );

    orp_enable_gc();
    p_thread_lock->_lock_enum();
    orp_disable_gc();

    orp_pop_gc_frame(&gcf1);  
    ORP_thread *p_orpthread = p_TLS_orpthread;    

#ifdef _DEBUG
    p_orpthread->number_of_notifyAll++;
#endif

    Lock_Block *p_lock_chain;
    volatile POINTER_SIZE_INT *p_header = P_OBJ_INFO(p_obj_volatile);

    ACQUIRE_BUSY_BIT(p_header); 

    // no lock blocks (thus nobody waiting for notifyAll)
    if (  (*p_header & QUICK_RECURSION_MASK) == 0) {
        RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////

        p_thread_lock->_unlock_enum();
        return;
    }
    // the thread doing the notify() must own the lock
    if ( (*p_header & QUICK_RECURSION_MASK) == SLOW_LOCKING) {
        p_lock_chain = (Lock_Block *)(*p_header & LOCK_BLOCK_POINTER_MASK);

        if ( (p_lock_chain->old_object_header & QUICK_THREAD_INDEX_MASK) != 
                    p_orpthread->quick_thread_index_shifted_left)
        {
            assert(0);  // BUGBUG remove after debug
            // toss LeaveCriticalSection(&thread_CriticalSection);
            p_thread_lock->_unlock_enum();
            throw_java_exception("java/lang/IllegalMonitorStateException");
        }

        while(1) {  // find all threads that need a "notify()" (if they exist)

            if ((p_lock_chain != 0) &&
                (p_lock_chain->lock_or_wait_state == waiting_for_the_notify) &&
            
                // the following line allows a java_lang_Thread_interrupt0() to happen
                // concurrently with this java_lang_Object_notify()
                (p_lock_chain->p_orp_thread->app_status == thread_is_waiting)    )

            {
                p_lock_chain->lock_or_wait_state = waiting_for_the_lock;

                assert(p_lock_chain->lock_recursion_count_shifted_left != 0);

                assert(p_lock_chain->p_orp_thread->app_status == thread_is_waiting);

                assert(p_lock_chain->p_orp_thread->which_trap == x_java_wait);

                assert(p_lock_chain->p_orp_thread->gc_status == gc_at_safepoint);
            }

            p_lock_chain = p_lock_chain->p_forward_link;

            if (p_lock_chain == 0) break;
        }

#ifdef _DEBUG
        queue_verifier(p_obj_volatile);
#endif
        RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////

        p_thread_lock->_unlock_enum();
        return;
    }       
    // nobody is waiting for notifyAll, throw exception if we don't hold the lock 

    if ( (*p_header & QUICK_THREAD_INDEX_MASK) != p_orpthread->quick_thread_index_shifted_left)
    {
        assert(0);  // BUGBUG -- toss this after debugging
        RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////
        // toss LeaveCriticalSection(&thread_CriticalSection);
        p_thread_lock->_unlock_enum();
        throw_java_exception("java/lang/IllegalMonitorStateException");
    }
    RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////////
    p_thread_lock->_unlock_enum();
}


void java_lang_Object_wait(Java_java_lang_Object *p_obj, int64 msec)
{
    volatile Java_java_lang_Object *p_obj_volatile = p_obj;
    GC_Frame gcf1;
    orp_push_gc_frame(&gcf1, (void *)&p_obj_volatile, sizeof(void *) );
    orp_enable_gc();

    p_thread_lock->_lock_enum();

    orp_disable_gc();
    orp_pop_gc_frame(&gcf1);  

    ORP_thread *p_orpthread = p_TLS_orpthread;    
    assert(quick_thread_id[p_orpthread->quick_thread_index].p_orpthread);
    assert(p_orpthread->p_latest_wait_lock_block == 0);
    bool do_a_SetEvent = false;
    HANDLE event_handle_for_SetEvent = 0;
    DWORD status = 0;

    assert(p_orpthread->p_current_object == 0);
    p_orpthread->p_current_object = p_obj_volatile;

#ifdef _DEBUG
    p_orpthread->number_of_wait++;
#endif
    Lock_Block *p_lock_chain;

    volatile POINTER_SIZE_INT *p_header = P_OBJ_INFO(p_obj_volatile);
    ACQUIRE_BUSY_BIT(p_header);

    volatile POINTER_SIZE_INT xx = *p_header & QUICK_RECURSION_MASK;
    if (xx == 0) {
		p_orpthread->p_current_object = 0;
        RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////
        // the thread doing the wait() must own the lock
        p_thread_lock->_unlock_enum();
        throw_java_exception("java/lang/IllegalMonitorStateException");
    }
    if (xx != SLOW_LOCKING)
        if ( (*p_header & QUICK_THREAD_INDEX_MASK) != 
                p_orpthread->quick_thread_index_shifted_left)
            {
                // the thread doing the wait() must own the lock  
                assert(0);  //BUGBUG remove after debugging
				p_orpthread->p_current_object = 0;
                RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////
                p_thread_lock->_unlock_enum();
                throw_java_exception("java/lang/IllegalMonitorStateException");
            }

    if (xx == SLOW_LOCKING)
         p_lock_chain = (Lock_Block *)(*p_header & LOCK_BLOCK_POINTER_MASK);
    else p_lock_chain = 0;  // to stop a wild pointer early

    assert(p_orpthread->app_status == thread_is_running);

    if (xx == SLOW_LOCKING)
    {
        if( (p_lock_chain->old_object_header & QUICK_THREAD_INDEX_MASK) !=
            p_orpthread->quick_thread_index_shifted_left)
        {
            // the thread doing the wait() must own the lock  
            assert(0);  //BUGBUG remove after debugging
			p_orpthread->p_current_object = 0;
            RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////
            p_thread_lock->_unlock_enum();
            throw_java_exception("java/lang/IllegalMonitorStateException");
        }

        // do the following asserts to make sure lock blocks are in order
        if ( (p_lock_chain->old_object_header & QUICK_RECURSION_MASK) == SLOW_LOCKING)
        {
            assert(p_lock_chain->p_orp_thread == p_orpthread);
            assert(p_lock_chain->lock_or_wait_state == holding_the_lock);
        }
        else
        {
            assert(p_lock_chain->p_orp_thread != p_orpthread);
            assert( (p_lock_chain->lock_or_wait_state == waiting_for_the_notify)  ||
                    (p_lock_chain->lock_or_wait_state == waiting_for_the_lock )  );
        }
    }
    
    Lock_Block *p_new_wait_block;
    if ( (xx == SLOW_LOCKING) && (p_lock_chain->p_orp_thread == p_orpthread) )
    {
        p_new_wait_block = p_lock_chain;  // deep recursion, already alloc'ed the lock block
        // code below will pick up the hash from this location
        if (p_lock_chain->p_forward_link)
            p_lock_chain->p_forward_link->old_object_header =
                p_lock_chain->old_object_header & QUICK_HASH_MASK;
        // unlink this lock block (so it can get re-linked below)
        p_lock_chain = p_lock_chain->p_forward_link;
        if (p_lock_chain)
            p_lock_chain->p_back_link = 0;
    }
    else
    {   // shallow recursion, thus need to alloc a lock block
        p_new_wait_block = get_a_block(p_orpthread);
        if (xx == SLOW_LOCKING) {
            p_new_wait_block->lock_recursion_count_shifted_left = 
                (p_lock_chain->old_object_header) & QUICK_RECURSION_MASK;
        }
        else
            p_new_wait_block->lock_recursion_count_shifted_left =
                *p_header & QUICK_RECURSION_MASK;
    }

#ifdef _DEBUG
    p_orpthread->p_latest_wait_lock_block = p_new_wait_block;
    queue_verifier(p_obj_volatile);
#endif

    p_new_wait_block->lock_or_wait_state = waiting_for_the_notify;

    if (xx != SLOW_LOCKING) 
    {
        //_ B->C
        assert( (*p_header & QUICK_THREAD_INDEX_MASK) == 
                        p_orpthread->quick_thread_index_shifted_left);
        p_new_wait_block->p_object_header = p_header;
        p_new_wait_block->old_object_header = *p_header;
        p_new_wait_block->old_object_header &= ~QUICK_RECURSION_MASK;
        p_new_wait_block->lock_recursion_count_shifted_left =
            *p_header & QUICK_RECURSION_MASK;
        assert( p_new_wait_block->lock_recursion_count_shifted_left != 0);
        POINTER_SIZE_INT new_header = ( (POINTER_SIZE_INT)p_new_wait_block ) & LOCK_BLOCK_POINTER_MASK;
        new_header = new_header | SLOW_LOCKING | BUSY_FORWARDING_BIT;

        // NOTE: the next line does not turn off busy bit yet
        *p_header = new_header; ////////////////////////////////////////////////
    }

    else if ( (p_lock_chain->lock_or_wait_state == waiting_for_the_lock ) &&
              (p_lock_chain->lock_recursion_count_shifted_left > QUICK_RECURSION_ABOUT_TO_OVERFLOW) )
    {   //_ D->E
        p_lock_chain->lock_or_wait_state = holding_the_lock;

        POINTER_SIZE_INT saved_header = p_lock_chain->old_object_header & QUICK_HASH_MASK;
        saved_header |= p_lock_chain->p_orp_thread->quick_thread_index_shifted_left;
        assert(p_lock_chain->lock_recursion_count_shifted_left != 0);
        saved_header |= SLOW_LOCKING;
        saved_header |= BUSY_FORWARDING_BIT;
        p_lock_chain->old_object_header = saved_header;

        POINTER_SIZE_INT new_header = ( (POINTER_SIZE_INT)p_new_wait_block ) & LOCK_BLOCK_POINTER_MASK;
        new_header = new_header | SLOW_LOCKING | BUSY_FORWARDING_BIT;

        // NOTE: the next line does not turn off busy bit yet
        *p_header = new_header; ////////////////////////////////////////////////
    }
    else if ( (p_lock_chain->lock_or_wait_state == waiting_for_the_lock ) &&
              (p_lock_chain->lock_recursion_count_shifted_left <= QUICK_RECURSION_ABOUT_TO_OVERFLOW) )
    {
        //_ D->E, D->F, E->E, F->F
        assert(p_lock_chain->lock_recursion_count_shifted_left != 0);
        assert(p_lock_chain->p_back_link == 0);

        // put the saved header in the very first lock block that 
        // the header points to
        POINTER_SIZE_INT saved_header = p_lock_chain->old_object_header & QUICK_HASH_MASK;
        saved_header |= p_lock_chain->p_orp_thread->quick_thread_index_shifted_left;
        assert(p_lock_chain->lock_recursion_count_shifted_left != 0);
        saved_header |= p_lock_chain->lock_recursion_count_shifted_left;
        saved_header |= BUSY_FORWARDING_BIT;

        POINTER_SIZE_INT new_header = SLOW_LOCKING | BUSY_FORWARDING_BIT;

        if (p_lock_chain->p_forward_link) {
            //_ D->E, D->F. F->F, F->E
            p_lock_chain->p_forward_link->old_object_header = saved_header;
            p_lock_chain->p_forward_link->p_object_header = p_header;
            new_header |= (POINTER_SIZE_INT)(p_lock_chain->p_forward_link); // & LOCK_BLOCK_POINTER_MASK;
            // NOTE: the next line does not turn off busy bit yet
            *p_header = new_header; ////////////////////////////////////////////////
            // insert at the very end of the list 
            Lock_Block *p_scan = p_lock_chain;
            while(p_scan->p_forward_link) {
                p_scan = p_scan->p_forward_link;
            }
            p_new_wait_block->p_back_link = p_scan;
            p_scan->p_forward_link = p_new_wait_block;

            // pull the waiting_for_the_lock>>>went to>>>holding_the_lock block out
            assert(p_lock_chain->p_back_link == 0);
            p_lock_chain->p_forward_link->p_back_link = 0;

            p_lock_chain->lock_or_wait_state = owning_thread_needs_to_call_free_routine;
            p_lock_chain->p_back_link = 0;
            p_lock_chain->p_forward_link = 0;
        }
        else { // p_lock_chain->p_forward_link == 0
            //_ D->E
            p_new_wait_block->old_object_header = saved_header;
            p_new_wait_block->p_object_header = p_header;
            new_header |= (POINTER_SIZE_INT)(p_new_wait_block); // & LOCK_BLOCK_POINTER_MASK;
            // NOTE: the next line does not turn off busy bit yet
            *p_header = new_header; ////////////////////////////////////////////////

            p_lock_chain->lock_or_wait_state = owning_thread_needs_to_call_free_routine;
            p_lock_chain->p_back_link = 0;
            p_lock_chain->p_forward_link = 0;
        }

        do_a_SetEvent = true;
        
        switch (p_lock_chain->p_orp_thread->app_status) {
        case thread_is_waiting:
            {
                event_handle_for_SetEvent = p_lock_chain->p_orp_thread->event_handle_interrupt; 
                break;
            }
        case thread_is_sleeping:
            {
                assert(0);	//  remove when hit and code path tested event_handle_for_SetEvent = p_lock_chain->p_orp_thread->event_handle_sleep; break;
            }
        case thread_is_running: 
        case thread_is_dying:
            {
                event_handle_for_SetEvent = p_lock_chain->p_orp_thread->event_handle_monitor; 
                break;
            }
        default:
            {
                assert(0);
                break;
            }
        }
        assert(p_lock_chain->lock_or_wait_state == owning_thread_needs_to_call_free_routine);

    }
    else if ( p_lock_chain->lock_or_wait_state == waiting_for_the_notify )
    {
        //_ E->C
        p_new_wait_block->lock_recursion_count_shifted_left = 
            p_lock_chain->old_object_header & QUICK_RECURSION_MASK;
        assert(p_new_wait_block->lock_recursion_count_shifted_left != 0);
        // leave recursion count at zero which indicates a wait for notify
        p_lock_chain->old_object_header &= QUICK_HASH_MASK;
        p_lock_chain->old_object_header |= 
                p_lock_chain->p_orp_thread->quick_thread_index_shifted_left;
        p_lock_chain->old_object_header |= BUSY_FORWARDING_BIT;

        if (p_lock_chain->p_forward_link)
            p_lock_chain->p_forward_link->p_back_link = p_new_wait_block;
        p_new_wait_block->p_forward_link = p_lock_chain->p_forward_link;
        p_lock_chain->p_forward_link = p_new_wait_block;
        p_new_wait_block->p_back_link = p_lock_chain;
    }
    else 
    {
        assert(0);
    }

#if USE_IA64_JIT
	// don't do anything for ia64 --memset(&(p_TLS_orpthread->gc_frame_context), 0, sizeof(p_TLS_orpthread->gc_frame_context) );
    // assert(0);
#else
	memset(&(p_TLS_orpthread->gc_frame_context), 0, sizeof(p_TLS_orpthread->gc_frame_context) );
	p_TLS_orpthread->gc_frame_context.ljf = (POINTER_SIZE_INT)p_TLS_orpthread->get_last_java_frame();
	p_TLS_orpthread->gc_frame_context.p_eip = &(p_TLS_orpthread->gc_frame_context_eip_var);
#endif 

    assert(p_orpthread->app_status == thread_is_running);
    p_orpthread->app_status = thread_is_waiting;

    assert(p_orpthread->which_trap == x_nothing);
    p_orpthread->which_trap = x_java_wait;

    assert( (p_orpthread->gc_status == zero) || 
            (p_orpthread->gc_status == gc_moving_to_safepoint) );
    p_orpthread->gc_status = gc_at_safepoint;

#ifdef _DEBUG
    queue_verifier(p_obj_volatile);
#endif

    DWORD stat;

    if (do_a_SetEvent) {
        assert(event_handle_for_SetEvent);
        assert(p_lock_chain->lock_or_wait_state == owning_thread_needs_to_call_free_routine);
        stat = SetEvent(event_handle_for_SetEvent);
        assert(stat);
    }
    
    // the following should never happen but to be safe...
    // the following reset flushes any _Thread_interrupt0()'s that happened while
    // the thread was not in a Thread_sleep() or _Object_wait() state.
    stat = ResetEvent(p_orpthread->event_handle_interrupt);
    assert(stat);
    p_orpthread->interrupt_a_waiting_thread = false;

    //turned off for now -->orp_monitor_singlethread();  // only goes single thread if there is one thread active


    RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////////

    // orp_enable_gc() may actually cause a GC.  If GC happens p_obj_volatile
    // could get moved.  This would cause the below to see a
    // stale reference to p_obj_volatile.  The fix is the following orp_push_gc_frame()
    GC_Frame gcf;
    orp_push_gc_frame(&gcf, (void *)&p_obj_volatile, sizeof(volatile void *));

    orp_enable_gc();

    active_thread_count --;

    p_thread_lock->_unlock_enum();

    DWORD wfso_status = 0;
    if (msec == 0)
    {
        wfso_status = WaitForSingleObject(p_orpthread->event_handle_interrupt, INFINITE);
        assert(wfso_status != WAIT_FAILED);
    }
    else
    {
        wfso_status = WaitForSingleObject(p_orpthread->event_handle_interrupt,
                                                                (uint32)msec); 
        assert(wfso_status != WAIT_FAILED);
    }

    // there are only three way to get to this point in the code:
    // 1) msec != 0 and the wait timed out
    // 2) an _Object_notify()/notifyAll() happened
    // 3) a _Thread_interrupt0() happened

    // case two is the only case where the event has already put the Lock_Block in
    // the correct state,  The other two cases are fixed up by interrupt_the_wait()

    p_thread_lock->_lock_enum();

    DWORD wstat = 0;

    while (p_TLS_orpthread->thread_is_java_suspended)  {

        p_thread_lock->_unlock_enum();
        wstat = WaitForSingleObject(p_TLS_orpthread->event_handle_suspend0, INFINITE);
        assert(wstat != WAIT_FAILED);
        p_thread_lock->_lock_enum();
    }

    assert (p_TLS_orpthread->thread_is_java_suspended == false);

    orp_disable_gc();

    orp_pop_gc_frame(&gcf);

    // the following should never happen but to be safe...
    // the following reset flushes any _Thread_interrupt0()'s that happened while
    // the thread was dealing with the very first interrupt
    stat = ResetEvent(p_orpthread->event_handle_interrupt);
    assert(stat);
    bool old_interrupt = p_orpthread->interrupt_a_waiting_thread;
    p_orpthread->interrupt_a_waiting_thread = false;

    lock_or_wait  interrupt_the_wait(ORP_thread * p_orpthread, 
                                     DWORD wfso_status,    
                                     Lock_Block *p_new_wait_block);

    lock_or_wait lw = interrupt_the_wait(p_orpthread, wfso_status, p_new_wait_block);

    // turned off for now --> orp_monitor_multithread();
    active_thread_count ++;

    p_thread_lock->_unlock_enum();

    assert (    (lw == holding_the_lock)        ||
                (lw == waiting_for_the_lock)    ||
                (lw == owning_thread_needs_to_call_free_routine )  );

    if (lw == waiting_for_the_lock)
    {
            orp_enable_gc();
            DWORD wstat = WaitForSingleObject(p_orpthread->event_handle_monitor, INFINITE);
            assert(wstat != WAIT_FAILED);
            orp_disable_gc();
    }

#ifdef _DEBUG
    // BUGBUG -- need to grab the busy bit first--> queue_verifier(p_obj);
    assert(p_orpthread->p_latest_wait_lock_block == p_new_wait_block);

    assert( (p_new_wait_block->lock_or_wait_state == 
                owning_thread_needs_to_call_free_routine)  ||
            (p_new_wait_block->lock_or_wait_state == 
                holding_the_lock)  );
    p_orpthread->p_latest_wait_lock_block = 0;
#endif

    if ( p_new_wait_block->lock_or_wait_state == 
            owning_thread_needs_to_call_free_routine )
        free_this_block(p_orpthread, p_new_wait_block);
    else assert(p_new_wait_block->lock_or_wait_state == holding_the_lock);

    p_orpthread->p_current_object = 0;

    if (old_interrupt) {
        // BUGBUG -- theorptically the following var should only be set while holding thread_CriticalSection
        p_orpthread->interrupt_a_waiting_thread = false;
        throw_java_exception("java/lang/InterruptedException");
    }
}


lock_or_wait interrupt_the_wait(ORP_thread *p_target_thread, 
                                DWORD wfso_status,
                                Lock_Block *p_new_wait_block)
{
    Lock_Block *p_lock_chain;
    
    volatile POINTER_SIZE_INT *p_header = P_OBJ_INFO(p_target_thread->p_current_object);

    assert(p_header);

    ACQUIRE_BUSY_BIT(p_header);

    if (p_target_thread->app_status == thread_is_waiting) 
    {
        // The wait was either timed out or the object was signaled by a notify.
        assert((wfso_status == WAIT_TIMEOUT) || (wfso_status == WAIT_OBJECT_0));
        p_target_thread->app_status = thread_is_running;

        assert(p_target_thread->which_trap == x_java_wait);
        p_target_thread->which_trap = x_nothing;

        assert(p_target_thread->gc_status == gc_at_safepoint);
        p_target_thread->gc_status = zero;       
    }

    assert(quick_thread_id[p_target_thread->quick_thread_index].p_orpthread);
    assert(p_target_thread->p_latest_wait_lock_block == p_new_wait_block);

    assert(p_target_thread->app_status == thread_is_running);

    assert(p_target_thread->which_trap == x_nothing);

    assert(p_target_thread->gc_status == zero);

#ifdef _DEBUG
    queue_verifier(p_target_thread->p_current_object);
#endif

    if (   ((*p_header & QUICK_RECURSION_MASK) != 0) &&
           ((*p_header & QUICK_RECURSION_MASK) != SLOW_LOCKING)  )
        if ((*p_header & QUICK_THREAD_INDEX_MASK) == 
            p_target_thread->quick_thread_index_shifted_left)  {

            // target thread holds the lock... thus do nothing
            RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////
            return (holding_the_lock);
        }

    assert( (*p_header &  QUICK_RECURSION_MASK) == SLOW_LOCKING);
    p_lock_chain =(Lock_Block *)(*p_header & LOCK_BLOCK_POINTER_MASK);

    if (  ((p_lock_chain->old_object_header & QUICK_THREAD_INDEX_MASK) == 
                    p_target_thread->quick_thread_index_shifted_left )      &&
          ((p_lock_chain->old_object_header & QUICK_RECURSION_MASK) != 0 )   )      
    {
        // target thread holds the lock... thus do nothing
        RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////
        return (holding_the_lock);
    }

    if (  (p_lock_chain->p_orp_thread->quick_thread_index_shifted_left & 
                        QUICK_THREAD_INDEX_MASK) == 
                            p_target_thread->quick_thread_index_shifted_left )
    {
        //_ C->B
        // the very first std full-size lock block is actually the target thread

        if (p_lock_chain->lock_or_wait_state == waiting_for_the_lock) {
#ifdef _DEBUG
            queue_verifier(p_target_thread->p_current_object);
#endif
            RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////////

            return(waiting_for_the_lock);
        }

        if (p_lock_chain->old_object_header & QUICK_RECURSION_MASK) {

            //assert(0);  // is this code EVER executed??  -- yes it is
            //orp_cout << " is this code EVER executed?? --> in interrupt_the_wait()" << endl;
            assert( (p_lock_chain->old_object_header & QUICK_THREAD_INDEX_MASK) !=
                    (p_lock_chain->p_orp_thread->quick_thread_index_shifted_left)  );
            p_lock_chain->lock_or_wait_state = waiting_for_the_lock;
#ifdef _DEBUG
            queue_verifier(p_target_thread->p_current_object);
#endif
            RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////////

            return(waiting_for_the_lock);
        }

        {
            // target thread now grabs the lock
            POINTER_SIZE_INT new_header;
            assert(p_lock_chain->lock_or_wait_state == waiting_for_the_notify);

            if (p_lock_chain->lock_recursion_count_shifted_left > 
                                    QUICK_RECURSION_ABOUT_TO_OVERFLOW)
            {
                // don't free this lock block since it holds the deep recursion count
                // just set it to holding the lock
                assert( (p_lock_chain->old_object_header & QUICK_RECURSION_MASK) == SLOW_LOCKING);
                assert( (p_lock_chain->old_object_header & QUICK_THREAD_INDEX_MASK) ==
                                        p_lock_chain->p_orp_thread->quick_thread_index_shifted_left);
                p_lock_chain->lock_or_wait_state = holding_the_lock;
#ifdef _DEBUG
                queue_verifier(p_target_thread->p_current_object);
#endif
                RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////

                return (holding_the_lock);
            }

            p_lock_chain->lock_or_wait_state = 
                                        owning_thread_needs_to_call_free_routine;
            if (p_lock_chain->p_forward_link == 0) {
                new_header = p_lock_chain->old_object_header;
                 assert( (new_header & QUICK_RECURSION_MASK) == 0);
                assert(p_lock_chain->lock_recursion_count_shifted_left != 0);
                new_header |= p_lock_chain->lock_recursion_count_shifted_left;
                new_header |= BUSY_FORWARDING_BIT;
                assert( (new_header & QUICK_THREAD_INDEX_MASK) == 
                        p_target_thread->quick_thread_index_shifted_left); 

                // NOTE: the line below does not turn off busy bit yet
                *p_header = new_header; ////////////////////////////////////////////
            }
            else {
                new_header = SLOW_LOCKING | BUSY_FORWARDING_BIT;
                new_header |= ( (POINTER_SIZE_INT)p_lock_chain->p_forward_link) & 
                                        LOCK_BLOCK_POINTER_MASK;

                assert((new_header & BUSY_FORWARDING_BIT) == BUSY_FORWARDING_BIT);
                // NOTE: the line below does not turn off busy bit yet
                *p_header = new_header; ////////////////////////////////////////////  

                p_lock_chain->p_forward_link->old_object_header =
                    p_lock_chain->old_object_header & 
                        ~( QUICK_THREAD_INDEX_MASK | QUICK_RECURSION_MASK );
                p_lock_chain->p_forward_link->old_object_header |=
                    p_lock_chain->p_orp_thread->quick_thread_index_shifted_left;
                assert(p_lock_chain->lock_recursion_count_shifted_left != 0);
                p_lock_chain->p_forward_link->old_object_header |=
                    p_lock_chain->lock_recursion_count_shifted_left;
                p_lock_chain->p_forward_link->p_back_link = 0;
            }   
        }

#ifdef _DEBUG
        queue_verifier(p_target_thread->p_current_object);
#endif
        RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////////

        return(owning_thread_needs_to_call_free_routine);
    }

    while(1) {  // find the lock_block (its not the very first element on list
        if (p_lock_chain->p_orp_thread == p_target_thread) break;

        p_lock_chain = p_lock_chain->p_forward_link;

        if (p_lock_chain == 0) break;
    }
    // because p_target_thread->lock_or_wait_state == thread_is_waiting,
    // the following must be true:
    assert(p_lock_chain->p_orp_thread == p_target_thread);
    assert(p_lock_chain->lock_or_wait_state == waiting_for_the_notify);
    p_lock_chain->lock_or_wait_state = waiting_for_the_lock;
    assert((*p_header & BUSY_FORWARDING_BIT) == BUSY_FORWARDING_BIT);

    assert(p_lock_chain->lock_recursion_count_shifted_left != 0);

    // pull the lock_block out of the list
    if (p_lock_chain->p_back_link)
        p_lock_chain->p_back_link->p_forward_link = p_lock_chain->p_forward_link;
                                                                                                                                                                                                                                                                                                                                                     if (p_lock_chain->p_forward_link)
    p_lock_chain->p_forward_link->p_back_link = p_lock_chain->p_back_link;

#ifdef _DEBUG
    p_lock_chain->p_forward_link = 0;
    p_lock_chain->p_back_link = 0;
#endif

    // now reinsert
    Lock_Block *p_reinsert = p_lock_chain;

    Lock_Block *p_scan = (Lock_Block *)(*p_header & LOCK_BLOCK_POINTER_MASK);

    if (p_scan->lock_or_wait_state == waiting_for_the_notify) {

        //_ C->B
        // we grab the lock
        p_lock_chain->lock_or_wait_state = holding_the_lock;

        if (p_lock_chain->lock_recursion_count_shifted_left > 
                                QUICK_RECURSION_ABOUT_TO_OVERFLOW)
        {
            // don't free this lock block since it holds the deep recursion count
            // just set it to holding the lock
            assert( (p_lock_chain->old_object_header & QUICK_RECURSION_MASK) == SLOW_LOCKING);
            assert( (p_lock_chain->old_object_header & QUICK_THREAD_INDEX_MASK) ==
                                    p_lock_chain->p_orp_thread->quick_thread_index_shifted_left);
            p_lock_chain->p_forward_link = p_scan;
            if (p_scan->p_forward_link)
                p_scan->p_forward_link->p_back_link = p_lock_chain;
#ifdef _DEBUG
            queue_verifier(p_target_thread->p_current_object);
#endif
            RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////

            return (holding_the_lock);
        }

        p_scan->old_object_header = p_scan->old_object_header & QUICK_HASH_MASK;
        p_scan->old_object_header |= p_reinsert->lock_recursion_count_shifted_left;
        p_scan->old_object_header |= p_reinsert->p_orp_thread->quick_thread_index_shifted_left;
        
#ifdef _DEBUG
        queue_verifier(p_target_thread->p_current_object);
#endif
        RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////////
        return (owning_thread_needs_to_call_free_routine);
    }

    assert(p_scan->lock_or_wait_state == holding_the_lock);
    while(p_scan->p_forward_link) {
        if (p_scan->p_forward_link->lock_or_wait_state ==
                    waiting_for_the_notify) break;
        p_scan = p_scan->p_forward_link;
    }
    p_reinsert->p_forward_link = p_scan->p_forward_link;
    p_reinsert->p_back_link = p_scan->p_back_link;

    //_ E->D, F->D
    if (p_scan->p_forward_link)
        p_scan->p_forward_link->p_back_link = p_reinsert;
    if (p_scan->p_back_link)
        p_scan->p_back_link->p_forward_link = p_reinsert;

#ifdef _DEBUG
    queue_verifier(p_target_thread->p_current_object);
#endif
        
    RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////////

    return (waiting_for_the_lock);
}


long generic_hashcode(Java_java_lang_Object * p_obj)
{
#ifdef GC_SAPPRHIE
    assert(0); // needs to adjust from "from" space to "to" space
#endif
    ORP_thread *p_orpthread = p_TLS_orpthread;    

#ifdef _DEBUG
    p_orpthread->number_of_hashCode++;
#endif

    Lock_Block *p_lock_chain;
    volatile POINTER_SIZE_INT *p_header = P_OBJ_INFO(p_obj);

    ACQUIRE_BUSY_BIT(p_header);

    uint32 object_hash;

    if ( (*p_header & SLOW_LOCKING) == SLOW_LOCKING ) {
        p_lock_chain = (Lock_Block *)(*p_header & LOCK_BLOCK_POINTER_MASK);
        object_hash = (p_lock_chain->old_object_header) & QUICK_HASH_MASK;
    }
    else object_hash = *p_header & QUICK_HASH_MASK;

    if (object_hash) {
        RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////
        return (long)object_hash;
    }
    
    // A hash value of zero is reserved and indicates that the hash field has
    // not been initialized.  Thus we initialize the hash field below  

    quick_hash_counter++;

    object_hash = (uint32)p_obj;

/*
    // lowest 3 bits are not random enough so get rid of them
    object_hash = object_hash >> 3;

    object_hash = object_hash << QUICK_HASH_LEFT_SHIFT_COUNT;
    // make certain no bits outside the hash field
    object_hash &= QUICK_HASH_MASK;  
*/
    uint32 backup = object_hash; //save it first
    // lowest 3 bits are not random enough so get rid of them
    object_hash = object_hash >> 3;

    object_hash = object_hash << QUICK_HASH_LEFT_SHIFT_COUNT;
    // Just a little fix here to make sure object_hash won't be 0
    // if it's 0, next time calls hashCode() will think the object hasn't 
    // got hashcode, and regenerate according to its current address (may
    // be changed for gc). Then the object will have different hashcode
    // during its life cycle.
	if(!object_hash)
		object_hash = backup << QUICK_HASH_LEFT_SHIFT_COUNT; 

    // make certain no bits outside the hash field
    object_hash &= QUICK_HASH_MASK;  

    if ( (*p_header & SLOW_LOCKING) == SLOW_LOCKING ) {
        p_lock_chain = (Lock_Block *)(*p_header & LOCK_BLOCK_POINTER_MASK);
        p_lock_chain->old_object_header |= object_hash;
    }
    else
        *p_header |= object_hash;

    RELEASE_BUSY_BIT(p_header); //////////////////////////////////////////////////////////

    return (long)object_hash;
        
} //generic_hashcode



///////////////////////////////////////////////////////////////////////////////
///////////////
/////////////// WARNING: end_of_object_busybit_critical_zone() MUST BE  THE LAST
///////////////
/////////////// PROCEDURE IN java_lang_Object.cpp
///////////////
///////////////////////////////////////////////////////////////////////////////

void end_of_object_gerneric_busybit_critical_zone()
{
////////////// THIS MUST BE THE LAST PROCEDURE IN java_lang_Object.cpp
////////////// SEE in_busybit_critical_zone() for details
}
#endif //#ifndef  OBJECT_LOCK_V2

 
