// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/handles.cpp,v 1.2 2001/08/13 09:54:55 xhshi Exp $
//


#include <string.h>
#include "defines.h"
#include "handles.h"

Class_Handle cached_class_handles[n_cached_class_handles];
Method_Handle cached_method_handles[n_cached_method_handles];

//
// Initialize method and class handles when we JIT the first method.
//
void init_handles(Class_Handle class_handle_of_class_loader)
{
#ifdef _DEBUG
    static bool need_to_init = true;
    assert(need_to_init);
    memset(cached_class_handles, 0, n_cached_class_handles * sizeof(*cached_class_handles));
    memset(cached_method_handles, 0, n_cached_method_handles * sizeof(*cached_method_handles));
#endif // _DEBUG

    Loader_Exception lexc;

    cached_class_handles[ch_java_lang_Object] =
        class_load_class_by_name("java/lang/Object", class_handle_of_class_loader, &lexc);
    cached_class_handles[ch_java_lang_String] =
        class_load_class_by_name("java/lang/String", class_handle_of_class_loader, &lexc);
    cached_class_handles[ch_java_lang_Math] =
        class_load_class_by_name("java/lang/Math", class_handle_of_class_loader, &lexc);
    cached_class_handles[ch_java_lang_NullPointerException] =
        class_load_class_by_name("java/lang/NullPointerException", class_handle_of_class_loader, &lexc);
    cached_class_handles[ch_java_lang_Throwable] =
        class_load_class_by_name("java/lang/Throwable", class_handle_of_class_loader, &lexc);

    cached_method_handles[mh_java_lang_Math_sin] = class_lookup_method_recursively(
        cached_class_handles[ch_java_lang_Math], "sin", "(D)D");
    cached_method_handles[mh_java_lang_Math_cos] = class_lookup_method_recursively(
        cached_class_handles[ch_java_lang_Math], "cos", "(D)D");
    cached_method_handles[mh_java_lang_Math_sqrt] = class_lookup_method_recursively(
        cached_class_handles[ch_java_lang_Math], "sqrt", "(D)D");
    cached_method_handles[mh_java_lang_Math_rint] = class_lookup_method_recursively(
        cached_class_handles[ch_java_lang_Math], "rint", "(D)D");
    cached_method_handles[mh_java_lang_Math_abs__1] = class_lookup_method_recursively(
        cached_class_handles[ch_java_lang_Math], "abs", "(D)D");
    cached_method_handles[mh_java_lang_Math_abs__2] = class_lookup_method_recursively(
        cached_class_handles[ch_java_lang_Math], "abs", "(F)F");
    cached_method_handles[mh_java_lang_String_compareTo] = class_lookup_method_recursively(
        cached_class_handles[ch_java_lang_String], "compareTo", "(Ljava/lang/String;)I");
    cached_method_handles[mh_java_lang_String_equals] = class_lookup_method_recursively(
        cached_class_handles[ch_java_lang_String], "equals", "(Ljava/lang/Object;)Z");
    cached_method_handles[mh_java_lang_String_indexOf__1] = class_lookup_method_recursively(
        cached_class_handles[ch_java_lang_String], "indexOf", "(I)I");
    cached_method_handles[mh_java_lang_String_indexOf__2] = class_lookup_method_recursively(
        cached_class_handles[ch_java_lang_String], "indexOf", "(II)I");
    cached_method_handles[mh_java_lang_String_indexOf__3] = class_lookup_method_recursively(
        cached_class_handles[ch_java_lang_String], "indexOf", "(Ljava/lang/String;)I");
    cached_method_handles[mh_java_lang_String_indexOf__4] = class_lookup_method_recursively(
        cached_class_handles[ch_java_lang_String], "indexOf", "(Ljava/lang/String;I)I");

#ifdef _DEBUG
    unsigned i;
    for (i=0; i<n_cached_class_handles; i++)
        assert(cached_class_handles[i]);
    for (i=0; i<n_cached_method_handles; i++)
        assert(cached_method_handles[i]);
    need_to_init = false;
#endif // _DEBUG
}
