// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/build_ir.cpp,v 1.3 2001/08/14 08:18:33 zying1 Exp $
//


#include "defines.h"
#include <iostream.h>
#include "Mem_Manager.h"
#include "ir.h"
#include "stack.h"
#include "expression.h"
#include "build_ir_routines.h"
#include "flow_graph.h"
#include "local_cse.h"
#include "jit_types.h"
#include "jit_common.h"

#ifdef O3_VTune_Support
extern FILE* fp_vtune_debug;
#endif

#ifdef PRINTABLE_O3
static void update_ir_bc_mappings(Inst *inst_head, Inst *&last_bc_inst, unsigned bc_index)
{
    if (bc_index == NO_BC_IDX)
        return;
    if (last_bc_inst != inst_head->prev()) // new inst has generated
    {
        Inst *first_stmt_inst = last_bc_inst->next();
        Inst *last_stmt_inst = inst_head;
        for (; first_stmt_inst != last_stmt_inst; first_stmt_inst = first_stmt_inst->next())
        {
            first_stmt_inst->bc_index = bc_index;
        }
        last_bc_inst = inst_head->prev();
    }
}
#endif // PRINTABLE_O3

Inst *ir_make_epilog(Expressions &exprs, Cfg_Node *node, Mem_Manager &mem_manager)
{
    Inst_Exp *ret = exprs.lookup_inst_exp(Exp::Return,NULL,NULL,JIT_TYPE_VOID);
    return new (mem_manager) Return_Inst(ret,node->IR_instruction_list());
}

void build_IR(
	Compile_Handle   compilationHandle,
    Class_Handle  class_handle,
    Method_Handle method_handle,
    bool          gc_requires_write_barriers,
	Mem_Manager&  mem_manager,
	Expressions&  exprs,
	Stack&        stack,  // mimic stack
	Inst          *inst_head,
    const unsigned char	*first_bc,		// first bytecode of method
    Cfg_Node      *node,  // current BB
    char *stack_sig_in,   // stack type signature of previous BB
    int stack_sig_in_size,
    char *stack_sig_out,  // stack type signature of current BB
    int &stack_sig_out_size,
    int &ends_in_return,
    int is_exception_entry,
    int is_extended_bb) {

    unsigned index; // index of constant pools or variables
	Inst *src; // source inst
    O3_Jit_Type type;
    Value val;
    Exp::Kind op;

    ends_in_return = 0;

	const char *method_name = method_get_name(method_handle);
	const char *class_name = class_get_name(class_handle);

#ifdef O3_VTune_Support1
		if ( strcmp( method_name, "main") == 0)
		{
			int xx = 0;
		}
		
		if ( !fp_vtune_debug)
			fp_vtune_debug = fopen( "vtune_debug.txt", "w+");
		
		fprintf( fp_vtune_debug, "method_name: %s\nclass_name: %s\n", method_name, class_name);
		fflush( fp_vtune_debug);
#endif

#ifdef PRINTABLE_O3
    Inst *last_bb_inst = inst_head->prev();
    Inst *last_bc_inst = last_bb_inst;
#endif // PRINTABLE_O3

    if (is_exception_entry) {
      //
      // On the entry of exception handler, the stack contains only
      // one exception object.
      //
        assert(stack_sig_in_size == 1);
        stack_sig_in[0] = JIT_TYPE_CLASS;
    }
	//
	// init mimic stack at the entry of block
	//
    stack.reset();
    int i;
	for (i=0; i < stack_sig_in_size; i++)
    {
        Inst *ii;
        if (is_exception_entry)
            ii = exprs.lookup_preg(eax_reg, JIT_TYPE_CLASS, inst_head);
        else
            ii = exprs.lookup_stack(stack.depth(),(O3_Jit_Type)stack_sig_in[i],inst_head);
		stack.push(ii);
    }

    const unsigned char *bc = first_bc + node->first_bc_idx();
	const unsigned char *last_bc = bc + node->bc_length(); // last bytecode
    const unsigned char *prev_bc;
	const unsigned char *curr_bc = bc;	// ptr to current bytecode
    unsigned bc_index = bc - first_bc;
    stack_sig_out_size = -1;  // so that we can tell if last stmt is fall-through
	while (bc < last_bc) {
        prev_bc = curr_bc;
		curr_bc = bc;
		bc_index = curr_bc-first_bc; // offset of current bytecode
		unsigned char bytecode = *bc;	// value of current bytecode

		switch (bytecode) {
		case 0x00:	break;		// nop
		case 0x01:			// aconst_null
            src = exprs.lookup_imm(0,JIT_TYPE_CLASS,inst_head);
            stack.push(src);
			break;
		case 0x02: case 0x03: case 0x04: case 0x05:
		case 0x06: case 0x07: case 0x08:
			// iconst -1,0,...,5
            src = exprs.lookup_imm(bytecode-0x03,JIT_TYPE_INT,inst_head);
			stack.push(src);
			break;
		case 0x09: case 0x0a:
			// lconst 0,1
			val.l.hi = 0; val.l.lo = bytecode-0x09;
			stack.push(exprs.lookup_const(&val,JIT_TYPE_LONG,inst_head));
			break;
		case 0x0b:	// fconst 0.0F
            val.f = 0.0f;
			stack.push(exprs.lookup_const(&val,JIT_TYPE_FLOAT,inst_head));
			break;
		case 0x0c:	// fconst 1.0F
            val.f = 1.0f;
			stack.push(exprs.lookup_const(&val,JIT_TYPE_FLOAT,inst_head));
			break;
		case 0x0d:	// fconst 2.0F
            val.f = 2.0f;
			stack.push(exprs.lookup_const(&val,JIT_TYPE_FLOAT,inst_head));
			break;
		case 0x0e:	// dconst 0.0
            val.d = 0.0;
			stack.push(exprs.lookup_const(&val,JIT_TYPE_DOUBLE,inst_head));
			break;
		case 0x0f:	// dconst 1.0
            val.d = 1.0;
			stack.push(exprs.lookup_const(&val,JIT_TYPE_DOUBLE,inst_head));
			break;
		case 0x10: 		// bipush
			stack.push(exprs.lookup_imm((int)(((const char *)bc)[1]),JIT_TYPE_INT,inst_head));
			break;
		case 0x11:		// sipush
			stack.push(exprs.lookup_imm((((const char *)bc)[1] << 8) + bc[2],JIT_TYPE_INT,inst_head));
 			break;
		case 0x12:		// ldc
            gen_const(mem_manager,exprs,stack,inst_head,compilationHandle,class_handle,bc[1]);
			break;
		case 0x13:		// ldc_w
		case 0x14:		// ldc2_w
			index = (bc[1] << 8) + bc[2];
            gen_const(mem_manager,exprs,stack,inst_head,compilationHandle,class_handle,index);
			break;
		case 0x15:	// iload
		case 0x16:  // lload
		case 0x17:	// fload
		case 0x18:  // dload
		case 0x19:	// aload
            type = (O3_Jit_Type)("IJFDL"[bytecode-0x15]);
			stack.push(exprs.lookup_vreg(bc[1],type,inst_head));
			break;
		case 0x1a: case 0x1b: case 0x1c: case 0x1d:	// iload_{0,1,2,3}
            index = bytecode-0x1a;
			stack.push(exprs.lookup_vreg(index,JIT_TYPE_INT,inst_head));
			break;
		case 0x22: case 0x23: case 0x24: case 0x25:	// fload_{0,1,2,3}
            index = bytecode-0x22;
			stack.push(exprs.lookup_vreg(index,JIT_TYPE_FLOAT,inst_head));
			break;
		case 0x2a: case 0x2b: case 0x2c: case 0x2d:	// aload_{0,1,2,3}
            index = (bytecode-0x2a);
			stack.push(exprs.lookup_vreg(index,JIT_TYPE_CLASS,inst_head));
			break;
		case 0x1e: case 0x1f: case 0x20: case 0x21:	// lload_{0,1,2,3}
			index = bytecode-0x1e;
			stack.push(exprs.lookup_vreg(index,JIT_TYPE_LONG,inst_head));
			break;
		case 0x26: case 0x27: case 0x28: case 0x29:	// dload_{0,1,2,3}
			index = bytecode-0x26;
			stack.push(exprs.lookup_vreg(index,JIT_TYPE_DOUBLE,inst_head));
			break;
		case 0x2e:	// iaload
		case 0x2f:	// laload
		case 0x30:	// faload
		case 0x31:	// daload
		case 0x32:	// aaload
		case 0x33:	// baload
  		case 0x34:	// caload
 		case 0x35:	// saload
            {
                Inst *i = inst_head->prev(); // prev inst
                bool reorder = false;
                if (i != inst_head && i != stack.ith_elem(0) && i->is_iinc() &&
                    node->eh_out_edge() == NULL) { // no exception handler
                    i->unlink();
                    reorder = true;
                }
#if 0
                if (bytecode == 0x35 && bc[1] == 0x10 && bc[2] == 0x10 &&
                    bc[3] == 0x78 && bc[4] == 16 && bc[5] == 16 &&
                    bc[6] == 0x7c)
                {
                    bytecode = 0x34;
                    bc_index += 6;
                    bc += 6;
                }
#endif
			    array_load(mem_manager,exprs,stack,inst_head,"IJFDLBCS"[bytecode - 0x2e]);
                if (reorder)
                    i->insert_before(inst_head); // append to the end of the list
            }
            break;
		case 0x36:	// istore
		case 0x37:	// lstore
		case 0x38:	// fstore
		case 0x39:	// dstore
		case 0x3a:	// astore
            type = (O3_Jit_Type)("IJFDL"[bytecode-0x36]);
			gen_assign(mem_manager,exprs,stack,inst_head,bc[1],stack.pop(),type);
			break;
		case 0x4b: case 0x4c: case 0x4d: case 0x4e:	// astore_{0,1,2,3}
            index = (bytecode-0x4b);
			gen_assign(mem_manager,exprs,stack,inst_head,index,stack.pop(),JIT_TYPE_CLASS);
			break;
		case 0x3b: case 0x3c: case 0x3d: case 0x3e:	// istore_{0,1,2,3}
            index = bytecode-0x3b;
			gen_assign(mem_manager,exprs,stack,inst_head,index,stack.pop(),JIT_TYPE_INT);
			break;
		case 0x43: case 0x44: case 0x45: case 0x46: // fstore_{0,1,2,3}
            index = bytecode-0x43;
			gen_assign(mem_manager,exprs,stack,inst_head,index,stack.pop(),JIT_TYPE_FLOAT);
			break;
		case 0x3f: case 0x40: case 0x41: case 0x42: // lstore_{0,1,2,3}
			index = (bytecode-0x3f)&0x03;
			gen_assign(mem_manager,exprs,stack,inst_head,index,stack.pop(),JIT_TYPE_LONG);
			break;
		case 0x47: case 0x48: case 0x49: case 0x4a:	// dstore_{0,1,2,3}
			index = (bytecode-0x47)&0x03;
			gen_assign(mem_manager,exprs,stack,inst_head,index,stack.pop(),JIT_TYPE_DOUBLE);
			break;
		case 0x4f:	// iastore
		case 0x50:	// lastore
		case 0x51:	// fastore
		case 0x52:	// dastore
		case 0x53:	// aastore
 		case 0x54:	// bastore
		case 0x55:	// castore
 		case 0x56:	// sastore
			array_store(mem_manager,exprs, stack,inst_head,"IJFDLBCS"[bytecode - 0x4f]);
            break;
		case 0x57:	// pop
			stack.pop();
			break;
		case 0x58:	// pop2
            src = stack.pop();
            if (!src->is_64bit()) stack.pop();
			break;
		case 0x59: // dup
			gen_dup(mem_manager,exprs,stack,inst_head);
			break;
		case 0x5a:	// dup_x1
			gen_dup_x1(mem_manager,exprs,stack,inst_head);
			break;
		case 0x5b: 	// dup_x2
			gen_dup_x2(mem_manager,exprs,stack,inst_head);
			break;
		case 0x5c:	// dup2
			gen_dup2(mem_manager,exprs,stack,inst_head);
			break;
		case 0x5d:	// dup2_x1
			gen_dup2_x1(mem_manager,exprs,stack,inst_head);
			break;
		case 0x5e:	// dup2_x2
			gen_dup2_x2(mem_manager,exprs,stack,inst_head);
			break;
		case 0x5f:  // swap
            { // swap top two operands (both must be 32-bit value)
                Inst *word1 = stack.pop();
                Inst *word2 = stack.pop();
                stack.push(word1);
                stack.push(word2);
            }
			break;
		case 0x60:	// iadd
		case 0x61:	// ladd
            gen_alu(mem_manager,exprs,stack,inst_head,Exp::Add,"IJ"[bytecode - 0x60]);
			break;
		case 0x62:	// fadd
		case 0x63:	// dadd
            gen_alu(mem_manager,exprs,stack,inst_head,Exp::Fadd,"FD"[bytecode - 0x62]);
			break;

		case 0x64:	// isub
		case 0x65:	// lsub
            gen_alu(mem_manager,exprs,stack,inst_head,Exp::Sub,"IJ"[bytecode - 0x64]);
			break;
		case 0x66:	// fsub
		case 0x67:	// dsub
			gen_alu(mem_manager,exprs,stack,inst_head,Exp::Fsub,"FD"[bytecode - 0x66]);
			break;
		case 0x68:	// imul
		case 0x69:	// lmul
			gen_alu(mem_manager,exprs,stack,inst_head,Exp::Mul,"IJ"[bytecode - 0x68]);
			break;
		case 0x6a:	// fmul
		case 0x6b:	// dmul
			gen_alu(mem_manager,exprs,stack,inst_head,Exp::Fmul,"FD"[bytecode - 0x6a]);
			break;
		case 0x6c:	// idiv
		case 0x6d:	// ldiv --- get quotient
			gen_alu(mem_manager,exprs,stack,inst_head,Exp::Div,"IJ"[bytecode - 0x6c]); 
			break;
		case 0x6e:	// fdiv
		case 0x6f:	// ddiv
			gen_alu(mem_manager,exprs,stack,inst_head,Exp::Fdiv,"FD"[bytecode - 0x6e]);
			break;
		case 0x70:	// irem
		case 0x71:	// lrem --- get remainder
			gen_alu(mem_manager,exprs,stack,inst_head,Exp::Rem,"IJ"[bytecode - 0x70]); 
			break;
		case 0x72:	// frem
		case 0x73:	// drem
			gen_alu(mem_manager,exprs,stack,inst_head,Exp::Frem,"FD"[bytecode - 0x72]);
			break;
		case 0x74:	// ineg
		case 0x75:	// lneg
			gen_alu1(mem_manager,exprs,stack,inst_head,Exp::Neg);
			break;
		case 0x76:	// fneg
		case 0x77:	// dneg
			gen_alu1(mem_manager,exprs,stack,inst_head,Exp::Fneg);
			break;
		case 0x78: // ishl
		case 0x79: // lshl
			gen_alu(mem_manager,exprs,stack,inst_head,Exp::Shl,"IJ"[bytecode - 0x78]);
			break;
		case 0x7a: // ishr
		case 0x7b: // lshr
			gen_alu(mem_manager,exprs,stack,inst_head,Exp::Sar,"IJ"[bytecode - 0x7a]);
			break;
		case 0x7c: // iushr
		case 0x7d:	// lushr
			gen_alu(mem_manager,exprs,stack,inst_head,Exp::Shr,"IJ"[bytecode - 0x7c]);
			break;
		case 0x7e:	// iand
		case 0x7f:	// land
            gen_alu(mem_manager,exprs,stack,inst_head,Exp::And,"IJ"[bytecode - 0x7e]);
			break;
		case 0x80:	// ior
		case 0x81:	// lor
            gen_alu(mem_manager,exprs,stack,inst_head,Exp::Or,"IJ"[bytecode - 0x80]);
			break;
		case 0x82:	// ixor
		case 0x83:	// lxor
            gen_alu(mem_manager,exprs,stack,inst_head,Exp::Xor,"IJ"[bytecode - 0x82]);
			break;
		case 0x84:  // iinc
			gen_iinc(mem_manager,exprs,stack,inst_head,bc[1],(int)(((const char *)bc)[2]));
			break;
		case 0x85:	// i2l
		case 0x86:	// i2f
		case 0x87:	// i2d
		case 0x88:	// l2i
		case 0x89:	// l2f
		case 0x8a:	// l2d
		case 0x8b:	// f2i
		case 0x8c:	// f2l
		case 0x8d:	// f2d
		case 0x8e:	// d2i
		case 0x8f:	// d2l
		case 0x90:	// d2f
		case 0x91:	// i2b
		case 0x92:	// i2c
		case 0x93:	// i2s
        {
            O3_Jit_Type conv_fm = (O3_Jit_Type)("IIIJJJFFFDDDIII"[bytecode-0x85]);
            O3_Jit_Type conv_to = (O3_Jit_Type)("JFDIFDIJDIJFBCS"[bytecode-0x85]);
            gen_conversion(mem_manager,exprs,stack,inst_head,conv_to,conv_fm);
			break;
        }
		case 0x94:	// lcmp
		case 0x95:  // fcmpl
		case 0x96:	// fcmpg
		case 0x97:	// dcmpl
		case 0x98:  // dcmpg
		{
			unsigned char next_bc = *(bc+1);
			assert(next_bc == 0x99 /* ifeq */ || next_bc == 0x9a /* ifne */ ||
				   next_bc == 0x9b /* iflt */ || next_bc == 0x9c /* ifge */ ||
				   next_bc == 0x9d /* ifgt */ || next_bc == 0x9e /* ifle */ );
		}
            break;
        case 0x99: case 0x9a: // if{eq,ne,lt,ge,gt,le}
		case 0x9b: case 0x9c: 
		case 0x9d: case 0x9e: 
			op = (Exp::Kind)(Exp::Beq + (bytecode - 0x99));
            if (*prev_bc >= 0x94 && *prev_bc <= 0x98) {
                O3_Jit_Type ty = (O3_Jit_Type)("JFFDD"[*prev_bc-0x94]);
                bool is_cmpg = (*prev_bc == 0x96 || *prev_bc == 0x98);
                gen_cmp_branch(mem_manager,exprs,stack,inst_head,op,ty,is_cmpg,
                               stack_sig_out,stack_sig_out_size);
            } else {
                src = stack.pop();

                // spill whatever left on the mimic stack
                spill_left_on_stack(mem_manager,exprs,stack,inst_head,
                                    stack_sig_out,stack_sig_out_size);
                assert(!src->dst()->is_status_flags());
                src = gen_test_inst(mem_manager,exprs,inst_head,src);
                gen_branch(mem_manager,exprs,inst_head,true,op,src);
            }
            break;
		case 0x9f: case 0xa0:	// if_icmp{eq,ne,lt,ge,gt,le}
		case 0xa1: case 0xa2:
		case 0xa3: case 0xa4:
			op = (Exp::Kind)(Exp::Beq + (bytecode - 0x9f));
            gen_cmp_branch(mem_manager,exprs,stack,inst_head,op,JIT_TYPE_INT,false,
                           stack_sig_out,stack_sig_out_size);
			break;
		case 0xa5: case 0xa6:	// if_acmp{eq,ne}
			op = (Exp::Kind)(Exp::Beq + (bytecode - 0xa5));
#ifndef JIT_SAPPHIRE
            gen_cmp_branch(mem_manager,exprs,stack,inst_head,op,JIT_TYPE_CLASS,false,
                           stack_sig_out,stack_sig_out_size);
#else
            gen_acmp_branch(mem_manager,exprs,stack,inst_head,op,
                            stack_sig_out,stack_sig_out_size);
#endif
            break;
		case 0xa7:	// goto
		case 0xc8:	// goto_w
            spill_left_on_stack(mem_manager,exprs,stack,inst_head,
                                stack_sig_out,stack_sig_out_size);
			break;
        case 0xa8:	// jsr
        case 0xc9:  // jsr_w
            {
                Inst *pc = exprs.lookup_inst(Exp::Next_PC,NULL,NULL,JIT_TYPE_RETADDR,inst_head);
                stack.push(pc);
                spill_left_on_stack(mem_manager,exprs,stack,inst_head,
                    stack_sig_out,stack_sig_out_size);
                // XXX - need to associate the successor Cfg_Node (if any) with "pc".
            }
            break;
        case 0xa9: // ret
            spill_left_on_stack(mem_manager,exprs,stack,inst_head,
                                stack_sig_out,stack_sig_out_size);
            gen_ret(mem_manager,exprs,inst_head,bc[1]);
			break;
		case 0xaa:  // tableswitch
		case 0xab:	// lookupswitch
            op = (bytecode == 0xaa) ? Exp::Tableswitch : Exp::Lookupswitch;
            src = stack.pop();
            //
            // spill whatever left on the mimic stack
            //
            spill_left_on_stack(mem_manager,exprs,stack,inst_head,
                                stack_sig_out,stack_sig_out_size);
            gen_switch(mem_manager,exprs,inst_head,op,src,node->extra_info);
            break;
		case 0xac:	// ireturn
		case 0xad:	// lreturn
		case 0xb0:	// areturn
		case 0xae:	// freturn
		case 0xaf:	// dreturn
            ends_in_return = 1;
            gen_return(mem_manager,exprs,stack,inst_head,stack.pop());
            stack.reset(); // ignore all remaining elements
			break;
		case 0xb1:	// return (without value)
            ends_in_return = 1;
            gen_return(mem_manager,exprs,stack,inst_head,NULL);
            stack.reset(); // ignore all remaining elements
            break;
		case 0xb2:	// getstatic
			index = (bc[1] << 8) + bc[2];
			gen_getstatic(mem_manager,exprs,stack,inst_head,compilationHandle,class_handle,index);
			break;
		case 0xb3:	// putstatic
			index = (bc[1] << 8) + bc[2];
			gen_putstatic(mem_manager,exprs,stack,inst_head,compilationHandle,class_handle,index);
			break;
		case 0xb4:	// getfield
			index = (bc[1] << 8) + bc[2];
			gen_getfield(mem_manager,exprs,stack,inst_head,compilationHandle,class_handle,index);
			break;
		case 0xb5:	// putfield
			index = (bc[1] << 8) + bc[2];
			gen_putfield(mem_manager,exprs,stack,inst_head,compilationHandle,class_handle,index,
                gc_requires_write_barriers);
			break;
		case 0xb6:	// invokevirtual
			index = (bc[1] << 8) + bc[2];
			gen_invokevirtual(mem_manager,exprs,stack,inst_head,compilationHandle,class_handle,index);
   			break;
		case 0xb7:	// invokespecial
			index = (bc[1] << 8) + bc[2]; 
			gen_invokespecial(mem_manager,exprs,stack,inst_head,compilationHandle,class_handle,index);
			break;
		case 0xb8:	// invokestatic
			index = (bc[1] << 8) + bc[2];
            gen_invokestatic(mem_manager,exprs,stack,inst_head,compilationHandle,class_handle,index);
			break;
        case 0xb9: // invokeinterface
            {
                index = (bc[1] << 8) + bc[2];
                unsigned n_args = bc[3];
                gen_invokeinterface(mem_manager,exprs,stack,inst_head,compilationHandle,class_handle,index,n_args);
            }
            break;
		case 0xbb:	// new
			index = (bc[1] << 8) + bc[2];
            gen_new(mem_manager,exprs,stack,inst_head,compilationHandle,class_handle,index);
			break;
        case 0xbc:	// newarray
			index = bc[1];	// type code of array
            gen_new_array(mem_manager,exprs,stack,inst_head,compilationHandle,
                         class_handle,index,stack.pop(),Exp::Newarray);
			break;
		case 0xbd: 	// anewarray
			index = (bc[1] << 8) + bc[2];
            gen_new_array(mem_manager,exprs,stack,inst_head,compilationHandle,
                         class_handle,index,stack.pop(),Exp::Anewarray);
		   	break;
		case 0xbe:	// arraylength
            stack.push(exprs.lookup_inst(Exp::Length,stack.pop(),NULL,
                                               JIT_TYPE_INT,inst_head));
			break;
		case 0xbf:	// athrow
            gen_athrow(mem_manager,exprs,stack,inst_head);
            // Doesn't really end in a return, but we still want an edge to
            // the epilog, so that it is reachable in a backwards DFS from
            // the epilog.
            //
            // Or maybe not.
            node->set_cold_code();
            node->set_athrow_block();
            ends_in_return = 1;
			break;
		case 0xc0:	// checkcast
			index = (bc[1] << 8) + bc[2];
            gen_checkcast(mem_manager,exprs,stack,inst_head,compilationHandle,class_handle,index);
			break;
		case 0xc1:	// instanceof
			index = (bc[1] << 8) + bc[2];
            gen_instanceof(mem_manager,exprs,stack,inst_head,compilationHandle,class_handle,index);
			break;
		case 0xc2:	// monitorenter
            gen_monitor(mem_manager,exprs,stack,inst_head,Exp::Monitorenter);
			break;
		case 0xc3:	// monitorexit
            gen_monitor(mem_manager,exprs,stack,inst_head,Exp::Monitorexit);
			break;
		case 0xc4:	// wide
			bytecode = bc[1];
			index = (bc[2] << 8) + bc[3];
			if (bytecode == 0x84) {
				// iinc
				int inc = (((char)bc[4]) << 8) + bc[5];
                gen_iinc(mem_manager,exprs,stack,inst_head,index,inc);
			} else {
				switch (bytecode) {
				case 0x15:	// iload
				case 0x16:	// lload
				case 0x17:	// fload
				case 0x18:	// dload
				case 0x19:	// aload
                    type = (O3_Jit_Type)("IJFDL"[bytecode-0x15]);
                    stack.push(exprs.lookup_vreg(index,type,inst_head));
                    break;
				case 0x36:	// istore
				case 0x37:	// lstore
				case 0x38:	// fstore
				case 0x39:	// dstore
				case 0x3a:	// astore
                    type = (O3_Jit_Type)("IJFDL"[bytecode-0x36]);
			        gen_assign(mem_manager,exprs,stack,inst_head,index,stack.pop(),type);
					break;
                case 0xa9: // ret
                    spill_left_on_stack(mem_manager,exprs,stack,inst_head,
                        stack_sig_out,stack_sig_out_size);
                    gen_ret(mem_manager,exprs,inst_head,index);
                    break;
                } // switch
			}
			break;
		case 0xc5: // multianewarray
        {
			index = (bc[1] << 8) + bc[2];
			int dimensions = bc[3];
  		    gen_multianewarray(mem_manager,exprs,stack,inst_head,
                               compilationHandle,class_handle,
                               dimensions,index);
          	break;
		}	
		case 0xc6:	// ifnull 
		case 0xc7:	// ifnonnull
        {
			Exp::Kind op = (Exp::Kind)(Exp::Beq + (bytecode - 0xc6));
            Inst *test = gen_test_inst(mem_manager,exprs,inst_head,stack.pop());

            //
            // spill whatever left on the mimic stack
            //
            spill_left_on_stack(mem_manager,exprs,stack,inst_head,
                                stack_sig_out,stack_sig_out_size);
            gen_branch(mem_manager,exprs,inst_head,true,op,test);
			break;
        }
		default:
			cout << "\t XXX " << class_name << "." << method_name
				 << " couldn't compile " << (unsigned)bytecode << endl;
            assert(0);
			break;
		} // switch

#ifdef PRINTABLE_O3
        update_ir_bc_mappings(inst_head, last_bc_inst, bc_index);
#endif // PRINTABLE_O3

#ifdef O3_VTune_Support1
		fprintf(fp_vtune_debug, "load_byte_index: %p\tbytecode: %x\n", bc_index, bytecode);
		fflush( fp_vtune_debug);
#endif

        bc += instruction_length(first_bc, bc_index);

	} // while

    if (stack_sig_out_size == -1)
    {
        spill_left_on_stack(mem_manager,exprs,stack,inst_head,
            stack_sig_out,stack_sig_out_size);
#ifdef PRINTABLE_O3
        update_ir_bc_mappings(inst_head, last_bc_inst, bc_index);
#endif // PRINTABLE_O3
    }

	//
	// take a snap shot of live cse at end of bb
	//
	exprs.live_lcse()->snap_shot_of_lcse();
}

