// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/o1_debugging_support.cpp,v 1.2 2001/08/13 10:00:42 xhshi Exp $
//

#include "defines.h"
#include <assert.h>
#include <iostream.h>
#include "orp_types.h"
#include "level_1a_jit_intf.h"
#include "jit.h"
#include "code_gen.h"
#include "o1_debugging_support.h"
#include "root_set_enum.h"
#include "code_emitter.h"
#include "stack.h"
#include "operand.h"
#include "lazy_code_selector.h"
#include "jit_runtime_support.h"


int  report_jvmdi_event_method_entry = true;
int  report_jvmdi_event_method_exit  = false;
int  report_jvmdi_event_frame_pop    = false;
// 
//   enable_jvmdi_event_exit = enable_jvmdi_event_method_exit | enable_jvmdi_event_frame_pop
//
int  report_jvmdi_event_exit         = false;
//
// generate code sequence:    if enable_jvmdi_event_method_entry == 1
//                                call jvmdi_method_entry_event
//  
void gen_jvmdi_event_method(Mem_Manager&     mem,
                            Code_Emitter&    emitter,
                            Stack&           stack,
                            Code_Patch*&     code_patch_list,
                            Jit_Method_Info *method_info,
                            bool             is_entry)
{
	stack.home_all();
	void *addr;
    int  *enable;
    if (is_entry) 
    {
        enable = &report_jvmdi_event_method_entry;
        addr = orp_get_rt_support_addr(JVMDI_RT_EVENT_METHOD_ENTRY);
    }
    else
    {
        enable = &report_jvmdi_event_exit;
        addr = orp_get_rt_support_addr(JVMDI_RT_EVENT_METHOD_EXIT);
    }
    //
    // code checking if enable_jvmdi_event flags
    //
    emitter.emit_alu(cmp_opc, &M_Opnd((unsigned)enable), &Imm_Opnd(1));
	emitter.emit_branch(cc_ne,0,1);
	int br_off = emitter.get_offset();
	char *br_patch = emitter.get_next() - 1;
    //
    // prepare method info
    //
    method_info->cs_info[method_info->cnt].call_IP = (unsigned)emitter.get_offset();
	unsigned patch_offset = emitter.get_offset()+1;
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 0;
	emitter.emit_call((char*)addr);
    method_info->cs_info[method_info->cnt].ret_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].outarg_bv = 0x0; // outarg 0 is a ref
    method_info->cs_info[method_info->cnt].m_handle = NULL;
    method_info->cs_info[method_info->cnt++].num_out_args = 0;

	code_patch_list = new(mem) Call_Patch(code_patch_list,patch_offset,(char*)addr);
    //
    // fill in branch target
    //
    *br_patch = emitter.get_offset() - br_off;
}


