// jit_export.cpp

#include "defines.h"
#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <iostream.h>
#include "orp_process.h"
#include "jit_intf.h"
#include "internal_jit_intf.h"
#include "jit_export.h"
#include "jit.h"
#include "code_gen.h"


extern bool L1a_do_dumpjit;
extern const char *O1a_envvar_METHODS;

extern "C"
JITExport void JIT_init(JIT_Handle j)
{
    cout << "Initializing Level 1a JIT dll." << endl;
    o1_jit = (JIT *) j;
}

extern "C"
JITExport void JIT_next_command_line_argument(const char *name, const char *arg)
{
    if(strcmp(name, "-jitO1a"))
        return;

    char *method_str = "METHODS=";

    if (strncmp(arg, method_str, strlen(method_str)) == 0)
        O1a_envvar_METHODS = arg + strlen(method_str);
    else if (strcmp(arg, "nodumpjit") == 0)
        L1a_do_dumpjit = false;
    else if (strcmp(arg, "instrument") == 0)
        instrumenting = true;
}

extern "C"
JITExport JIT_Result 
JIT_compile_method(Compile_Handle     compilation,              // in
                   Method_Handle      meth,                     // in
                   JIT_Flags          flags                     // in
                   )
{
#if 0
    return l1a_compile_method(compilation,meth,flags,cm_gen_method_code);
#else // PLDI Lazy GC map
    return l1a_compile_method(compilation,meth,flags,cm_gen_code);
#endif
}

extern "C"
JITExport JIT_Result 
JIT_gen_method_info(Compile_Handle     compilation,              // in
                    Method_Handle      meth,                     // in
                    JIT_Flags          flags                     // in
                    )
{
    //
    // only generate method info
    //
    return l1a_compile_method(compilation,meth,flags,cm_gen_method);
}

extern "C"
JITExport void
JIT_unwind_stack_frame(Method_Handle       method,               // in
                       Frame_Context      *context,              // in out
                       Boolean             is_first              // in
                       )
{
    L1a_UnwindStackFrame_Full(context, o1_method_get_info_block(method), is_first, 0);
}

extern "C"
JITExport void 
JIT_get_root_set_from_stack_frame(Method_Handle         method,        // in
                                  GC_Enumeration_Handle enum_handle,   // in
                                  Frame_Context        *context,       // in out
                                  Boolean               is_first       // in
                                  )
{
    L1a_EnumerateGcRefs(context,
        0,
        o1_method_get_info_block(method),
        enum_handle,
        is_first);
}


extern "C"
JITExport Boolean
JIT_can_enumerate(Method_Handle method,
                  uint32        eip
                  )
{
    return FALSE;
}

extern "C"
JITExport unsigned
JIT_num_breakpoints(Method_Handle method,
                    uint32        eip
                    )
{
    return l1a_num_breakpoints(method, eip);
}

extern "C"
JITExport void
JIT_get_breakpoints(Method_Handle method,      // in
                    uint32        *bp,         // out
                    Frame_Context *context     // in out
                    )
{
    l1a_get_breakpoints(method, bp, context);
}

extern "C"
JITExport void
JIT_fix_handler_context(Method_Handle      method,                     // in
                        Frame_Context     *context,                    // in out
                        Boolean            is_first                    // in
                        )
{
    L1a_FixHandlerContext(context, 0, o1_method_get_info_block(method), 0);
}

extern "C"
JITExport void *
JIT_get_address_of_this(Method_Handle       method,                     // in
                        const Frame_Context *context,                    // in
                        Boolean             is_first                    // in
                        )
{
    return l1a_get_address_of_this(method, (Frame_Context *)context, is_first);
}

extern "C"
JITExport Boolean
JIT_call_returns_a_reference(Method_Handle         method,              // in
                             const Frame_Context  *context              // in
                             )
{
    return l1a_call_returns_a_reference(method, context);
}

extern "C"
JITExport int32 
JIT_get_break_point_offset(Compile_Handle compilation,
                           Method_Handle  meth,
                           JIT_Flags      flags,
                           unsigned       bc_location)
{
    return l1a_get_break_point_offset(compilation,meth,flags,bc_location);
} 

extern "C"
JITExport void *
JIT_get_address_of_var(Frame_Context *context,
                       Boolean       is_first,
                       unsigned      var_no)
{
    return l1a_get_address_of_var(context,is_first,var_no);
}

extern "C"
JITExport void 
JIT_thread_recompile_methods() 
{
    _beginthread(l1a_thread_recompile_methods, 0, NULL);
}
