// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/data_emitter.h,v 1.2 2001/08/13 09:59:51 xhshi Exp $
//


#ifndef _DATA_EMITTER_H_
#define _DATA_EMITTER_H_

#include "x86.h"
#include "Mem_Manager.h"
#include <string.h>

union Value {
	int i;
	float f;
	double d;
	struct l {
		unsigned lo;
		unsigned hi;
	} l;
};

class Data_Label {
public:
	Data_Label(unsigned off,Data_Label *n) 
		: offset(off), next(n),code(NULL) {}
	unsigned offset;
	Data_Label *const next;
	char *code;
	void apply(char *data_block) {
		//
		// if code is NULL then no code refers to this label
		//
		if (code == NULL)
			return;
		Imm_Opnd((unsigned)data_block+offset).emit32(code);
	}
	void *operator new(size_t sz,Mem_Manager& m) {
		return m.alloc(sz);
	}
private:
};

class Data_Emitter {
public:
    Data_Emitter(Mem_Manager& m,unsigned sz) 
		: mem_manager(m), _size(sz), _offset(0), _labels(NULL) {
		_buffer = (char*)mem_manager.alloc(sz);
	}
    void emit_float(float f) {
		Value val;
		val.f = f;
		Imm_Opnd(val.i).emit32(_buffer+_offset);
		_offset += 4;
	}
	void emit_double(double d) {
		Value val;
		val.d = d;
		Imm_Opnd(val.l.hi).emit32(_buffer+_offset+4);
		Imm_Opnd(val.l.lo).emit32(_buffer+_offset);
		_offset += 8;
	}
	void emit_int(int i) {
		Imm_Opnd(i).emit32(_buffer+_offset);
		_offset += 4;
	}
	unsigned get_offset()	{return _offset;}
	unsigned get_size()		{return _size;}
	Data_Label *make_label() {
		return _labels = new(mem_manager) Data_Label(_offset,_labels);
	}
	void copy(char *data_block) {		
		memcpy(data_block,_buffer,_size);
		for (Data_Label *l = _labels; l != NULL; l = l->next) {
			l->apply(data_block);
		}
	}

private:
	Mem_Manager& mem_manager;
	unsigned _size, _offset;
	Data_Label *_labels;
	char *_buffer;
};

#endif // _DATA_EMITTER_H
