// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/os/nt/ia32/nt_exception_filter.cpp,v 1.6 2001/12/11 16:28:01 rlhudson Exp $
//



#include <platform.h>

#include "Class.h"
#include "Package.h"
#include "Environment.h"
#include "gc_for_orp.h"
#include "exceptions.h"
#include "orp_synch.h"
#include "method_lookup.h"
#include "orp_threads.h"
#include "orp_utils.h"
#include "compile.h"
#include "root_set_enum.h"

#include "exception_filter.h"

#include "jvmdi_clean.h"
#ifdef OBJECT_LOCK_V2
#include "../../../base_natives/common_olv2/thread_generic_olv2.h"
#endif 
int NT_exception_filter(LPEXCEPTION_POINTERS p_NT_exception) 
{

    // this filter catches _all_ null ptr exceptions including those caused by
    // ORP internal code.  To elimate confusion over what caused the null ptr
    // exception, we first make sure the exception was thrown inside a Java
    // method else assert(0); <--- means it was thrown by ORP C/C++ code.

    Global_Env *env = ORP_Global_State::loader_env;

    ORP_Code_Type orpct =
        orp_identify_eip((void *)p_NT_exception->ContextRecord->Eip);
    if(orpct != ORP_TYPE_JAVA) {
        // For now.  What is the correct way of handling a null ptr exception
        // thrown from native code?
        return EXCEPTION_CONTINUE_SEARCH;
    }

    volatile Java_java_lang_Object *exc = 0;
    switch(p_NT_exception->ExceptionRecord->ExceptionCode) {
    case STATUS_ACCESS_VIOLATION:
        // null pointer exception -- see ...\vc\include\winnt.h
        {
            // Lazy exception object creation
            exc = (Java_java_lang_Object *)env->java_lang_NullPointerException_Class;
        }
        break;

    case STATUS_INTEGER_DIVIDE_BY_ZERO:
        // divide by zero exception  -- see ...\vc\include\winnt.h
        {
            // Lazy exception object creation
            exc = (Java_java_lang_Object *)env->java_lang_ArithmeticException_Class;
        }
        break;

    case STATUS_PRIVILEGED_INSTRUCTION:
        {
            // privileged exception  -- see ...\vc\include\winnt.h

            // the jit/orp uses "outs" (opcode = 0x6e) as an "int 3"
            // to set breakpoints in jitted code (for stuff like enumerating
            // live references.)
            // save the breakpoint eip in the java thread block so that 
            // orp_at_a_jit_breakpoint() can restore it

            uint8 opcode = *( (uint8 *)(p_NT_exception->ContextRecord->Eip) );
            switch (opcode) {
            case 0x6e:
            case 0x6f:
                {   
                    void *getaddress__orp_at_a_jit_breakpoint();
                    void *address_of_at_a_jit_breakpoint = getaddress__orp_at_a_jit_breakpoint();

                    p_TLS_orpthread->regs.eip = (uint32)(p_NT_exception->ContextRecord->Eip);

                    p_NT_exception->ContextRecord->Eip = (unsigned long)(address_of_at_a_jit_breakpoint);
                    break;
                }
            default:
                {
                    assert(0);
                    orp_exit(99553);
                }
            }
            return EXCEPTION_CONTINUE_EXECUTION;
        }
        break;

    default:
        return EXCEPTION_CONTINUE_SEARCH;
    }

    assert(exc);
    Frame_Context fc;
    fc.p_edi = (uint32 *)&(p_NT_exception->ContextRecord->Edi);
    fc.p_esi = (uint32 *)&(p_NT_exception->ContextRecord->Esi);
    fc.p_ebx = (uint32 *)&(p_NT_exception->ContextRecord->Ebx);
    fc.p_ebp = (uint32 *)&(p_NT_exception->ContextRecord->Ebp);
    fc.p_eip = (uint32 *)&(p_NT_exception->ContextRecord->Eip);
    fc.esp   = p_NT_exception->ContextRecord->Esp;
    fc.ljf   = (uint32)get_orp_last_java_frame();

    // The exception object will be created by orp_null_ptr_throw.
    orp_null_ptr_throw(&fc, &exc);

    p_NT_exception->ContextRecord->Esp = fc.esp;
    p_NT_exception->ContextRecord->Eip = *fc.p_eip;
    p_NT_exception->ContextRecord->Ebp = *fc.p_ebp;
    p_NT_exception->ContextRecord->Ebx = *fc.p_ebx;
    p_NT_exception->ContextRecord->Esi = *fc.p_esi;
    p_NT_exception->ContextRecord->Edi = *fc.p_edi;
    p_NT_exception->ContextRecord->Eax = (uint32)exc;

    return EXCEPTION_CONTINUE_EXECUTION;
} //NT_exception_filter



int run_java_main(String *classname, char **j_argv, int j_argc, Global_Env *p_env)
{
    LPEXCEPTION_POINTERS p_NT_exception;
    // NT exception support
    
    __try { 

        Method *entry_point = find_entry_point(classname, p_env);
        if(!entry_point) {
            printf("Couldn't locate an entry point in %s\n", classname->bytes);
            orp_exit(1);
        }

        extern bool jvmdi_debugger;
        if (jvmdi_debugger) {
            void init_jvmdi_debugger();
            init_jvmdi_debugger();
        }

        void *java_argv =
              orp_create_array_of_strings(j_argv, j_argc);


        int old_floating_point_state = 0;
        int floating_point_temp = 0;
        __asm {
            // the below set the significand to 53 bits for doubles
            // this is "non-strict" mode i.e., not Java Spec compliant
            fnstcw WORD PTR [old_floating_point_state]
            fnstcw WORD PTR [floating_point_temp]
            and DWORD PTR[floating_point_temp], 0feffH
            or DWORD PTR [floating_point_temp], 0200H
            fldcw WORD PTR [floating_point_temp] 
        }

        run_main_entry_point(entry_point, java_argv);

        __asm {
            fldcw WORD PTR [old_floating_point_state] 
        }

        return 0;
    }
    __except ( p_NT_exception = GetExceptionInformation(), 
        NT_exception_filter(p_NT_exception) ) {

        assert(0);  // get here only if NT_null_ptr_filter() screws up

    }  // NT null pointer exception support
    return 1;

} //run_java_main

int call_the_run_method3( void * p_xx ){
    LPEXCEPTION_POINTERS p_NT_exception;
    int NT_exception_filter(LPEXCEPTION_POINTERS p_NT_exception);

    // NT null pointer exception support
    __try {  
        call_the_run_method(p_xx);
        return 0;
    }
    __except ( p_NT_exception = GetExceptionInformation(), 
        NT_exception_filter(p_NT_exception) ) {

        assert(0);  // get here only if NT_null_ptr_filter() screws up

        return 0;
    }  // NT null pointer exception support

}

#pragma optimize( "", off )
unsigned __stdcall call_the_run_method2( void * p_xx )
{
	ORP_thread *p_orp_thread = (ORP_thread *)p_xx;
    assert(p_orp_thread);
#ifdef OBJECT_LOCK_V2
    unsigned int stack_base = get_stack_pointer();
    stack_base &= STACK_MASK;

    unsigned int new_thread_local_storage_offset = 
                                (unsigned int)(&p_orp_thread) - stack_base;

    assert(thread_local_storage_offset == new_thread_local_storage_offset);
    assert(p_orp_thread->app_status == thread_is_birthing);

//	printf("+++++++:%x, should be %x\n", new_thread_local_storage_offset, thread_local_storage_offset );
#endif

    return call_the_run_method3((void *)p_orp_thread);
	
}
#pragma optimize( "", on )
