// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/Class_File_Loader.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//


#ifndef _CLASS_FILE_LOADER_H_
#define _CLASS_FILE_LOADER_H_

#include "environment.h"
 
#include "Class.h"
 


//
// Initialize string pool by preloading it with commonly used strings.
//
Loader_Exception init_loader(Global_Env& env);


//
// Load a class from memory.
//
ORPExport Class *load_class_from_memory(uint8 *bytecode,
                              int offset,
                              int length,
                              const char *class_name,
                              Class_Loader *cl,
                              Global_Env *env,
                              Loader_Result *result,
                              Loader_Exception *ld_exc);


#endif //_CLASS_FILE_LOADER_H_

