// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/pair_table.h,v 1.1 2001/09/14 18:01:59 rlhudson Exp $
//

#ifndef _pair_table_H_
#define _pair_table_H_

//
// Provides pair table support..
//


#include <iostream.h>
#include "platform.h"
#include "object_layout.h"
 
#include "orp_for_gc.h"
 
#include "hash_table.h"

class Pair_Table : Hash_Table {
public:
    Pair_Table();    

    virtual ~Pair_Table();

    int get_key_value(void *address);

    void set_key_value(void *address, 
                       unsigned value);

    unsigned add_entry(void *address);

	// obsolete: void add_entry_list(Java_java_lang_Object **address);

	int delete_entry(void *address);

    int decrement_entry(void *address);

    int increment_entry(void *address);

    void empty_all();

    bool is_present(void *p_addr);

    Pair_Table *merge(Pair_Table *rs) {
        cerr << "Error: Merge not supported for pair tables" << endl;
        assert(0);
        orp_exit(1);
        return this;
    }

    void *next(int *count);

    void *next_delete(void) { // delete after returning
        cerr << "Error: Pair Tables don't support next_delete" << endl;
        assert(0);
        orp_exit(1);
        return NULL;
    }

    void rewind() {
        Hash_Table::rewind();
    }

protected:

    void _extend();

    //
    // Storage for this hash table.
    //
    volatile unsigned *_value_table;

private:

};

#endif // _pair_table_H_

