// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/nursery_step_gen.h,v 1.6 2001/11/05 13:36:35 rlhudson Exp $
//


#ifndef _nursery_step_gen_H_
#define _nursery_step_gen_H_

//
// Generations which have nurseries and steps (usually the youngest gen.).
// A Step_Plus_Nursery_Generation is a Step_Generation with nurseries
// added.
//
//                Generation
//                    |
//                    |
//       ---------------------------
//       |                         |
//       |                         |
//    Step_Generation              |
//       |                         |
//       |                  Train_Generation
//       |
//  Step_Plus_Nursery_Generation
//



#include "step_generation.h"
#include "nursery.h"
#include "gc_space.h"

class Card_Table;
class Gc_Fast_Hooks;
class Gc_Plan;



extern int allocated_nurseries;

extern int free_nursery_hint;

// nurseries on the spent nurseries list need are available for collection.

// extern block_info *spent_nurseries;

// active nurseries are nurseries being used by the threads. Nurseries start on the free_nurseries list,
// move to the active_nurseries list and when full move to the spent_nurseries list. After a GC
// nurseries move from the spent_nurseries list to the free_nurseries list. Those on the active_nurseries
// list remain there to be reused by the threads.

// extern block_info *active_nurseries;

// nurseries on the free_nurseries list are available to be assigned to a thread
// extern block_info *free_nurseries;

// All other nurseries are associated with a thread local structure and being actively
// used by a thread to allocate objects in.

// This is the step that is used to age objects that are from nurseries. It is a list
// of blocks linked through the next field.

extern block_list_info *step;

// The blocks that are part of the step from area. These will be relink at the end of the GC.
extern block_info *step_from_blocks;


//
// We have more threads than nurseries and need to
// add some more.
//
void add_nurseries (int how_many);
block_info *p_cycle_nursery(block_info *p_old_nursery, bool returnNullOnFail);

// GC_FALSE_COLLECTION
// 
// Move the blocks in the spent nursery into the step and refill the
// nurseries with empty blocks. 
// Return true if you were successful and a full collection is not needed.
// otherwise return false. 
//
bool move_spent_nurseries_into_step();

class Step_Plus_Nursery_Generation : public Step_Generation {
public:
    Step_Plus_Nursery_Generation(unsigned char generation_number,
                                 Gc_Fast_Hooks *p_gc_hooks,
                                 Gc_Plan       *p_gc_plan,
		                         Gc_Interface  *p_container,
								 Generation    *p_superior,
                                 Card_Table    *p_card_table,
		                         Block_Store   *p_bs);

	virtual ~Step_Plus_Nursery_Generation();

	//
	// The GC interface gives each generation an opportunity to
	// clean up after a collection of that generation.
	//
	virtual void cleanup();

    // 
    // verify_nurseries is called during debuggin to make sure the
    // spent nursery list and the free nursery list are in sync.
    //
    bool verify_nurseries ();


#ifdef GC_SAPPHIRE 
    Nursery *p_sapphire_release_nursery(Nursery *p_nursery,
        bool returnNullOnFail);
	bool sapphire_move_spent_nurseries_into_focus_car();
	
//
// sapphire_move_spent_nurseries_into_focus_car
//
// Move the blocks in the spent nurseries into the focus car and refill
// the nurseries with empty blocks.
//
	bool sapphire_evict_spent_nurseries_into_focus_car(Car *focus_car);

#endif // GC_SAPPHIRE

	//
	// One of our nurseries encountered an allocation request for a
	// large object and passed it up to us.
	//
 
    virtual Java_java_lang_Object *
	Step_Plus_Nursery_Generation::gc_pinned_malloc(unsigned size, 
	                                               VTable *p_vt,
												   bool return_null_on_fail,
                                                   bool double_align                                             
                                                   ) {
		//
		// We pass it up to our own container, who manages the LOS object.
		//
		return _p_container->gc_pinned_malloc(size, p_vt, return_null_on_fail,
                                              double_align      
                                              );
	}
 
    //
    // Return the number of nurseries that have been filled but not
    // yet reclaimed. This is an estimate since there could be race conditions
    // while counting the number of nurseries.
    // Assumption - load of _p_spent_nurseries is done as volatile...

    unsigned long get_number_of_nurseries () {
        return allocated_nurseries;
    }

private:



    unsigned long _current_nursery;
    //
	// At nursery creation time this routine takes all the
	// nurseries and links them up into a free list.
	//
	void _link_free_nurseries(unsigned int start_index);

    unsigned long _number_of_nurseries;
    block_info *_p_nurseries[MAXIMUM_NURSERIES];

#ifdef GC_SAPPHIRE
    CRITICAL_SECTION _NurseryCriticalSection;
#endif // GC_SAPPHIRE
	//
	// Hook to hold all the nurseries that are exhausted and
	// await reclamation.
	//
	volatile Nursery *_p_spent_nurseries;
};


#endif // _nursery_step_gen_H_
