// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/nursery.h,v 1.4 2001/10/12 14:47:04 rlhudson Exp $
//

#ifndef _nursery_H_
#define _nursery_H_

//
// A Nursery is a Gc_Space. It is a container, or a repository of
// Java objects. 
//
//                          Gc_Space (abstract)
//                              |
//             ------------------------------------
//             |                                  |
//             |                                  |
//        Block_List (abstract)                   |
//      ---------------------                     |
//      |                    |                 Nursery
//     Car                  Step
//
//
//
// Unlike Cars and Steps, Nurseries comprise contiguous blocks.
// Therefore a Nursery inherits from Gc_Space instead of Block_List.
//
// To avoid making Java object allocation a point of serialization in
// multi-threaded programs, each Java thread is given its own nursery.
// When this is exhausted, it gets additional nurseries from a pool.
// When the pool is exhausted, a minor collection is triggered.
//
//


#endif // _nursery_H_

